/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSS4JOutInterceptor
extends AbstractWSS4JInterceptor {
    public static final String WSS4J_ACTION_MAP = "wss4j.action.map";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JOutInterceptor.class);
    private WSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
    private boolean mtomEnabled;

    public WSS4JOutInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JOutInterceptor(Map<String, Object> props) {
        this();
        this.setProperties(props);
    }

    public boolean isAllowMTOM() {
        return this.mtomEnabled;
    }

    public void setAllowMTOM(boolean allowMTOM) {
        this.mtomEnabled = allowMTOM;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && "RECV_RESULTS".equals(key) && !this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getInMessage().get(key);
        }
        return result;
    }

    @Override
    public void handleMessage(SoapMessage mc) throws Fault {
        if (!this.mtomEnabled) {
            String mtomKey = "mtom-enabled";
            if (mc.get(mtomKey) == Boolean.TRUE) {
                LOG.warning("MTOM will be disabled as the WSS4JOutInterceptor.mtomEnabled property is set to false");
            }
            mc.put(mtomKey, (Object)Boolean.FALSE);
        }
        if (mc.getContent(SOAPMessage.class) == null) {
            this.saajOut.handleMessage(mc);
        }
        mc.getInterceptorChain().add(this.ending);
    }

    @Override
    public void handleFault(SoapMessage message) {
        this.saajOut.handleFault(message);
    }

    public final WSS4JOutInterceptorInternal createEndingInterceptor() {
        return new WSS4JOutInterceptorInternal();
    }

    final class WSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        @Override
        public void handleMessage(SoapMessage mc) throws Fault {
            boolean doDebug = LOG.isLoggable(Level.FINE);
            if (doDebug) {
                LOG.fine("WSS4JOutInterceptor: enter handleMessage()");
            }
            if (mc == null) {
                return;
            }
            SoapVersion version = mc.getVersion();
            RequestData reqData = new RequestData();
            WSS4JOutInterceptor.this.translateProperties(mc);
            reqData.setMsgContext((Object)mc);
            reqData.setAttachmentCallbackHandler((CallbackHandler)new AttachmentCallbackHandler(mc));
            try {
                SOAPMessage saaj;
                String username;
                WSSConfig config = WSSConfig.getNewInstance();
                reqData.setWssConfig(config);
                this.configureActions(mc, doDebug, version, config);
                List actions = CastUtils.cast((List)WSS4JOutInterceptor.this.getProperty(mc, "handlerActions"));
                if (actions == null) {
                    String action = WSS4JOutInterceptor.this.getString("action", mc);
                    if (action == null) {
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_ACTION", LOG, new Object[0]), version.getReceiver());
                    }
                    actions = WSSecurityUtil.decodeHandlerAction((String)action, (WSSConfig)config);
                }
                if (actions.isEmpty()) {
                    return;
                }
                reqData.setUsername((String)WSS4JOutInterceptor.this.getOption("user"));
                if ((reqData.getUsername() == null || reqData.getUsername().equals("")) && (username = (String)WSS4JOutInterceptor.this.getProperty(reqData.getMsgContext(), "user")) != null) {
                    reqData.setUsername(username);
                }
                boolean userNameRequired = false;
                for (HandlerAction handlerAction : actions) {
                    if (handlerAction.getAction() != 2 && handlerAction.getAction() != 1 && handlerAction.getAction() != 64 || handlerAction.getActionToken() != null && handlerAction.getActionToken().getUser() != null) continue;
                    userNameRequired = true;
                    break;
                }
                if (userNameRequired && (reqData.getUsername() == null || reqData.getUsername().equals("")) && (String)WSS4JOutInterceptor.this.getOption("signatureUser") == null) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_USERNAME", LOG, new Object[0]), version.getReceiver());
                }
                if (doDebug) {
                    LOG.fine("Actor: " + reqData.getActor());
                }
                if ((saaj = mc.getContent(SOAPMessage.class)) == null) {
                    LOG.warning("SAAJOutHandler must be enabled for WS-Security!");
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_SAAJ_DOC", LOG, new Object[0]), version.getReceiver());
                }
                SOAPPart doc = saaj.getSOAPPart();
                WSS4JOutInterceptor.this.doSenderAction((Document)doc, reqData, actions, Boolean.TRUE.equals(WSS4JOutInterceptor.this.getProperty(mc, "org.apache.cxf.client")));
                if (doDebug) {
                    LOG.fine("WSS4JOutInterceptor: exit handleMessage()");
                }
            }
            catch (WSSecurityException e) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, version.getSender());
            }
            finally {
                reqData.clear();
                reqData = null;
            }
        }

        @Override
        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        @Override
        public String getId() {
            return WSS4JOutInterceptorInternal.class.getName();
        }

        @Override
        public String getPhase() {
            return "post-protocol";
        }

        @Override
        public void handleFault(SoapMessage message) {
        }

        private void configureActions(SoapMessage mc, boolean doDebug, SoapVersion version, WSSConfig config) {
            Map actionMap = CastUtils.cast((Map)WSS4JOutInterceptor.this.getProperty(mc, WSS4JOutInterceptor.WSS4J_ACTION_MAP));
            if (actionMap != null) {
                for (Map.Entry entry : actionMap.entrySet()) {
                    Class removedAction;
                    block7: {
                        removedAction = null;
                        try {
                            if (entry.getValue() instanceof Class) {
                                removedAction = config.setAction(((Integer)entry.getKey()).intValue(), (Class)entry.getValue());
                                break block7;
                            }
                            if (entry.getValue() instanceof Action) {
                                removedAction = config.setAction(((Integer)entry.getKey()).intValue(), (Action)entry.getValue());
                                break block7;
                            }
                            throw new SoapFault(new org.apache.cxf.common.i18n.Message("BAD_ACTION", LOG, new Object[0]), version.getReceiver());
                        }
                        catch (ClassCastException e) {
                            throw new SoapFault(new org.apache.cxf.common.i18n.Message("BAD_ACTION", LOG, new Object[0]), version.getReceiver());
                        }
                    }
                    if (!doDebug) continue;
                    if (removedAction != null) {
                        LOG.fine("Replaced Action: " + removedAction.getName() + " with Action: " + entry.getValue() + " for ID: " + entry.getKey());
                        continue;
                    }
                    LOG.fine("Added Action: " + entry.getValue() + " with ID: " + entry.getKey());
                }
            }
        }

        @Override
        public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
            return null;
        }
    }
}

