/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import java.lang.reflect.Method;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.validation.AbstractValidationInterceptor;
import org.apache.cxf.validation.ValidationProvider;

public class ValidationInInterceptor
extends AbstractValidationInterceptor {
    static final String INPUT_VALIDATION_FAILED = "input.validation.failed";

    public ValidationInInterceptor() {
        super("pre-invoke");
    }

    public ValidationInInterceptor(String phase) {
        super(phase);
    }

    @Override
    protected void handleValidation(Message message, Object resourceInstance, Method method, List<Object> arguments) {
        if (arguments.size() > 0) {
            try {
                ValidationProvider provider = this.getProvider(message);
                provider.validateParameters(resourceInstance, method, this.unwrapArgs(arguments).toArray());
                message.getExchange().put(ValidationProvider.class, provider);
            }
            catch (ValidationException ex) {
                message.getExchange().put(INPUT_VALIDATION_FAILED, true);
                throw ex;
            }
        }
    }

    protected List<Object> unwrapArgs(List<Object> arguments) {
        return arguments;
    }
}

