/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.interceptor.security.SecureAnnotationsInterceptor;
import org.apache.cxf.interceptor.security.SimpleAuthorizingInterceptor;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthorizingFilter
implements RequestHandler {
    private AbstractAuthorizingInInterceptor interceptor;

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        try {
            this.interceptor.handleMessage(m);
            return null;
        }
        catch (AccessDeniedException ex) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
    }

    public void setMethodRolesMap(Map<String, String> rolesMap) {
        this.checkInterceptor();
        SimpleAuthorizingInterceptor simple = new SimpleAuthorizingInterceptor();
        simple.setMethodRolesMap(rolesMap);
        this.interceptor = simple;
    }

    public void setSecuredObject(Object securedObject) {
        this.checkInterceptor();
        SecureAnnotationsInterceptor simple = new SecureAnnotationsInterceptor();
        simple.setSecuredObject(securedObject);
        this.interceptor = simple;
    }

    private void checkInterceptor() {
        if (this.interceptor != null) {
            throw new IllegalStateException("Filter has already been initialized");
        }
    }
}

