/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.catalog.OASISCatalogManagerHelper;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.validator.AbstractValidator;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;
import org.apache.cxf.tools.validator.internal.MIMEBindingValidator;
import org.apache.cxf.tools.validator.internal.SchemaValidator;
import org.apache.cxf.tools.validator.internal.Stax2DOM;
import org.apache.cxf.tools.validator.internal.UniqueBodyPartsValidator;
import org.apache.cxf.tools.validator.internal.WSDLRefValidator;
import org.apache.cxf.tools.validator.internal.WSIBPValidator;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDL11Validator
extends AbstractDefinitionValidator {
    protected static final Logger LOG = LogUtils.getL7dLogger(SchemaValidator.class);
    private final List<AbstractValidator> validators = new ArrayList<AbstractValidator>();

    public WSDL11Validator(Definition definition) {
        this(definition, (ToolContext)null);
    }

    public WSDL11Validator(Definition definition, ToolContext pe) {
        this(definition, pe, BusFactory.getThreadDefaultBus());
    }

    public WSDL11Validator(Definition definition, ToolContext pe, Bus b) {
        super(definition, pe, b);
    }

    private Document getWSDLDoc(String wsdl) {
        LOG.log(Level.FINE, new Message("VALIDATE_WSDL", LOG, new Object[]{wsdl}).toString());
        try {
            OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager((Bus)this.getBus());
            String nw = new OASISCatalogManagerHelper().resolve(catalogResolver, wsdl, null);
            if (nw == null) {
                nw = wsdl;
            }
            return new Stax2DOM().getDocument(URIParserUtil.getAbsoluteURI((String)nw));
        }
        catch (FileNotFoundException fe) {
            LOG.log(Level.WARNING, "Cannot find the wsdl " + wsdl + "to validate");
            return null;
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    @Override
    public boolean isValid() throws ToolException {
        String schemaDir = this.getSchemaDir();
        SchemaValidator schemaValidator = null;
        String[] schemas = (String[])this.env.get("schemaURL");
        String wsdl = (String)this.env.get("wsdlurl");
        Document doc = this.getWSDLDoc(wsdl);
        if (doc == null) {
            return true;
        }
        if (this.def == null) {
            try {
                this.def = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(wsdl);
            }
            catch (WSDLException e) {
                throw new ToolException((Throwable)e);
            }
        }
        WSDLRefValidator wsdlRefValidator = new WSDLRefValidator(this.def, doc, this.getBus());
        wsdlRefValidator.setSuppressWarnings(this.env.optionSet("suppressWarnings"));
        this.validators.add(wsdlRefValidator);
        if (this.env.fullValidateWSDL()) {
            this.validators.add(new UniqueBodyPartsValidator(this.def));
            this.validators.add(new WSIBPValidator(this.def));
            this.validators.add(new MIMEBindingValidator(this.def));
        }
        boolean notValid = false;
        for (AbstractValidator validator : this.validators) {
            if (validator.isValid()) continue;
            notValid = true;
            this.addErrorMessage(validator.getErrorMessage());
        }
        if (notValid) {
            throw new ToolException(this.getErrorMessage());
        }
        if (!this.env.fullValidateWSDL()) {
            return true;
        }
        if (!StringUtils.isEmpty((String)schemaDir)) {
            schemaValidator = new SchemaValidator(schemaDir, wsdl, schemas);
        } else {
            try {
                schemaValidator = new SchemaValidator(this.getDefaultSchemas(), wsdl, schemas);
            }
            catch (IOException e) {
                throw new ToolException("Schemas can not be loaded before validating wsdl", (Throwable)e);
            }
        }
        if (!schemaValidator.isValid()) {
            this.addErrorMessage(schemaValidator.getErrorMessage());
            throw new ToolException(this.getErrorMessage());
        }
        return true;
    }

    public String getSchemaDir() {
        String dir = "";
        dir = this.env.get("schemaDir") == null ? System.getProperty("cxf_schema_dir") : (String)this.env.get("schemaDir");
        return dir;
    }

    protected List<InputSource> getDefaultSchemas() throws IOException {
        ArrayList<InputSource> xsdList = new ArrayList<InputSource>();
        URL url = ClassLoaderUtils.getResource((String)"/schemas/configuration/parameterized-types.xsd", this.getClass());
        if (url != null) {
            InputSource is = new InputSource(url.openStream());
            is.setSystemId(url.toString());
            xsdList.add(is);
        }
        this.addDefaultSchemas("schemas/wsdl/", xsdList);
        return xsdList;
    }

    private void addDefaultSchemas(String location, List<InputSource> xsdList) throws IOException {
        ClassLoader clzLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = clzLoader.getResources(location);
        while (urls.hasMoreElements()) {
            File[] files;
            File file;
            URL url = urls.nextElement();
            if (url.toString().startsWith("jar")) {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarConnection.getJarFile();
                Enumeration<JarEntry> entry = jarFile.entries();
                while (entry.hasMoreElements()) {
                    URIResolver resolver;
                    JarEntry ele = entry.nextElement();
                    if (!ele.getName().endsWith(".xsd") || ele.getName().indexOf("schemas/wsdl/") <= -1 || !(resolver = new URIResolver(ele.getName())).isResolved()) continue;
                    InputSource is = new InputSource(resolver.getInputStream());
                    if (resolver.getURI() != null) {
                        is.setSystemId(resolver.getURI().toString());
                    } else {
                        is.setSystemId(ele.getName());
                    }
                    xsdList.add(is);
                }
                continue;
            }
            if (!url.toString().startsWith("file")) continue;
            URI loc = null;
            try {
                loc = url.toURI();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            if (loc == null || !(file = new File(loc)).exists() || (files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".xsd");
                }
            })) == null) continue;
            for (int i = 0; i < files.length; ++i) {
                InputSource is = new InputSource(files[i].toURI().toURL().openStream());
                is.setSystemId(files[i].toURI().toURL().toString());
                xsdList.add(is);
            }
        }
        this.sort(xsdList);
    }

    private void sort(List<InputSource> list) {
        Collections.sort(list, new Comparator<InputSource>(){

            @Override
            public int compare(InputSource i1, InputSource i2) {
                if (i1 == null && i2 != null) {
                    return -1;
                }
                if (i1 != null && i2 == null) {
                    return 1;
                }
                if (i1 == null && i2 == null) {
                    return -1;
                }
                return i1.getSystemId().compareTo(i2.getSystemId());
            }
        });
    }
}

