/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.BorrowedFromSiblingResult;
import org.apache.directory.mavibot.btree.Cursor;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.MemoryHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReferenceHolder;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Transaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class Node<K, V>
extends AbstractPage<K, V> {
    protected ElementHolder<Page<K, V>, K, V>[] children;

    Node(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        this.children = (ElementHolder[])Array.newInstance(ElementHolder.class, nbElems + 1);
    }

    Node(BTree<K, V> btree, long revision, K key, Page<K, V> leftPage, Page<K, V> rightPage) {
        super(btree, revision, 1);
        this.children = btree.isManaged() ? (ReferenceHolder[])Array.newInstance(ReferenceHolder.class, btree.getPageSize() + 1) : (MemoryHolder[])Array.newInstance(MemoryHolder.class, btree.getPageSize() + 1);
        this.children[0] = btree.createHolder(leftPage);
        this.children[1] = btree.createHolder(rightPage);
        Class<?> keyType = btree.getKeyType();
        this.keys = (Object[])Array.newInstance(keyType, btree.getPageSize());
        this.keys[0] = key;
    }

    Node(BTree<K, V> btree, long revision, K key, ElementHolder<Page<K, V>, K, V> leftPage, ElementHolder<Page<K, V>, K, V> rightPage) {
        super(btree, revision, 1);
        this.children = (ReferenceHolder[])Array.newInstance(ReferenceHolder.class, btree.getPageSize() + 1);
        this.children[0] = leftPage;
        this.children[1] = rightPage;
        Class<?> keyType = btree.getKeyType();
        this.keys = (Object[])Array.newInstance(keyType, btree.getPageSize());
        this.keys[0] = key;
    }

    @Override
    public InsertResult<K, V> insert(long revision, K key, V value) throws IOException {
        Page<K, V> child;
        InsertResult<K, V> result;
        int pos = this.findPos(key);
        if (pos < 0) {
            pos = -pos++;
        }
        if ((result = (child = this.children[pos].getValue(this.btree)).insert(revision, key, value)) instanceof ModifyResult) {
            return this.replaceChild(revision, (ModifyResult)result, pos);
        }
        SplitResult splitResult = (SplitResult)result;
        Object pivot = splitResult.getPivot();
        Page leftPage = splitResult.getLeftPage();
        Page rightPage = splitResult.getRightPage();
        result = this.nbElems == this.btree.getPageSize() ? this.addAndSplit(splitResult.getCopiedPages(), revision, pivot, leftPage, rightPage, pos) : this.insertChild(splitResult.getCopiedPages(), revision, pivot, leftPage, rightPage, pos);
        return result;
    }

    private RemoveResult<K, V> handleRemoveResult(RemoveResult<K, V> removeResult, int index, int pos, boolean found) throws IOException {
        Node<K, V> newPage = this.copy(this.revision);
        Page modifiedPage = removeResult.getModifiedPage();
        if (found) {
            newPage.children[index + 1] = this.createHolder(modifiedPage);
        } else {
            newPage.children[index] = this.createHolder(modifiedPage);
        }
        if (pos < 0) {
            newPage.keys[index] = removeResult.getModifiedPage().getLeftMostKey();
        }
        removeResult.setModifiedPage(newPage);
        removeResult.addCopiedPage(this);
        return removeResult;
    }

    private RemoveResult<K, V> handleRootRemove(MergedWithSiblingResult<K, V> mergedResult, int pos, boolean found) throws IOException {
        RemoveResult<K, V> removeResult = null;
        if (this.nbElems == 1) {
            removeResult = new RemoveResult(mergedResult.getCopiedPages(), mergedResult.getModifiedPage(), mergedResult.getRemovedElement());
            removeResult.addCopiedPage(this);
        } else {
            removeResult = this.removeKey(mergedResult, this.revision, pos);
        }
        return removeResult;
    }

    private DeleteResult<K, V> borrowFromRight(long revision, MergedWithSiblingResult<K, V> mergedResult, Node<K, V> sibling, int pos) throws IOException {
        Page modifiedPage;
        Node<K, V> newSibling = new Node<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        K siblingKey = sibling.children[0].getValue(this.btree).getLeftMostKey();
        System.arraycopy(sibling.keys, 1, newSibling.keys, 0, newSibling.getNbElems());
        System.arraycopy(sibling.children, 1, newSibling.children, 0, newSibling.getNbElems() + 1);
        Node<K, V> newNode = new Node<K, V>(this.btree, revision, this.nbElems);
        int index = Math.abs(pos);
        newNode.keys[this.nbElems - 1] = siblingKey;
        newNode.children[this.nbElems] = sibling.children[0];
        if (index < 2) {
            System.arraycopy(this.keys, 1, newNode.keys, 0, this.nbElems - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[0] = this.createHolder(modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 1, this.nbElems - 1);
        } else {
            if (index > 2) {
                System.arraycopy(this.keys, 0, newNode.keys, 0, index - 2);
            }
            newNode.keys[index - 2] = mergedResult.getModifiedPage().getLeftMostKey();
            if (index < this.nbElems) {
                System.arraycopy(this.keys, index, newNode.keys, index - 1, this.nbElems - index);
                System.arraycopy(this.children, index + 1, newNode.children, index, this.nbElems - index);
            }
            System.arraycopy(this.children, 0, newNode.children, 0, index - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index - 1] = this.createHolder(modifiedPage);
        }
        BorrowedFromRightResult<K, V> result = new BorrowedFromRightResult<K, V>(mergedResult.getCopiedPages(), newNode, newSibling, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(long revision, MergedWithSiblingResult<K, V> mergedResult, Node<K, V> sibling, int pos) throws IOException {
        Page modifiedPage;
        Page<K, V> siblingChild = sibling.children[sibling.nbElems].getValue(this.btree);
        Node<K, V> newSibling = new Node<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.keys, 0, newSibling.keys, 0, newSibling.getNbElems());
        System.arraycopy(sibling.children, 0, newSibling.children, 0, newSibling.getNbElems() + 1);
        Node<K, V> newNode = new Node<K, V>(this.btree, revision, this.nbElems);
        newNode.children[0] = this.createHolder(siblingChild);
        int index = Math.abs(pos);
        if (index < 2) {
            newNode.keys[0] = mergedResult.getModifiedPage().getLeftMostKey();
            System.arraycopy(this.keys, 1, newNode.keys, 1, this.nbElems - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[1] = this.createHolder(modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 2, this.nbElems - 1);
        } else {
            newNode.keys[0] = this.children[0].getValue(this.btree).getLeftMostKey();
            if (index > 2) {
                System.arraycopy(this.keys, 0, newNode.keys, 1, index - 2);
            }
            newNode.keys[index - 1] = mergedResult.getModifiedPage().getLeftMostKey();
            if (index < this.nbElems) {
                System.arraycopy(this.keys, index, newNode.keys, index, this.nbElems - index);
                System.arraycopy(this.children, index + 1, newNode.children, index + 1, this.nbElems - index);
            }
            System.arraycopy(this.children, 0, newNode.children, 1, index - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index] = this.createHolder(modifiedPage);
        }
        BorrowedFromLeftResult<K, V> result = new BorrowedFromLeftResult<K, V>(mergedResult.getCopiedPages(), newNode, newSibling, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> mergeWithSibling(long revision, MergedWithSiblingResult<K, V> mergedResult, Node<K, V> sibling, boolean isLeft, int pos) throws IOException {
        Page modifiedPage;
        Node<K, V> newNode = new Node<K, V>(this.btree, revision, this.btree.getPageSize());
        Tuple removedElement = mergedResult.getRemovedElement();
        int half = this.btree.getPageSize() / 2;
        int index = Math.abs(pos);
        if (isLeft) {
            System.arraycopy(sibling.keys, 0, newNode.keys, 0, half);
            System.arraycopy(sibling.children, 0, newNode.children, 0, half + 1);
            if (index < 2) {
                newNode.keys[half] = mergedResult.getModifiedPage().getLeftMostKey();
                System.arraycopy(this.keys, 1, newNode.keys, half + 1, half - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[half + 1] = this.createHolder(modifiedPage);
                System.arraycopy(this.children, 2, newNode.children, half + 2, half - 1);
            } else {
                newNode.keys[half] = this.children[0].getValue(this.btree).getLeftMostKey();
                if (index > 2) {
                    System.arraycopy(this.keys, 0, newNode.keys, half + 1, index - 2);
                }
                newNode.keys[half + index - 1] = mergedResult.getModifiedPage().getLeftMostKey();
                if (index < half) {
                    System.arraycopy(this.keys, index, newNode.keys, half + index, half - index);
                    System.arraycopy(this.children, index + 1, newNode.children, half + index + 1, half - index);
                }
                System.arraycopy(this.children, 0, newNode.children, half + 1, index - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[half + index] = this.createHolder(modifiedPage);
            }
        } else {
            if (index < 2) {
                System.arraycopy(this.keys, 1, newNode.keys, 0, half - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[0] = this.createHolder(modifiedPage);
                System.arraycopy(this.children, 2, newNode.children, 1, half - 1);
            } else {
                if (index > 2) {
                    System.arraycopy(this.keys, 0, newNode.keys, 0, index - 2);
                }
                System.arraycopy(this.children, 0, newNode.children, 0, index - 1);
                newNode.keys[index - 2] = mergedResult.getModifiedPage().getLeftMostKey();
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[index - 1] = this.createHolder(modifiedPage);
                if (index < half) {
                    System.arraycopy(this.keys, index, newNode.keys, index - 1, half - index);
                    System.arraycopy(this.children, index + 1, newNode.children, index, half - index);
                }
            }
            newNode.keys[half - 1] = sibling.findLeftMost().getKey();
            System.arraycopy(sibling.keys, 0, newNode.keys, half, half);
            System.arraycopy(sibling.children, 0, newNode.children, half, half + 1);
        }
        MergedWithSiblingResult<K, V> result = new MergedWithSiblingResult<K, V>(mergedResult.getCopiedPages(), newNode, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    @Override
    public DeleteResult<K, V> delete(long revision, K key, V value, Page<K, V> parent, int parentPos) throws IOException {
        int pos = this.findPos(key);
        boolean found = pos < 0;
        int index = pos;
        Page<K, V> child = null;
        DeleteResult<K, V> deleteResult = null;
        if (found) {
            index = -(pos + 1);
            child = this.children[-pos].getValue(this.btree);
            deleteResult = child.delete(revision, key, value, this, -pos);
        } else {
            child = this.children[pos].getValue(this.btree);
            deleteResult = child.delete(revision, key, value, this, pos);
        }
        if (deleteResult instanceof NotPresentResult) {
            return deleteResult;
        }
        if (deleteResult instanceof RemoveResult) {
            RemoveResult<K, V> removeResult = this.handleRemoveResult((RemoveResult)deleteResult, index, pos, found);
            return removeResult;
        }
        if (deleteResult instanceof BorrowedFromSiblingResult) {
            RemoveResult<K, V> removeResult = this.handleBorrowedResult((BorrowedFromSiblingResult)deleteResult, pos);
            return removeResult;
        }
        if (deleteResult instanceof MergedWithSiblingResult) {
            MergedWithSiblingResult mergedResult = (MergedWithSiblingResult)deleteResult;
            if (parent == null) {
                RemoveResult<K, V> result = this.handleRootRemove(mergedResult, pos, found);
                return result;
            }
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems > halfSize) {
                RemoveResult<K, V> result = this.removeKey(mergedResult, revision, pos);
                return result;
            }
            int siblingPos = this.selectSibling((Node)parent, parentPos);
            Node sibling = (Node)((Node)parent).children[siblingPos].getValue(this.btree);
            if (sibling.getNbElems() > halfSize) {
                if (siblingPos < parentPos) {
                    DeleteResult<K, V> result = this.borrowFromLeft(revision, mergedResult, sibling, pos);
                    return result;
                }
                DeleteResult<K, V> result = this.borrowFromRight(revision, mergedResult, sibling, pos);
                return result;
            }
            DeleteResult<K, V> result = this.mergeWithSibling(revision, mergedResult, sibling, siblingPos < parentPos, pos);
            return result;
        }
        return null;
    }

    private RemoveResult<K, V> handleBorrowedResult(BorrowedFromSiblingResult<K, V> borrowedResult, int pos) throws IOException {
        Page modifiedPage = borrowedResult.getModifiedPage();
        Page<K, V> modifiedSibling = borrowedResult.getModifiedSibling();
        Node<K, V> newPage = this.copy(this.revision);
        if (pos < 0) {
            pos = -(pos + 1);
            if (borrowedResult.isFromRight()) {
                newPage.keys[pos] = modifiedPage.findLeftMost().getKey();
                newPage.keys[pos + 1] = modifiedSibling.findLeftMost().getKey();
                newPage.children[pos + 1] = this.createHolder(modifiedPage);
                newPage.children[pos + 2] = this.createHolder(modifiedSibling);
            } else {
                newPage.keys[pos] = modifiedPage.findLeftMost().getKey();
                newPage.children[pos] = this.createHolder(modifiedSibling);
                newPage.children[pos + 1] = this.createHolder(modifiedPage);
            }
        } else if (borrowedResult.isFromRight()) {
            newPage.keys[pos] = modifiedSibling.findLeftMost().getKey();
            newPage.children[pos] = this.createHolder(modifiedPage);
            newPage.children[pos + 1] = this.createHolder(modifiedSibling);
        } else {
            newPage.keys[pos - 1] = modifiedPage.findLeftMost().getKey();
            newPage.children[pos - 1] = this.createHolder(modifiedSibling);
            newPage.children[pos] = this.createHolder(modifiedPage);
        }
        RemoveResult removeResult = new RemoveResult(borrowedResult.getCopiedPages(), newPage, borrowedResult.getRemovedElement());
        removeResult.addCopiedPage(this);
        return removeResult;
    }

    private RemoveResult<K, V> removeKey(MergedWithSiblingResult<K, V> mergedResult, long revision, int pos) throws IOException {
        Page modifiedPage;
        Node<K, V> newNode = new Node<K, V>(this.btree, revision, this.nbElems - 1);
        int index = Math.abs(pos) - 2;
        if (index < 0) {
            System.arraycopy(this.keys, 1, newNode.keys, 0, newNode.nbElems);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[0] = this.createHolder(modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 1, this.nbElems - 1);
        } else {
            if (index > 0) {
                System.arraycopy(this.keys, 0, newNode.keys, 0, index);
            }
            newNode.keys[index] = mergedResult.getModifiedPage().findLeftMost().getKey();
            if (index < this.nbElems - 2) {
                System.arraycopy(this.keys, index + 2, newNode.keys, index + 1, this.nbElems - index - 2);
            }
            System.arraycopy(this.children, 0, newNode.children, 0, index + 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index + 1] = this.createHolder(modifiedPage);
            if (index < this.nbElems - 2) {
                System.arraycopy(this.children, index + 3, newNode.children, index + 2, this.nbElems - index - 2);
            }
        }
        RemoveResult result = new RemoveResult(mergedResult.getCopiedPages(), newNode, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        return result;
    }

    @Override
    public V get(K key) throws IOException, KeyNotFoundException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue(this.btree).get(key);
        }
        return this.children[pos].getValue(this.btree).get(key);
    }

    @Override
    public BTree<V, V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue(this.btree).getValues(key);
        }
        return this.children[pos].getValue(this.btree).getValues(key);
    }

    @Override
    public boolean hasKey(K key) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue(this.btree).hasKey(key);
        }
        return this.children[pos].getValue(this.btree).hasKey(key);
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue(this.btree).contains(key, value);
        }
        return this.children[pos].getValue(this.btree).contains(key, value);
    }

    public void setValue(int pos, ElementHolder<Page<K, V>, K, V> value) {
        this.children[pos] = value;
    }

    public Page<K, V> getReference(int pos) throws IOException {
        if (pos < this.nbElems + 1) {
            return this.children[pos].getValue(this.btree);
        }
        return null;
    }

    @Override
    public Cursor<K, V> browse(K key, Transaction<K, V> transaction, LinkedList<ParentPos<K, V>> stack) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            pos = -pos;
        }
        stack.push(new ParentPos(this, pos));
        return this.children[pos].getValue(this.btree).browse(key, transaction, stack);
    }

    @Override
    public Cursor<K, V> browse(Transaction<K, V> transaction, LinkedList<ParentPos<K, V>> stack) throws IOException {
        stack.push(new ParentPos(this, 0));
        return this.children[0].getValue(this.btree).browse(transaction, stack);
    }

    private InsertResult<K, V> replaceChild(long revision, ModifyResult<K, V> result, int pos) throws IOException {
        Node<K, V> newPage = this.copy(revision);
        Page<K, V> modifiedPage = result.getModifiedPage();
        newPage.children[pos] = this.createHolder(modifiedPage);
        result.modifiedPage = newPage;
        result.addCopiedPage(this);
        return result;
    }

    private ElementHolder<Page<K, V>, K, V> createHolder(Page<K, V> page) throws IOException {
        if (this.btree.isManaged()) {
            ElementHolder holder = this.btree.getRecordManager().writePage(this.btree, page, this.revision);
            ((AbstractPage)page).setOffset(((ReferenceHolder)holder).getOffset());
            ((AbstractPage)page).setLastOffset(((ReferenceHolder)holder).getLastOffset());
            return holder;
        }
        return this.btree.createHolder(page);
    }

    private InsertResult<K, V> insertChild(List<Page<K, V>> copiedPages, long revision, K key, Page<K, V> leftPage, Page<K, V> rightPage, int pos) throws IOException {
        Node<K, V> newNode = new Node<K, V>(this.btree, revision, this.nbElems + 1);
        if (this.nbElems > 0) {
            System.arraycopy(this.keys, 0, newNode.keys, 0, pos);
            System.arraycopy(this.children, 0, newNode.children, 0, pos);
        }
        newNode.keys[pos] = key;
        newNode.children[pos] = this.createHolder(leftPage);
        newNode.children[pos + 1] = this.createHolder(rightPage);
        if (this.nbElems > 0) {
            System.arraycopy(this.keys, pos, newNode.keys, pos + 1, this.keys.length - pos);
            System.arraycopy(this.children, pos + 1, newNode.children, pos + 2, this.children.length - pos - 1);
        }
        ModifyResult<K, Object> result = new ModifyResult<K, Object>(copiedPages, newNode, null);
        result.addCopiedPage(this);
        return result;
    }

    private InsertResult<K, V> addAndSplit(List<Page<K, V>> copiedPages, long revision, K pivot, Page<K, V> leftPage, Page<K, V> rightPage, int pos) throws IOException {
        int middle = this.btree.getPageSize() >> 1;
        Node<K, V> newLeftPage = new Node<K, V>(this.btree, revision, middle);
        Node<K, V> newRightPage = new Node<K, V>(this.btree, revision, middle);
        if (pos < middle) {
            System.arraycopy(this.keys, 0, newLeftPage.keys, 0, pos);
            System.arraycopy(this.children, 0, newLeftPage.children, 0, pos);
            newLeftPage.keys[pos] = pivot;
            newLeftPage.children[pos] = this.createHolder(leftPage);
            newLeftPage.children[pos + 1] = this.createHolder(rightPage);
            System.arraycopy(this.keys, pos, newLeftPage.keys, pos + 1, middle - pos - 1);
            System.arraycopy(this.children, pos + 1, newLeftPage.children, pos + 2, middle - pos - 1);
            System.arraycopy(this.keys, middle, newRightPage.keys, 0, middle);
            System.arraycopy(this.children, middle, newRightPage.children, 0, middle + 1);
            SplitResult<Object, V> result = new SplitResult<Object, V>(copiedPages, this.keys[middle - 1], newLeftPage, newRightPage);
            result.addCopiedPage(this);
            return result;
        }
        if (pos == middle) {
            System.arraycopy(this.keys, 0, newLeftPage.keys, 0, middle);
            System.arraycopy(this.children, 0, newLeftPage.children, 0, middle);
            newLeftPage.children[middle] = this.createHolder(leftPage);
            System.arraycopy(this.keys, middle, newRightPage.keys, 0, middle);
            System.arraycopy(this.children, middle + 1, newRightPage.children, 1, middle);
            newRightPage.children[0] = this.createHolder(rightPage);
            SplitResult<K, V> result = new SplitResult<K, V>(copiedPages, pivot, newLeftPage, newRightPage);
            result.addCopiedPage(this);
            return result;
        }
        System.arraycopy(this.keys, 0, newLeftPage.keys, 0, middle);
        System.arraycopy(this.children, 0, newLeftPage.children, 0, middle + 1);
        System.arraycopy(this.keys, middle + 1, newRightPage.keys, 0, pos - middle - 1);
        System.arraycopy(this.children, middle + 1, newRightPage.children, 0, pos - middle - 1);
        newRightPage.keys[pos - middle - 1] = pivot;
        newRightPage.children[pos - middle - 1] = this.createHolder(leftPage);
        newRightPage.children[pos - middle] = this.createHolder(rightPage);
        System.arraycopy(this.keys, pos, newRightPage.keys, pos - middle, this.nbElems - pos);
        System.arraycopy(this.children, pos + 1, newRightPage.children, pos + 1 - middle, this.nbElems - pos);
        SplitResult<Object, V> result = new SplitResult<Object, V>(copiedPages, this.keys[middle], newLeftPage, newRightPage);
        result.addCopiedPage(this);
        return result;
    }

    protected Node<K, V> copy(long revision) {
        Node<K, V> newPage = new Node<K, V>(this.btree, revision, this.nbElems);
        System.arraycopy(this.keys, 0, newPage.keys, 0, this.nbElems);
        System.arraycopy(this.children, 0, newPage.children, 0, this.nbElems + 1);
        return newPage;
    }

    @Override
    public K getLeftMostKey() throws EndOfFileExceededException, IOException {
        return this.children[0].getValue(this.btree).getLeftMostKey();
    }

    @Override
    public K getRightMostKey() throws EndOfFileExceededException, IOException {
        int index = this.nbElems + 1 - 1;
        if (this.children[index] != null) {
            return this.children[index].getValue(this.btree).getRightMostKey();
        }
        return this.children[this.nbElems - 1].getValue(this.btree).getRightMostKey();
    }

    @Override
    public Tuple<K, V> findLeftMost() throws EndOfFileExceededException, IOException {
        return this.children[0].getValue(this.btree).findLeftMost();
    }

    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        return this.children[this.nbElems].getValue(this.btree).findRightMost();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node[");
        sb.append(super.toString());
        sb.append("] -> {");
        try {
            if (this.nbElems > 0) {
                if (this.children[0] == null) {
                    sb.append("null");
                } else {
                    sb.append('r').append(this.children[0].getValue(this.btree).getRevision());
                }
                for (int i = 0; i < this.nbElems; ++i) {
                    sb.append("|<").append(this.keys[i]).append(">|");
                    if (this.children[i + 1] == null) {
                        sb.append("null");
                        continue;
                    }
                    sb.append('r').append(this.children[i + 1].getValue(this.btree).getRevision());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        if (this.nbElems > 0) {
            try {
                sb.append(this.children[0].getValue(this.btree).dumpPage(tabs + "    "));
                for (int i = 0; i < this.nbElems; ++i) {
                    sb.append(tabs);
                    sb.append("<");
                    sb.append(this.keys[i]).append(">\n");
                    sb.append(this.children[i + 1].getValue(this.btree).dumpPage(tabs + "    "));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

