/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    private static final Token EOF = new Token(-4, null);
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    private static final String WHITE = " \t\n\r";
    private String _delimiters;
    private String _header;
    private boolean _skip;
    private int pos;

    public HeaderTokenizer(String header) {
        this(header, RFC822);
    }

    public HeaderTokenizer(String header, String delimiters) {
        this(header, delimiters, true);
    }

    public HeaderTokenizer(String header, String delimiters, boolean skipComments) {
        this._skip = skipComments;
        this._header = header;
        this._delimiters = delimiters;
    }

    public String getRemainder() {
        return this._header.substring(this.pos);
    }

    public Token next() throws ParseException {
        return this.readToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token peek() throws ParseException {
        int start = this.pos;
        try {
            Token token = this.readToken();
            return token;
        }
        finally {
            this.pos = start;
        }
    }

    private Token readAtomicToken() {
        int start = this.pos;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (this._delimiters.indexOf(this._header.charAt(this.pos)) == -1 && ch >= ' ' && ch < '\u007f') continue;
            break;
        }
        return new Token(-1, this._header.substring(start, this.pos));
    }

    private Token readToken() throws ParseException {
        if (this.pos >= this._header.length()) {
            return EOF;
        }
        char c = this._header.charAt(this.pos);
        if (c == '(') {
            Token comment = this.readComment();
            if (this._skip) {
                return this.readToken();
            }
            return comment;
        }
        if (c == '\"') {
            return this.readQuotedString();
        }
        if (WHITE.indexOf(c) != -1) {
            this.eatWhiteSpace();
            return this.readToken();
        }
        if (c < ' ' || c >= '\u007f' || this._delimiters.indexOf(c) != -1) {
            ++this.pos;
            return new Token(c, String.valueOf(c));
        }
        return this.readAtomicToken();
    }

    private String getEscapedValue(int start, int end) throws ParseException {
        StringBuffer value = new StringBuffer();
        for (int i = start; i < end; ++i) {
            char ch = this._header.charAt(i);
            if (ch == '\\') {
                if (++i == end) {
                    throw new ParseException("Invalid escape character");
                }
                value.append(this._header.charAt(i));
                continue;
            }
            if (ch == '\r') {
                if (i >= end - 1 || this._header.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            value.append(ch);
        }
        return value.toString();
    }

    private Token readComment() throws ParseException {
        int start = this.pos + 1;
        int nesting = 1;
        boolean requiresEscaping = false;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (ch == ')') {
                if (--nesting != 0) continue;
                break;
            }
            if (ch == '(') {
                ++nesting;
                continue;
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        if (nesting != 0) {
            throw new ParseException("Unbalanced comments");
        }
        String value = requiresEscaping ? this.getEscapedValue(start, this.pos) : this._header.substring(start, this.pos++);
        return new Token(-3, value);
    }

    private Token readQuotedString() throws ParseException {
        int start = this.pos + 1;
        boolean requiresEscaping = false;
        while (++this.pos < this._header.length()) {
            char ch = this._header.charAt(this.pos);
            if (ch == '\"') {
                String value = requiresEscaping ? this.getEscapedValue(start, this.pos++) : this._header.substring(start, this.pos++);
                return new Token(-2, value);
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        throw new ParseException("Missing '\"'");
    }

    private void eatWhiteSpace() {
        while (++this.pos < this._header.length() && WHITE.indexOf(this._header.charAt(this.pos)) != -1) {
        }
    }

    public static class Token {
        public static final int ATOM = -1;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        public static final int QUOTEDSTRING = -2;
        private int _type;
        private String _value;

        public Token(int type, String value) {
            this._type = type;
            this._value = value;
        }

        public int getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }
    }
}

