/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.protoc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.hadoop.maven.plugin.util.FileSetUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

@org.apache.maven.plugins.annotations.Mojo(name="protoc", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ProtocMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private File[] imports;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/java")
    private File output;
    @Parameter(required=true)
    private FileSet source;
    @Parameter(defaultValue="protoc")
    private String protocCommand;
    @Parameter(required=true)
    private String protocVersion;
    @Parameter(defaultValue="${project.build.directory}/hadoop-maven-plugins-protoc-checksums.json")
    private String checksumPath;

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.protocCommand);
            command.add("--version");
            Exec exec = new Exec((Mojo)this);
            ArrayList<String> out = new ArrayList<String>();
            if (exec.run(command, out) == 127) {
                this.getLog().error((CharSequence)("protoc, not found at: " + this.protocCommand));
                throw new MojoExecutionException("protoc failure");
            }
            if (out.isEmpty()) {
                this.getLog().error((CharSequence)("stdout: " + out));
                throw new MojoExecutionException("'protoc --version' did not return a version");
            }
            if (!((String)out.get(0)).endsWith(this.protocVersion)) {
                throw new MojoExecutionException("protoc version is '" + (String)out.get(0) + "', expected version is '" + this.protocVersion + "'");
            }
            if (!this.output.mkdirs() && !this.output.exists()) {
                throw new MojoExecutionException("Could not create directory: " + this.output);
            }
            ChecksumComparator comparator = new ChecksumComparator(this.checksumPath);
            boolean importsChanged = false;
            command = new ArrayList();
            command.add(this.protocCommand);
            command.add("--java_out=" + this.output.getCanonicalPath());
            if (this.imports != null) {
                for (File i : this.imports) {
                    if (comparator.hasChanged(i)) {
                        importsChanged = true;
                    }
                    command.add("-I" + i.getCanonicalPath());
                }
            }
            ArrayList<File> changedSources = new ArrayList<File>();
            boolean sourcesChanged = false;
            for (File f : FileSetUtils.convertFileSetToFiles(this.source)) {
                if (!comparator.hasChanged(f) && !importsChanged) continue;
                sourcesChanged = true;
                changedSources.add(f);
                command.add(f.getCanonicalPath());
            }
            if (!sourcesChanged && !importsChanged) {
                this.getLog().info((CharSequence)"No changes detected in protoc files, skipping generation.");
            } else {
                ArrayList<String> err;
                if (this.getLog().isDebugEnabled()) {
                    StringBuilder b = new StringBuilder();
                    b.append("Generating classes for the following protoc files: [");
                    String prefix = "";
                    for (File f : changedSources) {
                        b.append(prefix);
                        b.append(f.toString());
                        prefix = ", ";
                    }
                    b.append("]");
                    this.getLog().debug((CharSequence)b.toString());
                }
                if ((exec = new Exec((Mojo)this)).run(command, out = new ArrayList(), err = new ArrayList<String>()) != 0) {
                    this.getLog().error((CharSequence)"protoc compiler error");
                    for (String s : out) {
                        this.getLog().error((CharSequence)s);
                    }
                    for (String s : err) {
                        this.getLog().error((CharSequence)s);
                    }
                    throw new MojoExecutionException("protoc failure");
                }
                comparator.writeChecksums();
            }
        }
        catch (Throwable ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
        this.project.addCompileSourceRoot(this.output.getAbsolutePath());
    }

    public class ChecksumComparator {
        private final Map<String, Long> storedChecksums;
        private final Map<String, Long> computedChecksums;
        private final File checksumFile;

        ChecksumComparator(String checksumPath) throws IOException {
            this.checksumFile = new File(checksumPath);
            if (this.checksumFile.exists()) {
                ObjectMapper mapper = new ObjectMapper();
                this.storedChecksums = (Map)mapper.readValue(this.checksumFile, (TypeReference)new TypeReference<Map<String, Long>>(){});
            } else {
                this.storedChecksums = new HashMap<String, Long>(0);
            }
            this.computedChecksums = new HashMap<String, Long>();
        }

        public boolean hasChanged(File file) throws IOException {
            if (!file.exists()) {
                throw new FileNotFoundException("Specified protoc include or source does not exist: " + file);
            }
            if (file.isDirectory()) {
                return this.hasDirectoryChanged(file);
            }
            if (file.isFile()) {
                return this.hasFileChanged(file);
            }
            throw new IOException("Not a file or directory: " + file);
        }

        private boolean hasDirectoryChanged(File directory) throws IOException {
            File[] listing = directory.listFiles();
            boolean changed = false;
            for (File f : listing) {
                if (f.isDirectory()) {
                    if (!this.hasDirectoryChanged(f)) continue;
                    changed = true;
                    continue;
                }
                if (f.isFile()) {
                    if (!this.hasFileChanged(f)) continue;
                    changed = true;
                    continue;
                }
                ProtocMojo.this.getLog().debug((CharSequence)("Skipping entry that is not a file or directory: " + f));
            }
            return changed;
        }

        private boolean hasFileChanged(File file) throws IOException {
            long computedCsum = this.computeChecksum(file);
            Long storedCsum = this.storedChecksums.get(file.getCanonicalPath());
            return storedCsum == null || storedCsum != computedCsum;
        }

        private long computeChecksum(File file) throws IOException {
            String canonicalPath = file.getCanonicalPath();
            if (this.computedChecksums.containsKey(canonicalPath)) {
                return this.computedChecksums.get(canonicalPath);
            }
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[65536];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                int read;
                while ((read = in.read(buffer)) > 0) {
                    crc.update(buffer, 0, read);
                }
            }
            long computedCsum = crc.getValue();
            this.computedChecksums.put(canonicalPath, computedCsum);
            return crc.getValue();
        }

        public void writeChecksums() throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.checksumFile));){
                mapper.writeValue((OutputStream)out, this.computedChecksums);
                ProtocMojo.this.getLog().info((CharSequence)("Wrote protoc checksums to file " + this.checksumFile));
            }
        }
    }
}

