/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.nio.ByteBuffer;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionLog$KeySchema$;
import kafka.coordinator.transaction.TransactionLog$ValueSchema$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$;
    private final int DefaultNumPartitions;
    private final int DefaultSegmentBytes;
    private final short DefaultReplicationFactor;
    private final int DefaultMinInSyncReplicas;
    private final int DefaultLoadBufferSize;
    private final CompressionType EnforcedCompressionType;
    private final short EnforcedRequiredAcks;

    static {
        new TransactionLog$();
    }

    public int DefaultNumPartitions() {
        return this.DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return this.DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return this.DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return this.DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return this.EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return this.EnforcedRequiredAcks;
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForKey(int version) {
        return (Schema)TransactionLog$KeySchema$.MODULE$.ofVersion(version).getOrElse((Function0)new Serializable(version){
            public static final long serialVersionUID = 0L;
            private final int version$1;

            public final Nothing$ apply() {
                throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown transaction log message key schema version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.version$1)})));
            }
            {
                this.version$1 = version$1;
            }
        });
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForValue(int version) {
        return (Schema)TransactionLog$ValueSchema$.MODULE$.ofVersion(version).getOrElse((Function0)new Serializable(version){
            public static final long serialVersionUID = 0L;
            private final int version$2;

            public final Nothing$ apply() {
                throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown transaction log message value schema version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.version$2)})));
            }
            {
                this.version$2 = version$2;
            }
        });
    }

    public byte[] keyToBytes(String transactionalId) {
        Struct key = new Struct(TransactionLog$KeySchema$.MODULE$.CURRENT());
        key.set(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD(), (Object)transactionalId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        Struct struct;
        Struct value2 = new Struct(TransactionLog$ValueSchema$.MODULE$.Current());
        value2.set(TransactionLog$ValueSchema$.MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()));
        value2.set(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch()));
        value2.set(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField(), (Object)BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs()));
        value2.set(TransactionLog$ValueSchema$.MODULE$.TxnStatusField(), (Object)BoxesRunTime.boxToByte((byte)txnMetadata.txnState().byte()));
        value2.set(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp()));
        value2.set(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnStartTimestamp()));
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null)) {
            if (txnMetadata.topicPartitions().nonEmpty()) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction is not expected to have any partitions since its state is ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.txnState(), txnMetadata})));
            }
            struct = value2.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), null);
        } else {
            Map topicAndPartitions = txnMetadata.topicPartitions().groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicPartition x$1) {
                    return x$1.topic();
                }
            });
            Iterable partitionArray = (Iterable)topicAndPartitions.map((Function1)new Serializable(value2){
                public static final long serialVersionUID = 0L;
                private final Struct value$1;

                public final Struct apply(Tuple2<String, scala.collection.immutable.Set<TopicPartition>> x0$1) {
                    Tuple2<String, scala.collection.immutable.Set<TopicPartition>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)tuple2._2();
                        Struct topicPartitionsStruct = this.value$1.instance(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                        Integer[] partitionIds = (Integer[])((TraversableOnce)partitions.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Integer apply(TopicPartition topicPartition) {
                                return topicPartition.partition();
                            }
                        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
                        topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField(), (Object)topic);
                        topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField(), (Object)partitionIds);
                        Struct struct = topicPartitionsStruct;
                        return struct;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.value$1 = value$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            struct = value2.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), partitionArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(TransactionLog$ValueSchema$.MODULE$.CurrentVersion());
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version == TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION()) {
            String transactionalId = key.getString(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD());
            return new TxnKey(version, transactionalId);
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown version ", " from the transaction log message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)version)})));
    }

    public TransactionMetadata readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        short version;
        block6: {
            TransactionMetadata transactionMetadata;
            block5: {
                block4: {
                    if (buffer != null) break block4;
                    transactionMetadata = null;
                    break block5;
                }
                version = buffer.getShort();
                Schema valueSchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForValue(version);
                Struct value2 = valueSchema.read(buffer);
                if (version != TransactionLog$ValueSchema$.MODULE$.CurrentVersion()) break block6;
                Long producerId = value2.getLong(TransactionLog$ValueSchema$.MODULE$.ProducerIdField());
                Short epoch = value2.getShort(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField());
                Integer timeout = value2.getInt(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField());
                Byte stateByte = value2.getByte(TransactionLog$ValueSchema$.MODULE$.TxnStatusField());
                TransactionState state = TransactionMetadata$.MODULE$.byteToState(Predef$.MODULE$.Byte2byte(stateByte));
                Long entryTimestamp = value2.getLong(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField());
                Long startTimestamp = value2.getLong(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField());
                TransactionMetadata transactionMetadata2 = new TransactionMetadata(transactionalId, Predef$.MODULE$.Long2long(producerId), Predef$.MODULE$.Short2short(epoch), Predef$.MODULE$.Integer2int(timeout), state, (scala.collection.mutable.Set<TopicPartition>)Set$.MODULE$.empty(), Predef$.MODULE$.Long2long(startTimestamp), Predef$.MODULE$.Long2long(entryTimestamp));
                if (!state.equals(Empty$.MODULE$)) {
                    Object[] topicPartitionArray = value2.getArray(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                    Predef$.MODULE$.refArrayOps(topicPartitionArray).foreach((Function1)new Serializable(transactionMetadata2){
                        public static final long serialVersionUID = 0L;
                        private final TransactionMetadata transactionMetadata$1;

                        public final void apply(Object memberMetadataObj) {
                            Struct memberMetadata = (Struct)memberMetadataObj;
                            String topic = memberMetadata.getString(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField());
                            Object[] partitionIdArray = memberMetadata.getArray(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField());
                            TopicPartition[] topicPartitions = (TopicPartition[])Predef$.MODULE$.refArrayOps(partitionIdArray).map((Function1)new Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final String topic$1;

                                public final TopicPartition apply(Object partitionIdObj) {
                                    Integer partitionId = (Integer)partitionIdObj;
                                    return new TopicPartition(this.topic$1, Predef$.MODULE$.Integer2int(partitionId));
                                }
                                {
                                    this.topic$1 = topic$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicPartition.class)));
                            this.transactionMetadata$1.addPartitions((Set<TopicPartition>)Predef$.MODULE$.refArrayOps((Object[])topicPartitions).toSet());
                        }
                        {
                            this.transactionMetadata$1 = transactionMetadata$1;
                        }
                    });
                }
                transactionMetadata = transactionMetadata2;
            }
            return transactionMetadata;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown version ", " from the transaction log message value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)version)})));
    }

    private TransactionLog$() {
        MODULE$ = this;
        this.DefaultNumPartitions = 50;
        this.DefaultSegmentBytes = 0x6400000;
        this.DefaultReplicationFactor = (short)3;
        this.DefaultMinInSyncReplicas = 2;
        this.DefaultLoadBufferSize = 0x500000;
        this.EnforcedCompressionType = CompressionType.NONE;
        this.EnforcedRequiredAcks = (short)-1;
    }
}

