/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.api.Request$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcherBlockingSend;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001\u0005\u000e\u0002\t9\fW.\u001a\t\u0003#]q!AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\ta\u0001\u0015:fI\u00164\u0017B\u0001\r\u001a\u0005\u0019\u0019FO]5oO*\u0011acE\u0005\u0003\u001f1A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003=\u0019j\u0011a\b\u0006\u0003A\u0005\naaY8n[>t'BA\u0003#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dz\"\u0001\u0002(pI\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u00191f\r\u001c\u000f\u00051\ndBA\u00171\u001b\u0005q#BA\u0018\u0007\u0003\u0019a$o\\8u}%\tA#\u0003\u00023'\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001b6\u0005!IE/\u001a:bE2,'B\u0001\u001a\u0014!\tqr'\u0003\u00029?\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u001bI,\u0007\u000f\\5dC\n+hMZ3s!\taT(D\u0001\u0003\u0013\tq$AA\u0007SKBd\u0017nY1Ck\u001a4WM\u001d\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006i1o\\2lKR$\u0016.\\3pkR\u0004\"A\u0005\"\n\u0005\r\u001b\"aA%oi\"AQ\t\u0001B\u0001B\u0003%\u0011)\u0001\tt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K\"Aq\t\u0001B\u0001B\u0003%\u0011)A\u0005gKR\u001c\u0007nU5{K\"A\u0011\n\u0001B\u0001B\u0003%\u0011)A\u0004nCb<\u0016-\u001b;\t\u0011-\u0003!\u0011!Q\u0001\n\u0005\u000b\u0001\"\\5o\u0005f$Xm\u001d\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u0006qAm\u001c,fe&4\u0017nY1uS>t\u0007C\u0001\nP\u0013\t\u00016CA\u0004C_>dW-\u00198\t\u0011I\u0003!\u0011!Q\u0001\nM\u000babY8ogVlWM]\"p]\u001aLw\r\u0005\u0002U36\tQK\u0003\u0002W/\u0006!Q\u000f^5m\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003B\u0003%1W\r^2iKJLE\rC\u0003_\u0001\u0011\u0005q,\u0001\u0004=S:LGO\u0010\u000b\u000eA\u0006\u00147\rZ3gO\"L'n\u001b7\u0011\u0005q\u0002\u0001\"B\b^\u0001\u0004\u0001\u0002\"\u0002\u000f^\u0001\u0004i\u0002\"B\u0015^\u0001\u0004Q\u0003\"\u0002\u001e^\u0001\u0004Y\u0004\"\u0002!^\u0001\u0004\t\u0005\"B#^\u0001\u0004\t\u0005\"B$^\u0001\u0004\t\u0005\"B%^\u0001\u0004\t\u0005\"B&^\u0001\u0004\t\u0005\"B'^\u0001\u0004q\u0005\"\u0002*^\u0001\u0004\u0019\u0006\"\u0002/^\u0001\u0004\t\u0005b\u00028\u0001\u0005\u0004%Ia\\\u0001\u000eM\u0016$8\r[#oIB|\u0017N\u001c;\u0016\u0003A\u0004\"\u0001P9\n\u0005I\u0014!A\u0007*fa2L7-\u0019$fi\u000eDWM\u001d\"m_\u000e\\\u0017N\\4TK:$\u0007B\u0002;\u0001A\u0003%\u0001/\u0001\bgKR\u001c\u0007.\u00128ea>Lg\u000e\u001e\u0011\t\u000bY\u0004A\u0011I<\u0002\r\u0011|wk\u001c:l)\u0005A\bC\u0001\nz\u0013\tQ8C\u0001\u0003V]&$\b")
public class ReplicaFetcher
extends ShutdownableThread {
    public final Node kafka$tools$ReplicaFetcher$$sourceBroker;
    private final Iterable<TopicPartition> topicPartitions;
    public final ReplicaBuffer kafka$tools$ReplicaFetcher$$replicaBuffer;
    public final int kafka$tools$ReplicaFetcher$$fetchSize;
    private final int maxWait;
    private final int minBytes;
    private final boolean doVerification;
    private final ReplicaFetcherBlockingSend fetchEndpoint;

    private ReplicaFetcherBlockingSend fetchEndpoint() {
        return this.fetchEndpoint;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block5: {
            FetchResponse fetchResponse;
            block4: {
                fetcherBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getVerificationBarrier();
                LinkedHashMap requestMap = new LinkedHashMap();
                this.topicPartitions.foreach((Function1)new Serializable(this, requestMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;
                    private final LinkedHashMap requestMap$1;

                    public final FetchRequest.PartitionData apply(TopicPartition topicPartition) {
                        return this.requestMap$1.put(topicPartition, new FetchRequest.PartitionData(this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.getOffset(topicPartition), 0L, this.$outer.kafka$tools$ReplicaFetcher$$fetchSize));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.requestMap$1 = requestMap$1;
                    }
                });
                FetchRequest.Builder fetchRequestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)Request$.MODULE$.DebuggingConsumerId(), (int)this.maxWait, (int)this.minBytes, requestMap);
                this.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Issuing fetch request ";
                    }
                });
                fetchResponse = null;
                try {
                    ClientResponse clientResponse = this.fetchEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequestBuilder);
                    fetchResponse = (FetchResponse)clientResponse.responseBody();
                }
                finally {
                    if (fetchResponse != null) break block4;
                }
                FetchResponse.PartitionData emptyResponse = new FetchResponse.PartitionData(Errors.NONE, -1L, -1L, -1L, null, (BaseRecords)MemoryRecords.EMPTY);
                this.topicPartitions.foreach((Function1)new Serializable(this, emptyResponse){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;
                    private final FetchResponse.PartitionData emptyResponse$1;

                    public final void apply(TopicPartition topicAndPartition) {
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)this.emptyResponse$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.emptyResponse$1 = emptyResponse$1;
                    }
                });
                break block5;
            }
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)fetchResponse.responseData()).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcher $outer;

                public final void apply(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x0$5) {
                    Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x0$5;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(tp, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)partitionData);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done fetching";
            }
        });
        fetcherBarrier.await();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ready for verification";
            }
        });
        if (this.doVerification) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Do verification";
                }
            });
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x) {
                    Predef$.MODULE$.println(x);
                }
            });
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewFetcherBarrier();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created new barrier";
                }
            });
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done verification";
            }
        });
    }

    public ReplicaFetcher(String name, Node sourceBroker, Iterable<TopicPartition> topicPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification, Properties consumerConfig, int fetcherId) {
        this.kafka$tools$ReplicaFetcher$$sourceBroker = sourceBroker;
        this.topicPartitions = topicPartitions;
        this.kafka$tools$ReplicaFetcher$$replicaBuffer = replicaBuffer;
        this.kafka$tools$ReplicaFetcher$$fetchSize = fetchSize;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.fetchEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, new ConsumerConfig(consumerConfig), new Metrics(), Time.SYSTEM, fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Request$.MODULE$.DebuggingConsumerId()), BoxesRunTime.boxToInteger((int)fetcherId)})));
    }
}

