/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bloom;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.bloom.BloomFilterFactory;
import org.apache.lucene.codecs.bloom.DefaultBloomFilterFactory;
import org.apache.lucene.codecs.bloom.FuzzySet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class BloomFilteringPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "BloomFilter";
    public static final int VERSION_START = 3;
    public static final int VERSION_CURRENT = 3;
    static final String BLOOM_EXTENSION = "blm";
    BloomFilterFactory bloomFilterFactory = new DefaultBloomFilterFactory();
    private PostingsFormat delegatePostingsFormat;

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilterFactory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat) {
        this(delegatePostingsFormat, new DefaultBloomFilterFactory());
    }

    public BloomFilteringPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        FieldsConsumer fieldsConsumer = this.delegatePostingsFormat.fieldsConsumer(state);
        return new BloomFilteredFieldsConsumer(fieldsConsumer, state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    public String toString() {
        return "BloomFilteringPostingsFormat(" + this.delegatePostingsFormat + ")";
    }

    class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, FuzzySet> bloomFilters = new HashMap<FieldInfo, FuzzySet>();
        private SegmentWriteState state;
        private boolean closed;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        public void write(Fields fields) throws IOException {
            this.delegateFieldsConsumer.write(fields);
            block0: for (String field : fields) {
                BytesRef term;
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
                TermsEnum termsEnum = terms.iterator();
                FuzzySet bloomFilter = null;
                PostingsEnum postingsEnum = null;
                while ((term = termsEnum.next()) != null) {
                    if (bloomFilter == null) {
                        bloomFilter = BloomFilteringPostingsFormat.this.bloomFilterFactory.getSetForField(this.state, fieldInfo);
                        if (bloomFilter == null) continue block0;
                        assert (!this.bloomFilters.containsKey(field));
                        this.bloomFilters.put(fieldInfo, bloomFilter);
                    }
                    if ((postingsEnum = termsEnum.postings(postingsEnum, 0)).nextDoc() == Integer.MAX_VALUE) continue;
                    bloomFilter.addValue(term);
                }
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, FuzzySet>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, FuzzySet>>();
            for (Map.Entry<FieldInfo, FuzzySet> entry : this.bloomFilters.entrySet()) {
                FuzzySet bloomFilter = entry.getValue();
                if (BloomFilteringPostingsFormat.this.bloomFilterFactory.isSaturated(bloomFilter, entry.getKey())) continue;
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            try (IndexOutput bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);){
                CodecUtil.writeIndexHeader((DataOutput)bloomOutput, (String)BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, (int)3, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
                bloomOutput.writeString(BloomFilteringPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    FuzzySet bloomFilter = (FuzzySet)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
                CodecUtil.writeFooter((IndexOutput)bloomOutput);
            }
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, FuzzySet bloomFilter, FieldInfo fieldInfo) throws IOException {
            FuzzySet rightSizedSet = BloomFilteringPostingsFormat.this.bloomFilterFactory.downsize(fieldInfo, bloomFilter);
            if (rightSizedSet == null) {
                rightSizedSet = bloomFilter;
            }
            rightSizedSet.serialize((DataOutput)bloomOutput);
        }
    }

    static class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, FuzzySet> bloomsByFieldName = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            ChecksumIndexInput bloomIn = null;
            boolean success = false;
            try {
                bloomIn = state.directory.openChecksumInput(bloomFileName, state.context);
                CodecUtil.checkIndexHeader((DataInput)bloomIn, (String)BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, (int)3, (int)3, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)bloomIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numBlooms = bloomIn.readInt();
                for (int i = 0; i < numBlooms; ++i) {
                    int fieldNum = bloomIn.readInt();
                    FuzzySet bloom = FuzzySet.deserialize((DataInput)bloomIn);
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                    this.bloomsByFieldName.put(fieldInfo.name, bloom);
                }
                CodecUtil.checkFooter((ChecksumIndexInput)bloomIn);
                IOUtils.close((Closeable[])new Closeable[]{bloomIn});
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{bloomIn, this.delegateFieldsProducer});
                throw throwable;
            }
        }

        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        public void close() throws IOException {
            this.delegateFieldsProducer.close();
        }

        public Terms terms(String field) throws IOException {
            FuzzySet filter = this.bloomsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new BloomFilteredTerms(result, filter);
        }

        public int size() {
            return this.delegateFieldsProducer.size();
        }

        public long ramBytesUsed() {
            long sizeInBytes = this.delegateFieldsProducer != null ? this.delegateFieldsProducer.ramBytesUsed() : 0L;
            for (Map.Entry<String, FuzzySet> entry : this.bloomsByFieldName.entrySet()) {
                sizeInBytes += (long)(entry.getKey().length() * 2);
                sizeInBytes += entry.getValue().ramBytesUsed();
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.addAll(Accountables.namedAccountables((String)"field", this.bloomsByFieldName));
            if (this.delegateFieldsProducer != null) {
                resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.delegateFieldsProducer));
            }
            return Collections.unmodifiableList(resources);
        }

        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.bloomsByFieldName.size() + ",delegate=" + this.delegateFieldsProducer + ")";
        }

        final class BloomFilteredTermsEnum
        extends TermsEnum {
            private Terms delegateTerms;
            private TermsEnum delegateTermsEnum;
            private final FuzzySet filter;

            public BloomFilteredTermsEnum(Terms delegateTerms, FuzzySet filter) throws IOException {
                this.delegateTerms = delegateTerms;
                this.filter = filter;
            }

            void reset(Terms delegateTerms) throws IOException {
                this.delegateTerms = delegateTerms;
                this.delegateTermsEnum = null;
            }

            private TermsEnum delegate() throws IOException {
                if (this.delegateTermsEnum == null) {
                    this.delegateTermsEnum = this.delegateTerms.iterator();
                }
                return this.delegateTermsEnum;
            }

            public BytesRef next() throws IOException {
                return this.delegate().next();
            }

            public boolean seekExact(BytesRef text) throws IOException {
                if (this.filter.contains(text) == FuzzySet.ContainsResult.NO) {
                    return false;
                }
                return this.delegate().seekExact(text);
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                return this.delegate().seekCeil(text);
            }

            public void seekExact(long ord) throws IOException {
                this.delegate().seekExact(ord);
            }

            public BytesRef term() throws IOException {
                return this.delegate().term();
            }

            public long ord() throws IOException {
                return this.delegate().ord();
            }

            public int docFreq() throws IOException {
                return this.delegate().docFreq();
            }

            public long totalTermFreq() throws IOException {
                return this.delegate().totalTermFreq();
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                return this.delegate().postings(reuse, flags);
            }
        }

        class BloomFilteredTerms
        extends Terms {
            private Terms delegateTerms;
            private FuzzySet filter;

            public BloomFilteredTerms(Terms terms, FuzzySet filter) {
                this.delegateTerms = terms;
                this.filter = filter;
            }

            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.delegateTerms.intersect(compiled, startTerm);
            }

            public TermsEnum iterator() throws IOException {
                return new BloomFilteredTermsEnum(this.delegateTerms, this.filter);
            }

            public long size() throws IOException {
                return this.delegateTerms.size();
            }

            public long getSumTotalTermFreq() throws IOException {
                return this.delegateTerms.getSumTotalTermFreq();
            }

            public long getSumDocFreq() throws IOException {
                return this.delegateTerms.getSumDocFreq();
            }

            public int getDocCount() throws IOException {
                return this.delegateTerms.getDocCount();
            }

            public boolean hasFreqs() {
                return this.delegateTerms.hasFreqs();
            }

            public boolean hasOffsets() {
                return this.delegateTerms.hasOffsets();
            }

            public boolean hasPositions() {
                return this.delegateTerms.hasPositions();
            }

            public boolean hasPayloads() {
                return this.delegateTerms.hasPayloads();
            }

            public BytesRef getMin() throws IOException {
                return this.delegateTerms.getMin();
            }

            public BytesRef getMax() throws IOException {
                return this.delegateTerms.getMax();
            }
        }
    }
}

