/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.interpolation;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.object.FieldBasedObjectInterpolator;
import org.codehaus.plexus.interpolation.object.ObjectInterpolationWarning;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class AssemblyInterpolator
extends AbstractLogEnabled {
    private static final Set<String> INTERPOLATION_BLACKLIST;
    private static final Properties ENVIRONMENT_VARIABLES;

    public Assembly interpolate(Assembly assembly, MavenProject project, AssemblerConfigurationSource configSource) throws AssemblyInterpolationException {
        HashSet<String> blacklistFields = new HashSet<String>(FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_FIELD_NAMES);
        blacklistFields.addAll(INTERPOLATION_BLACKLIST);
        Set blacklistPkgs = FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_PACKAGE_PREFIXES;
        FieldBasedObjectInterpolator objectInterpolator = new FieldBasedObjectInterpolator(blacklistFields, blacklistPkgs);
        Interpolator interpolator = AssemblyInterpolator.buildInterpolator(project, configSource);
        PrefixAwareRecursionInterceptor interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
        try {
            objectInterpolator.interpolate((Object)assembly, interpolator, (RecursionInterceptor)interceptor);
        }
        catch (InterpolationException e) {
            throw new AssemblyInterpolationException("Failed to interpolate assembly with ID: " + assembly.getId() + ". Reason: " + e.getMessage(), e);
        }
        finally {
            interpolator.clearAnswers();
        }
        if (objectInterpolator.hasWarnings() && this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("One or more minor errors occurred while interpolating the assembly with ID: " + assembly.getId() + ":\n");
            List warnings = objectInterpolator.getWarnings();
            for (ObjectInterpolationWarning warning : warnings) {
                sb.append('\n').append(warning);
            }
            sb.append("\n\nThese values were SKIPPED, but the assembly process will continue.\n");
            this.getLogger().debug(sb.toString());
        }
        return assembly;
    }

    public static Interpolator buildInterpolator(MavenProject project, AssemblerConfigurationSource configSource) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        MavenSession session = configSource.getMavenSession();
        if (session != null) {
            Properties userProperties = null;
            try {
                userProperties = session.getExecutionProperties();
            }
            catch (NoSuchMethodError nsmer) {
                // empty catch block
            }
            if (userProperties != null) {
                interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(userProperties));
            }
        }
        interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, project.getProperties(), true));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)project, true));
        Properties settingsProperties = new Properties();
        if (configSource.getLocalRepository() != null) {
            settingsProperties.setProperty("localRepository", configSource.getLocalRepository().getBasedir());
            settingsProperties.setProperty("settings.localRepository", configSource.getLocalRepository().getBasedir());
        } else if (session != null && session.getSettings() != null) {
            settingsProperties.setProperty("localRepository", session.getSettings().getLocalRepository());
            settingsProperties.setProperty("settings.localRepository", configSource.getLocalRepository().getBasedir());
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(settingsProperties));
        Properties commandLineProperties = System.getProperties();
        if (session != null) {
            commandLineProperties = new Properties();
            if (session.getExecutionProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getExecutionProperties());
            }
            if (session.getUserProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
            }
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(commandLineProperties));
        interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(Collections.singletonList("env."), ENVIRONMENT_VARIABLES, true));
        interpolator.addPostProcessor((InterpolationPostProcessor)new PathTranslatingPostProcessor(project.getBasedir()));
        return interpolator;
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "interpolator-internal");
            this.enableLogging(logger);
        }
        return logger;
    }

    static {
        Properties environmentVariables;
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("outputFileNameMapping");
        blacklist.add("outputDirectoryMapping");
        blacklist.add("outputDirectory");
        INTERPOLATION_BLACKLIST = blacklist;
        try {
            environmentVariables = CommandLineUtils.getSystemEnvVars((boolean)false);
        }
        catch (IOException e) {
            environmentVariables = new Properties();
        }
        ENVIRONMENT_VARIABLES = environmentVariables;
    }

    private static final class PathTranslatingPostProcessor
    implements InterpolationPostProcessor {
        private final File basedir;

        public PathTranslatingPostProcessor(File basedir) {
            this.basedir = basedir;
        }

        public Object execute(String expression, Object value) {
            String path = String.valueOf(value);
            return AssemblyFileUtils.makePathRelativeTo(path, this.basedir);
        }
    }
}

