/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.FileUtils;

public class InstallPluginsMojo
extends AbstractMojo {
    public static final String PROP_UNPACK_PLUGIN = "eclipse.unpack";
    private File eclipseDir;
    private boolean overwrite;
    private Collection artifacts;
    private String pluginDependencyTypes;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder projectBuilder;
    private ArchiverManager archiverManager;
    private InputHandler inputHandler;
    private File pluginsDir;
    private Maven2OsgiConverter maven2OsgiConverter;

    public InstallPluginsMojo() {
    }

    protected InstallPluginsMojo(File eclipseDir, boolean overwrite, List dependencyArtifacts, String pluginDependencyTypes, ArtifactRepository localRepository, MavenProjectBuilder projectBuilder, ArchiverManager archiverManager, InputHandler inputHandler, Log log) {
        this.eclipseDir = eclipseDir;
        this.overwrite = overwrite;
        this.artifacts = dependencyArtifacts;
        this.pluginDependencyTypes = pluginDependencyTypes;
        this.localRepository = localRepository;
        this.projectBuilder = projectBuilder;
        this.archiverManager = archiverManager;
        this.inputHandler = inputHandler;
        this.setLog(log);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.eclipseDir == null) {
            String eclipseDirString;
            this.getLog().info((CharSequence)"Eclipse directory? ");
            try {
                eclipseDirString = this.inputHandler.readLine();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read from standard input", (Exception)e);
            }
            this.eclipseDir = new File(eclipseDirString);
        }
        if (this.eclipseDir.exists() && !this.eclipseDir.isDirectory()) {
            throw new MojoFailureException("Invalid Eclipse directory: " + this.eclipseDir);
        }
        if (!this.eclipseDir.exists()) {
            this.eclipseDir.mkdirs();
        }
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (this.pluginDependencyTypes.indexOf(artifact.getType()) > -1) {
                MavenProject project;
                this.getLog().debug((CharSequence)("Processing Eclipse plugin dependency: " + artifact.getId()));
                try {
                    project = this.projectBuilder.buildFromRepository(artifact, Collections.EMPTY_LIST, this.localRepository, true);
                }
                catch (ProjectBuildingException e) {
                    throw new MojoExecutionException("Failed to load project metadata (POM) for: " + artifact.getId(), (Exception)((Object)e));
                }
                this.install(artifact, project);
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping dependency: " + artifact.getId() + ". Set pluginDependencyTypes with a comma-separated list of types to change this."));
        }
    }

    private void install(Artifact artifact, MavenProject project) throws MojoExecutionException, MojoFailureException {
        if (this.pluginsDir == null) {
            this.pluginsDir = new File(this.eclipseDir, "plugins");
        }
        if (!this.pluginsDir.exists() || !this.pluginsDir.isDirectory()) {
            throw new MojoFailureException("Invalid Eclipse directory: " + this.eclipseDir + " (plugins directory is missing or not a directory).");
        }
        boolean installAsJar = true;
        Properties properties = project.getProperties();
        if (properties != null) {
            installAsJar = Boolean.valueOf(properties.getProperty(PROP_UNPACK_PLUGIN, "false")) == false;
        }
        Attributes attributes = null;
        try {
            JarFile jar = new JarFile(artifact.getFile(), false);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                this.getLog().debug((CharSequence)("Ignoring " + artifact.getArtifactId() + " as it is does not have a Manifest (and so is not an OSGi bundle)"));
                return;
            }
            attributes = manifest.getMainAttributes();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read manifest of plugin " + artifact.getFile().getAbsolutePath(), (Exception)e);
        }
        String pluginName = this.formatEclipsePluginName(artifact);
        File pluginFile = new File(this.pluginsDir, pluginName + ".jar");
        File pluginDir = new File(this.pluginsDir, pluginName);
        boolean skipped = true;
        String bundleName = attributes.getValue("Bundle-Name");
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null && bundleName == null) {
            this.getLog().debug((CharSequence)("Ignoring " + artifact.getArtifactId() + " as it is not an OSGi bundle (no Bundle-SymbolicName or Bundle-Name in manifest)"));
            return;
        }
        if (this.overwrite) {
            if (pluginFile.exists() || pluginDir.exists()) {
                this.getLog().warn((CharSequence)("Overwriting old plugin with contents of: " + artifact.getId()));
                this.getLog().debug((CharSequence)("Removing old plugin from both: " + pluginFile + " and: " + pluginDir));
                try {
                    FileUtils.forceDelete((File)pluginDir);
                    FileUtils.forceDelete((File)pluginFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to remove old plugin from: " + pluginFile + " or: " + pluginDir, (Exception)e);
                }
                this.getLog().debug((CharSequence)"Removal of old plugin is complete; proceeding with plugin installation.");
            }
            this.performFileOperations(installAsJar, artifact, pluginFile, pluginDir);
            skipped = false;
        } else if (installAsJar && !pluginFile.exists()) {
            this.performFileOperations(installAsJar, artifact, pluginFile, pluginDir);
            skipped = false;
        } else if (!installAsJar && !pluginDir.exists()) {
            this.performFileOperations(installAsJar, artifact, pluginFile, pluginDir);
            skipped = false;
        }
        if (skipped) {
            if (installAsJar) {
                this.getLog().info((CharSequence)("Skipping plugin installation for: " + artifact.getId() + "; file: " + pluginFile + " already exists. Set overwrite = true to override this."));
            } else if (!installAsJar) {
                this.getLog().info((CharSequence)("Skipping plugin installation for: " + artifact.getId() + "; directory: " + pluginDir + " already exists. Set overwrite = true to override this."));
            }
        }
    }

    private void performFileOperations(boolean installAsJar, Artifact artifact, File pluginFile, File pluginDir) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (installAsJar) {
            try {
                this.getLog().debug((CharSequence)("Copying: " + artifact.getId() + " to: " + pluginFile));
                FileUtils.copyFile((File)artifactFile, (File)pluginFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy Eclipse plugin: " + artifact.getId() + "\nfrom: " + artifact.getFile() + "\nto: " + pluginFile, (Exception)e);
            }
        }
        try {
            this.getLog().debug((CharSequence)("Expanding: " + artifact.getId() + " into: " + pluginDir));
            pluginDir.mkdirs();
            UnArchiver unarchiver = this.archiverManager.getUnArchiver(artifactFile);
            unarchiver.setSourceFile(artifactFile);
            unarchiver.setDestDirectory(pluginDir);
            unarchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Could not find unarchiver for: " + artifactFile, (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not extract: " + artifactFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not extract: " + artifactFile, (Exception)e);
        }
    }

    private String formatEclipsePluginName(Artifact artifact) {
        return this.maven2OsgiConverter.getBundleSymbolicName(artifact) + "_" + this.maven2OsgiConverter.getVersion(artifact.getVersion());
    }
}

