/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;

public class EclipseSettingsWriter
extends AbstractEclipseWriter {
    private static final String JDK_1_2_SOURCES = "1.2";
    private static final String FILE_ECLIPSE_JDT_CORE_PREFS = "org.eclipse.jdt.core.prefs";
    private static final String PROP_ECLIPSE_PREFERENCES_VERSION = "eclipse.preferences.version";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private static final String PROP_JDT_CORE_COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    private static final String PROP_JDT_CORE_COMPILER_SOURCE = "org.eclipse.jdt.core.compiler.source";
    private static final String PROP_JDT_CORE_COMPILER_ENCODING = "encoding/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write() throws MojoExecutionException {
        Properties coreSettings = new Properties();
        String source = IdeUtils.getCompilerSourceVersion(this.config.getProject());
        String encoding = IdeUtils.getCompilerSourceEncoding(this.config.getProject());
        String target = IdeUtils.getCompilerTargetVersion(this.config.getProject());
        if (source != null) {
            coreSettings.put(PROP_JDT_CORE_COMPILER_SOURCE, source);
            coreSettings.put(PROP_JDT_CORE_COMPILER_COMPLIANCE, source);
        }
        if (encoding != null) {
            List testResources;
            List resources;
            List testCompileSourceRoots;
            String basedir = this.config.getProject().getBasedir().getAbsolutePath();
            List compileSourceRoots = this.config.getProject().getCompileSourceRoots();
            if (compileSourceRoots != null) {
                Iterator it = compileSourceRoots.iterator();
                while (it.hasNext()) {
                    String sourcePath = (String)it.next();
                    String relativePath = sourcePath.substring(basedir.length()).replace('\\', '/');
                    coreSettings.put(PROP_JDT_CORE_COMPILER_ENCODING + relativePath, encoding);
                }
            }
            if ((testCompileSourceRoots = this.config.getProject().getTestCompileSourceRoots()) != null) {
                Iterator it = testCompileSourceRoots.iterator();
                while (it.hasNext()) {
                    String sourcePath = (String)it.next();
                    String relativePath = sourcePath.substring(basedir.length()).replace('\\', '/');
                    coreSettings.put(PROP_JDT_CORE_COMPILER_ENCODING + relativePath, encoding);
                }
            }
            if ((resources = this.config.getProject().getResources()) != null) {
                Iterator it = resources.iterator();
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    String relativePath = resource.getDirectory().substring(basedir.length()).replace('\\', '/');
                    coreSettings.put(PROP_JDT_CORE_COMPILER_ENCODING + relativePath, encoding);
                }
            }
            if ((testResources = this.config.getProject().getTestResources()) != null) {
                Iterator it = testResources.iterator();
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    String relativePath = resource.getDirectory().substring(basedir.length()).replace('\\', '/');
                    coreSettings.put(PROP_JDT_CORE_COMPILER_ENCODING + relativePath, encoding);
                }
            }
        }
        if (target != null && !JDK_1_2_SOURCES.equals(target)) {
            coreSettings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        }
        if (!coreSettings.isEmpty()) {
            File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_DOT_SETTINGS);
            settingsDir.mkdirs();
            coreSettings.put(PROP_ECLIPSE_PREFERENCES_VERSION, "1");
            try {
                File coreSettingsFile = new File(settingsDir, FILE_ECLIPSE_JDT_CORE_PREFS);
                if (coreSettingsFile.exists()) {
                    File oldCoreSettingsFile = coreSettingsFile;
                    Properties oldsettings = new Properties();
                    oldsettings.load(new FileInputStream(oldCoreSettingsFile));
                    Properties newsettings = (Properties)oldsettings.clone();
                    newsettings.putAll((Map<?, ?>)coreSettings);
                    if (oldsettings.equals(newsettings)) return;
                    newsettings.store(new FileOutputStream(coreSettingsFile), null);
                    return;
                }
                coreSettings.store(new FileOutputStream(coreSettingsFile), null);
                this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.wrotesettings", coreSettingsFile.getCanonicalPath()));
                return;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.cannotcreatesettings"), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.errorwritingsettings"), (Exception)e);
            }
        } else {
            this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.usingdefaults"));
        }
    }
}

