/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class PomUtils {
    PomUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model loadPom(File pomFile) throws MojoExecutionException {
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)reader, false);
            return model;
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Failed to parse POM: " + pomFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read POM: " + pomFile, (Exception)e);
        }
    }
}

