/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.report.ClassNameStackTraceFilter;
import org.apache.maven.surefire.report.StackTraceFilter;
import org.apache.maven.surefire.shared.utils.StringUtils;

public class SmartStackTraceParser {
    private final SafeThrowable throwable;
    private final StackTraceElement[] stackTrace;
    private final String testClassName;
    private final Class<?> testClass;
    private final String testMethodName;

    public SmartStackTraceParser(String testClassName, Throwable throwable, String testMethodName) {
        this.testMethodName = testMethodName;
        this.testClassName = testClassName;
        this.testClass = SmartStackTraceParser.toClass(testClassName);
        this.throwable = new SafeThrowable(throwable);
        this.stackTrace = throwable.getStackTrace();
    }

    private static Class<?> toClass(String name) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader == null ? null : classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String toSimpleClassName(String className) {
        int i = className.lastIndexOf(".");
        return className.substring(i + 1);
    }

    public String getString() {
        if (this.testClass == null) {
            return this.throwable.getLocalizedMessage();
        }
        StringBuilder result = new StringBuilder();
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusOnClass(this.stackTrace, this.testClass);
        Collections.reverse(stackTraceElements);
        String testClassSimpleName = SmartStackTraceParser.toSimpleClassName(this.testClassName);
        if (stackTraceElements.isEmpty()) {
            result.append(testClassSimpleName);
            if (StringUtils.isNotEmpty((String)this.testMethodName)) {
                result.append(".").append(this.testMethodName);
            }
        } else {
            int size = stackTraceElements.size();
            for (int i = 0; i < size; ++i) {
                StackTraceElement stackTraceElement = stackTraceElements.get(i);
                boolean isTestClassName = stackTraceElement.getClassName().equals(this.testClassName);
                if (i == 0) {
                    result.append(testClassSimpleName).append(isTestClassName ? (char)'.' : '>');
                }
                if (!isTestClassName) {
                    result.append(SmartStackTraceParser.toSimpleClassName(stackTraceElement.getClassName())).append('.');
                }
                result.append(stackTraceElement.getMethodName()).append(':').append(stackTraceElement.getLineNumber()).append("->");
            }
            if (result.length() >= 2) {
                result.setLength(result.length() - 2);
            }
        }
        Throwable target = this.throwable.getTarget();
        Class<?> excType = target.getClass();
        String excClassName = excType.getName();
        String msg = this.throwable.getMessage();
        if (!(target instanceof AssertionError || "junit.framework.AssertionFailedError".equals(excClassName) || "junit.framework.ComparisonFailure".equals(excClassName) || excClassName.startsWith("org.opentest4j."))) {
            result.append(this.rootIsInclass() ? " " : " \u00bb ").append(SmartStackTraceParser.toMinimalThrowableMiniMessage(excType));
        }
        if (StringUtils.isNotEmpty((String)msg)) {
            result.append(' ').append(msg);
        }
        return result.toString();
    }

    private static String toMinimalThrowableMiniMessage(Class<?> excType) {
        String name = excType.getSimpleName();
        if (name.endsWith("Exception")) {
            return StringUtils.chompLast((String)name, (String)"Exception");
        }
        if (name.endsWith("Error")) {
            return StringUtils.chompLast((String)name, (String)"Error");
        }
        return name;
    }

    private boolean rootIsInclass() {
        return this.stackTrace != null && this.stackTrace.length > 0 && this.stackTrace[0].getClassName().equals(this.testClassName);
    }

    private static List<StackTraceElement> focusOnClass(StackTraceElement[] stackTrace, Class<?> clazz) {
        if (stackTrace == null) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (element == null || !SmartStackTraceParser.isInSupers(clazz, element.getClassName())) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean isInSupers(Class<?> testClass, String lookFor) {
        if (lookFor.startsWith("junit.framework.")) {
            return false;
        }
        while (!testClass.getName().equals(lookFor) && testClass.getSuperclass() != null) {
            testClass = testClass.getSuperclass();
        }
        return testClass.getName().equals(lookFor);
    }

    static Throwable findTopmostWithClass(Throwable t, StackTraceFilter filter) {
        Throwable n = t;
        do {
            if (!SmartStackTraceParser.containsClassName(n.getStackTrace(), filter)) continue;
            return n;
        } while ((n = n.getCause()) != null);
        return t;
    }

    public static String stackTraceWithFocusOnClassAsString(Throwable t, String className) {
        ClassNameStackTraceFilter filter = new ClassNameStackTraceFilter(className);
        Throwable topmost = SmartStackTraceParser.findTopmostWithClass(t, filter);
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusInsideClass(topmost.getStackTrace(), filter);
        String s = SmartStackTraceParser.causeToString(topmost.getCause(), filter);
        return SmartStackTraceParser.toString(t, stackTraceElements, filter) + s;
    }

    static List<StackTraceElement> focusInsideClass(StackTraceElement[] stackTrace, StackTraceFilter filter) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (!filter.matches(element)) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean containsClassName(StackTraceElement[] stackTrace, StackTraceFilter filter) {
        for (StackTraceElement element : stackTrace) {
            if (!filter.matches(element)) continue;
            return true;
        }
        return false;
    }

    private static String causeToString(Throwable cause, StackTraceFilter filter) {
        StringBuilder resp = new StringBuilder();
        while (cause != null) {
            resp.append("Caused by: ");
            resp.append(SmartStackTraceParser.toString(cause, Arrays.asList(cause.getStackTrace()), filter));
            cause = cause.getCause();
        }
        return resp.toString();
    }

    private static String toString(Throwable t, Iterable<StackTraceElement> elements, StackTraceFilter filter) {
        StringBuilder result = new StringBuilder();
        if (t != null) {
            result.append(t.getClass().getName());
            String msg = t.getMessage();
            if (msg != null) {
                result.append(": ");
                if (SmartStackTraceParser.isMultiLine(msg)) {
                    result.append('\n');
                }
                result.append(msg);
            }
            result.append('\n');
        }
        for (StackTraceElement element : elements) {
            if (!filter.matches(element)) continue;
            result.append("\tat ").append(element).append('\n');
        }
        return result.toString();
    }

    private static boolean isMultiLine(String msg) {
        int countNewLines = 0;
        int length = msg.length();
        for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
        }
        return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
    }
}

