/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.Maven;
import org.apache.maven.SettingsConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.cli.BatchModeDownloadMonitor;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenCli {
    public static final String OS_NAME = Os.OS_NAME;
    public static final String OS_ARCH = Os.OS_ARCH;
    public static final String OS_VERSION = Os.OS_VERSION;
    private static Embedder embedder;

    public static void main(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        int result = MavenCli.main(args, classWorld);
        System.exit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(String[] args, ClassWorld classWorld) {
        Settings settings;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        if ("1.4".compareTo(System.getProperty("java.specification.version")) > 0) {
            System.err.println("Sorry, but JDK 1.4 or above is required to execute Maven. You appear to be using Java:");
            System.err.println("java version \"" + System.getProperty("java.version", "<unknown java version>") + "\"");
            System.err.println(System.getProperty("java.runtime.name", "<unknown runtime name>") + " (build " + System.getProperty("java.runtime.version", "<unknown runtime version>") + ")");
            System.err.println(System.getProperty("java.vm.name", "<unknown vm name>") + " (build " + System.getProperty("java.vm.version", "<unknown vm version>") + ", " + System.getProperty("java.vm.info", "<unknown vm info>") + ")");
            return 1;
        }
        boolean debug = commandLine.hasOption('X');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            MavenCli.showVersion();
            return 0;
        }
        if (debug) {
            MavenCli.showVersion();
        }
        DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher();
        embedder = new Embedder();
        try {
            embedder.start(classWorld);
        }
        catch (PlexusContainerException e) {
            MavenCli.showFatalError("Unable to start the embedded plexus container", (Exception)((Object)e), showErrors);
            return 1;
        }
        Properties executionProperties = new Properties();
        Properties userProperties = new Properties();
        MavenCli.populateProperties(commandLine, executionProperties, userProperties);
        try {
            settings = MavenCli.buildSettings(commandLine);
        }
        catch (SettingsConfigurationException e) {
            MavenCli.showError("Error reading settings.xml: " + e.getMessage(), e, showErrors);
            return 1;
        }
        catch (ComponentLookupException e) {
            MavenCli.showFatalError("Unable to read settings.xml", (Exception)((Object)e), showErrors);
            return 1;
        }
        Maven maven = null;
        MavenExecutionRequest request = null;
        LoggerManager loggerManager = null;
        try {
            String[] profileOptionValues;
            loggerManager = (LoggerManager)embedder.lookup(LoggerManager.ROLE);
            if (debug) {
                loggerManager.setThreshold(0);
            } else if (commandLine.hasOption('q')) {
                loggerManager.setThreshold(3);
            }
            DefaultProfileManager profileManager = new DefaultProfileManager(embedder.getContainer(), executionProperties);
            if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
                for (int i = 0; i < profileOptionValues.length; ++i) {
                    StringTokenizer profileTokens = new StringTokenizer(profileOptionValues[i], ",");
                    while (profileTokens.hasMoreTokens()) {
                        String profileAction = profileTokens.nextToken().trim();
                        if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                            profileManager.explicitlyDeactivate(profileAction.substring(1));
                            continue;
                        }
                        if (profileAction.startsWith("+")) {
                            profileManager.explicitlyActivate(profileAction.substring(1));
                            continue;
                        }
                        profileManager.explicitlyActivate(profileAction);
                    }
                }
            }
            request = MavenCli.createRequest(commandLine, settings, (EventDispatcher)eventDispatcher, loggerManager, (ProfileManager)profileManager, executionProperties, userProperties, showErrors);
            MavenCli.setProjectFileOptions(commandLine, request);
            maven = MavenCli.createMavenInstance(settings.isInteractiveMode());
        }
        catch (ComponentLookupException e) {
            MavenCli.showFatalError("Unable to configure the Maven application", (Exception)((Object)e), showErrors);
            int n = 1;
            return n;
        }
        finally {
            if (loggerManager != null) {
                try {
                    embedder.release((Object)loggerManager);
                }
                catch (ComponentLifecycleException e) {
                    MavenCli.showFatalError("Error releasing logging manager", (Exception)((Object)e), showErrors);
                }
            }
        }
        try {
            maven.execute(request);
        }
        catch (MavenExecutionException e) {
            return 1;
        }
        return 0;
    }

    private static Settings buildSettings(CommandLine commandLine) throws ComponentLookupException, SettingsConfigurationException {
        String userSettingsPath = null;
        if (commandLine.hasOption('s')) {
            userSettingsPath = commandLine.getOptionValue('s');
        }
        Settings settings = null;
        MavenSettingsBuilder settingsBuilder = (MavenSettingsBuilder)embedder.lookup(MavenSettingsBuilder.ROLE);
        try {
            if (userSettingsPath != null) {
                File userSettingsFile = new File(userSettingsPath);
                if (userSettingsFile.exists() && !userSettingsFile.isDirectory()) {
                    settings = settingsBuilder.buildSettings(userSettingsFile);
                } else {
                    System.out.println("WARNING: Alternate user settings file: " + userSettingsPath + " is invalid. Using default path.");
                }
            }
            if (settings == null) {
                settings = settingsBuilder.buildSettings();
            }
        }
        catch (IOException e) {
            throw new SettingsConfigurationException("Error reading settings file", e);
        }
        catch (XmlPullParserException e) {
            throw new SettingsConfigurationException(e.getMessage(), e.getDetail(), e.getLineNumber(), e.getColumnNumber());
        }
        if (commandLine.hasOption('B')) {
            settings.setInteractiveMode(false);
        }
        if (commandLine.hasOption("npr")) {
            settings.setUsePluginRegistry(false);
        }
        settings.setRuntimeInfo(MavenCli.createRuntimeInfo(commandLine, settings));
        return settings;
    }

    private static RuntimeInfo createRuntimeInfo(CommandLine commandLine, Settings settings) {
        RuntimeInfo runtimeInfo = new RuntimeInfo(settings);
        if (commandLine.hasOption("cpu") || commandLine.hasOption("up")) {
            runtimeInfo.setPluginUpdateOverride(Boolean.TRUE);
        } else if (commandLine.hasOption("npu")) {
            runtimeInfo.setPluginUpdateOverride(Boolean.FALSE);
        }
        return runtimeInfo;
    }

    private static void showFatalError(String message, Exception e, boolean show) {
        System.err.println("FATAL ERROR: " + message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        } else {
            System.err.println("For more information, run with the -e flag");
        }
    }

    private static void showError(String message, Exception e, boolean show) {
        System.err.println(message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        }
    }

    private static MavenExecutionRequest createRequest(CommandLine commandLine, Settings settings, EventDispatcher eventDispatcher, LoggerManager loggerManager, ProfileManager profileManager, Properties executionProperties, Properties userProperties, boolean showErrors) throws ComponentLookupException {
        ArtifactRepository localRepository = MavenCli.createLocalRepository(embedder, settings, commandLine);
        File userDir = new File(System.getProperty("user.dir"));
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(localRepository, settings, eventDispatcher, commandLine.getArgList(), userDir.getPath(), profileManager, executionProperties, userProperties, showErrors);
        Logger logger = loggerManager.getLoggerForComponent(Mojo.ROLE);
        if (logger != null) {
            request.addEventMonitor((EventMonitor)new DefaultEventMonitor(logger));
        }
        if (commandLine.hasOption('N')) {
            request.setRecursive(false);
        }
        if (commandLine.hasOption("ff")) {
            request.setFailureBehavior("fail-fast");
        } else if (commandLine.hasOption("fae")) {
            request.setFailureBehavior("fail-at-end");
        } else if (commandLine.hasOption("fn")) {
            request.setFailureBehavior("fail-never");
        }
        return request;
    }

    private static void setProjectFileOptions(CommandLine commandLine, MavenExecutionRequest request) {
        if (commandLine.hasOption('r')) {
            request.setReactorActive(true);
        } else if (commandLine.hasOption('f')) {
            request.setPomFile(commandLine.getOptionValue('f'));
        }
    }

    private static Maven createMavenInstance(boolean interactive) throws ComponentLookupException {
        WagonManager wagonManager = (WagonManager)embedder.lookup(WagonManager.ROLE);
        if (interactive) {
            wagonManager.setDownloadMonitor((TransferListener)new ConsoleDownloadMonitor());
        } else {
            wagonManager.setDownloadMonitor((TransferListener)new BatchModeDownloadMonitor());
        }
        wagonManager.setInteractive(interactive);
        return (Maven)embedder.lookup(Maven.ROLE);
    }

    private static ArtifactRepository createLocalRepository(Embedder embedder, Settings settings, CommandLine commandLine) throws ComponentLookupException {
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.ROLE, "default");
        ArtifactRepositoryFactory artifactRepositoryFactory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
        String url = settings.getLocalRepository();
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository("local", url, repositoryLayout);
        boolean snapshotPolicySet = false;
        if (commandLine.hasOption('o')) {
            settings.setOffline(true);
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && commandLine.hasOption('U')) {
            artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        if (commandLine.hasOption('C')) {
            System.out.println("+ Enabling strict checksum verification on all artifact downloads.");
            artifactRepositoryFactory.setGlobalChecksumPolicy("fail");
        } else if (commandLine.hasOption('c')) {
            System.out.println("+ Disabling strict checksum verification on all artifact downloads.");
            artifactRepositoryFactory.setGlobalChecksumPolicy("warn");
        }
        return localRepository;
    }

    private static void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = MavenCli.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
                if (properties.getProperty("builtOn") != null) {
                    System.out.println("Maven version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"));
                } else {
                    System.out.println("Maven version: " + properties.getProperty("version", "unknown"));
                }
            } else {
                System.out.println("Maven version: unknown");
            }
            System.out.println("Java version: " + System.getProperty("java.version", "<unknown java version>"));
            System.out.println("OS name: \"" + Os.OS_NAME + "\" version: \"" + Os.OS_VERSION + "\" arch: \"" + Os.OS_ARCH + "\" Family: \"" + Os.OS_FAMILY + "\"");
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
    }

    static void populateProperties(CommandLine commandLine, Properties executionProperties, Properties userProperties) {
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            Iterator<Map.Entry<Object, Object>> i = envVars.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e = i.next();
                executionProperties.setProperty("env." + e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error getting environment vars for profile activation: " + e);
        }
        if (commandLine.hasOption('D')) {
            String[] defStrs = commandLine.getOptionValues('D');
            if (defStrs != null) {
                for (int i = 0; i < defStrs.length; ++i) {
                    MavenCli.setCliProperty(defStrs[i], userProperties);
                }
            }
            executionProperties.putAll((Map<?, ?>)userProperties);
        }
        executionProperties.putAll((Map<?, ?>)System.getProperties());
    }

    private static void setCliProperty(String property, Properties requestProperties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        requestProperties.setProperty(name, value);
        System.setProperty(name, value);
    }

    static class CLIManager {
        public static final char ALTERNATE_POM_FILE = 'f';
        public static final char BATCH_MODE = 'B';
        public static final char SET_SYSTEM_PROPERTY = 'D';
        public static final char OFFLINE = 'o';
        public static final char REACTOR = 'r';
        public static final char QUIET = 'q';
        public static final char DEBUG = 'X';
        public static final char ERRORS = 'e';
        public static final char HELP = 'h';
        public static final char VERSION = 'v';
        private Options options = new Options();
        public static final char NON_RECURSIVE = 'N';
        public static final char UPDATE_SNAPSHOTS = 'U';
        public static final char ACTIVATE_PROFILES = 'P';
        public static final String FORCE_PLUGIN_UPDATES = "cpu";
        public static final String FORCE_PLUGIN_UPDATES2 = "up";
        public static final String SUPPRESS_PLUGIN_UPDATES = "npu";
        public static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
        public static final char CHECKSUM_FAILURE_POLICY = 'C';
        public static final char CHECKSUM_WARNING_POLICY = 'c';
        private static final char ALTERNATE_USER_SETTINGS = 's';
        private static final String FAIL_FAST = "ff";
        private static final String FAIL_AT_END = "fae";
        private static final String FAIL_NEVER = "fn";

        public CLIManager() {
            OptionBuilder.withLongOpt((String)"file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Force the use of an alternate POM file.");
            this.options.addOption(OptionBuilder.create((char)'f'));
            OptionBuilder.withLongOpt((String)"define");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Define a system property");
            this.options.addOption(OptionBuilder.create((char)'D'));
            OptionBuilder.withLongOpt((String)"offline");
            OptionBuilder.withDescription((String)"Work offline");
            this.options.addOption(OptionBuilder.create((char)'o'));
            OptionBuilder.withLongOpt((String)"help");
            OptionBuilder.withDescription((String)"Display help information");
            this.options.addOption(OptionBuilder.create((char)'h'));
            OptionBuilder.withLongOpt((String)"version");
            OptionBuilder.withDescription((String)"Display version information");
            this.options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"quiet");
            OptionBuilder.withDescription((String)"Quiet output - only show errors");
            this.options.addOption(OptionBuilder.create((char)'q'));
            OptionBuilder.withLongOpt((String)"debug");
            OptionBuilder.withDescription((String)"Produce execution debug output");
            this.options.addOption(OptionBuilder.create((char)'X'));
            OptionBuilder.withLongOpt((String)"errors");
            OptionBuilder.withDescription((String)"Produce execution error messages");
            this.options.addOption(OptionBuilder.create((char)'e'));
            OptionBuilder.withLongOpt((String)"reactor");
            OptionBuilder.withDescription((String)"Execute goals for project found in the reactor");
            this.options.addOption(OptionBuilder.create((char)'r'));
            OptionBuilder.withLongOpt((String)"non-recursive");
            OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
            this.options.addOption(OptionBuilder.create((char)'N'));
            OptionBuilder.withLongOpt((String)"update-snapshots");
            OptionBuilder.withDescription((String)"Forces a check for updated releases and snapshots on remote repositories");
            this.options.addOption(OptionBuilder.create((char)'U'));
            OptionBuilder.withLongOpt((String)"activate-profiles");
            OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
            OptionBuilder.hasArg();
            this.options.addOption(OptionBuilder.create((char)'P'));
            OptionBuilder.withLongOpt((String)"batch-mode");
            OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
            this.options.addOption(OptionBuilder.create((char)'B'));
            OptionBuilder.withLongOpt((String)"check-plugin-updates");
            OptionBuilder.withDescription((String)"Force upToDate check for any relevant registered plugins");
            this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES));
            OptionBuilder.withLongOpt((String)"update-plugins");
            OptionBuilder.withDescription((String)"Synonym for cpu");
            this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES2));
            OptionBuilder.withLongOpt((String)"no-plugin-updates");
            OptionBuilder.withDescription((String)"Suppress upToDate check for any relevant registered plugins");
            this.options.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_UPDATES));
            OptionBuilder.withLongOpt((String)"no-plugin-registry");
            OptionBuilder.withDescription((String)"Don't use ~/.m2/plugin-registry.xml for plugin versions");
            this.options.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_REGISTRY));
            OptionBuilder.withLongOpt((String)"strict-checksums");
            OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
            this.options.addOption(OptionBuilder.create((char)'C'));
            OptionBuilder.withLongOpt((String)"lax-checksums");
            OptionBuilder.withDescription((String)"Warn if checksums don't match");
            this.options.addOption(OptionBuilder.create((char)'c'));
            OptionBuilder.withLongOpt((String)"settings");
            OptionBuilder.withDescription((String)"Alternate path for the user settings file");
            OptionBuilder.hasArg();
            this.options.addOption(OptionBuilder.create((char)'s'));
            OptionBuilder.withLongOpt((String)"fail-fast");
            OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
            this.options.addOption(OptionBuilder.create((String)FAIL_FAST));
            OptionBuilder.withLongOpt((String)"fail-at-end");
            OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
            this.options.addOption(OptionBuilder.create((String)FAIL_AT_END));
            OptionBuilder.withLongOpt((String)"fail-never");
            OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
            this.options.addOption(OptionBuilder.create((String)FAIL_NEVER));
        }

        public CommandLine parse(String[] args) throws ParseException {
            String[] cleanArgs = this.cleanArgs(args);
            GnuParser parser = new GnuParser();
            return parser.parse(this.options, cleanArgs);
        }

        private String[] cleanArgs(String[] args) {
            ArrayList<String> cleaned = new ArrayList<String>();
            StringBuffer currentArg = null;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                boolean addedToBuffer = false;
                if (arg.startsWith("\"")) {
                    if (currentArg != null) {
                        cleaned.add(currentArg.toString());
                    }
                    currentArg = new StringBuffer(arg.substring(1));
                    addedToBuffer = true;
                }
                if (arg.endsWith("\"")) {
                    String cleanArgPart = arg.substring(0, arg.length() - 1);
                    if (currentArg != null) {
                        if (addedToBuffer) {
                            currentArg.setLength(currentArg.length() - 1);
                        } else {
                            currentArg.append(' ').append(cleanArgPart);
                        }
                        cleaned.add(currentArg.toString());
                    } else {
                        cleaned.add(cleanArgPart);
                    }
                    currentArg = null;
                    continue;
                }
                if (addedToBuffer) continue;
                if (currentArg != null) {
                    currentArg.append(' ').append(arg);
                    continue;
                }
                cleaned.add(arg);
            }
            if (currentArg != null) {
                cleaned.add(currentArg.toString());
            }
            int cleanedSz = cleaned.size();
            String[] cleanArgs = null;
            cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
            return cleanArgs;
        }

        public void displayHelp() {
            System.out.println();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, "\n");
        }
    }
}

