/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.project.builder.AlwaysJoinModelContainerFactory;
import org.apache.maven.project.builder.ArtifactModelContainerFactory;
import org.apache.maven.project.builder.IdModelContainerFactory;
import org.apache.maven.project.builder.PluginExecutionIdModelContainerFactory;
import org.apache.maven.project.builder.PomInterpolatorTag;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.project.builder.rules.DependencyRule;
import org.apache.maven.project.builder.rules.ExecutionRule;
import org.apache.maven.shared.model.DomainModel;
import org.apache.maven.shared.model.DomainModelFactory;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerAction;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelContainerInfo;
import org.apache.maven.shared.model.ModelContainerRule;
import org.apache.maven.shared.model.ModelEventListener;
import org.apache.maven.shared.model.ModelProperty;
import org.apache.maven.shared.model.ModelTransformer;
import org.apache.maven.shared.model.ModelTransformerContext;
import org.apache.maven.shared.model.impl.DefaultModelDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomTransformer
implements ModelTransformer {
    private final DomainModelFactory factory;
    public static final List<ModelContainerFactory> MODEL_CONTAINER_FACTORIES = Collections.unmodifiableList(Arrays.asList(new ArtifactModelContainerFactory(), new IdModelContainerFactory(ProjectUri.PluginRepositories.PluginRepository.xUri), new IdModelContainerFactory(ProjectUri.Repositories.Repository.xUri), new IdModelContainerFactory(ProjectUri.Reporting.Plugins.Plugin.ReportSets.ReportSet.xUri), new IdModelContainerFactory(ProjectUri.Profiles.Profile.xUri), new IdModelContainerFactory(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri)));
    private static Collection<ModelContainerInfo> goals_infos = Arrays.asList(ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new AlwaysJoinModelContainerFactory(), (ModelContainerRule)new ExecutionRule(), null));
    private static Collection<ModelContainerInfo> plugin_executions = Arrays.asList(ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new IdModelContainerFactory(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri), null, goals_infos));
    private static Collection<ModelContainerInfo> dependency_exclusions = Arrays.asList(ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new IdModelContainerFactory(ProjectUri.DependencyManagement.Dependencies.Dependency.Exclusions.Exclusion.xUri), (ModelContainerRule)new DependencyRule(), null));
    public static final Collection<ModelContainerInfo> MODEL_CONTAINER_INFOS = Arrays.asList(ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new ArtifactModelContainerFactory(), null, plugin_executions), ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new IdModelContainerFactory(ProjectUri.PluginRepositories.PluginRepository.xUri), null, null), ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new IdModelContainerFactory(ProjectUri.Repositories.Repository.xUri), null, null), ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new ArtifactModelContainerFactory(), null, dependency_exclusions), ModelContainerInfo.Factory.createModelContainerInfo((ModelContainerFactory)new IdModelContainerFactory(ProjectUri.Profiles.Profile.xUri), null, null));
    public static final Set<String> URIS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ProjectUri.Build.Extensions.xUri, ProjectUri.Build.PluginManagement.Plugins.xUri, ProjectUri.Build.PluginManagement.Plugins.Plugin.configuration, ProjectUri.Build.PluginManagement.Plugins.Plugin.Executions.xUri, ProjectUri.Build.PluginManagement.Plugins.Plugin.Executions.Execution.Goals.xURI, ProjectUri.Build.PluginManagement.Plugins.Plugin.Dependencies.xUri, ProjectUri.Build.PluginManagement.Plugins.Plugin.Dependencies.Dependency.Exclusions.xUri, ProjectUri.Build.Plugins.xUri, ProjectUri.Build.Plugins.Plugin.configuration, ProjectUri.Reporting.Plugins.xUri, ProjectUri.Reporting.Plugins.Plugin.configuration, ProjectUri.Build.Plugins.Plugin.Dependencies.xUri, ProjectUri.Build.Resources.xUri, ProjectUri.Build.Resources.Resource.includes, ProjectUri.Build.Resources.Resource.excludes, ProjectUri.Build.TestResources.xUri, ProjectUri.Build.Filters.xUri, ProjectUri.CiManagement.Notifiers.xUri, ProjectUri.Contributors.xUri, ProjectUri.Dependencies.xUri, ProjectUri.DependencyManagement.Dependencies.xUri, ProjectUri.Developers.xUri, ProjectUri.Developers.Developer.roles, ProjectUri.Licenses.xUri, ProjectUri.MailingLists.xUri, ProjectUri.Modules.xUri, ProjectUri.PluginRepositories.xUri, ProjectUri.Profiles.xUri, ProjectUri.Profiles.Profile.Build.Plugins.xUri, ProjectUri.Profiles.Profile.Build.Plugins.Plugin.Dependencies.xUri, ProjectUri.Profiles.Profile.Build.Plugins.Plugin.Executions.xUri, ProjectUri.Profiles.Profile.Build.Resources.xUri, ProjectUri.Profiles.Profile.Build.TestResources.xUri, ProjectUri.Profiles.Profile.Dependencies.xUri, ProjectUri.Profiles.Profile.DependencyManagement.Dependencies.xUri, ProjectUri.Profiles.Profile.PluginRepositories.xUri, ProjectUri.Profiles.Profile.Reporting.Plugins.xUri, ProjectUri.Profiles.Profile.Repositories.xUri, ProjectUri.Profiles.Profile.Build.PluginManagement.Plugins.xUri, ProjectUri.Profiles.Profile.Build.PluginManagement.Plugins.Plugin.Dependencies.xUri, ProjectUri.Reporting.Plugins.xUri, ProjectUri.Repositories.xUri)));
    private static final Set<String> PATH_URIS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ProjectUri.Build.directory, ProjectUri.Build.outputDirectory, ProjectUri.Build.testOutputDirectory, ProjectUri.Build.sourceDirectory, ProjectUri.Build.testSourceDirectory, ProjectUri.Build.scriptSourceDirectory, ProjectUri.Build.Resources.Resource.directory, ProjectUri.Build.TestResources.TestResource.directory, ProjectUri.Build.Filters.filter, ProjectUri.Reporting.outputDirectory)));

    public PomTransformer(DomainModelFactory factory) {
        this.factory = factory;
    }

    public final DomainModel transformToDomainModel(List<ModelProperty> properties, List<? extends ModelEventListener> eventListeners) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties: null");
        }
        eventListeners = eventListeners == null ? new ArrayList<ModelEventListener>() : new ArrayList<ModelEventListener>(eventListeners);
        List<Object> props = new ArrayList<ModelProperty>(properties);
        DefaultModelDataSource source = new DefaultModelDataSource(props, MODEL_CONTAINER_FACTORIES);
        for (ModelContainer dependencyContainer : source.queryFor(ProjectUri.Dependencies.Dependency.xUri)) {
            for (ModelContainer managementContainer : source.queryFor(ProjectUri.DependencyManagement.Dependencies.Dependency.xUri)) {
                DefaultModelDataSource exclusionSource = new DefaultModelDataSource(managementContainer.getProperties(), Collections.unmodifiableList(Arrays.asList(new ArtifactModelContainerFactory(ProjectUri.DependencyManagement.Dependencies.Dependency.Exclusions.Exclusion.xUri))));
                List list = exclusionSource.queryFor(ProjectUri.DependencyManagement.Dependencies.Dependency.Exclusions.Exclusion.xUri);
                for (ModelContainer mc : list) {
                    for (ModelContainer mc1 : list) {
                        if (mc.equals(mc1) || !mc.containerAction(mc1).equals((Object)ModelContainerAction.JOIN)) continue;
                        exclusionSource.joinWithOriginalOrder(mc1, mc);
                    }
                }
                managementContainer = new ArtifactModelContainerFactory().create(PomTransformer.transformDependencyManagement(exclusionSource.getModelProperties()));
                ModelContainerAction modelContainerAction = dependencyContainer.containerAction(managementContainer);
                if (!modelContainerAction.equals((Object)ModelContainerAction.JOIN) && !modelContainerAction.equals((Object)ModelContainerAction.DELETE)) continue;
                source.join(dependencyContainer, managementContainer);
            }
        }
        ArrayList<ModelProperty> joinedContainers = new ArrayList<ModelProperty>();
        for (ModelContainer pluginContainer : source.queryFor(ProjectUri.Build.Plugins.Plugin.xUri)) {
            for (ModelContainer managementContainer : source.queryFor(ProjectUri.Build.PluginManagement.Plugins.Plugin.xUri)) {
                ModelContainerAction action;
                ArrayList<ModelProperty> pList;
                boolean bl;
                ArrayList<ModelProperty> arrayList = new ArrayList<ModelProperty>();
                for (ModelProperty mp : managementContainer.getProperties()) {
                    if (!mp.getUri().startsWith(ProjectUri.Build.PluginManagement.xUri)) continue;
                    arrayList.add(new ModelProperty(mp.getUri().replace(ProjectUri.Build.PluginManagement.xUri, ProjectUri.Build.xUri), mp.getResolvedValue()));
                }
                managementContainer = new ArtifactModelContainerFactory().create(arrayList);
                boolean bl2 = false;
                for (ModelProperty mp : pluginContainer.getProperties()) {
                    if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.xUri)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    pList = managementContainer.getProperties();
                } else {
                    pList = new ArrayList<ModelProperty>();
                    for (ModelProperty mp : managementContainer.getProperties()) {
                        if (mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.xUri)) continue;
                        pList.add(mp);
                    }
                }
                if (!(action = pluginContainer.containerAction(managementContainer = new ArtifactModelContainerFactory().create(pList))).equals((Object)ModelContainerAction.JOIN) && !action.equals((Object)ModelContainerAction.DELETE)) continue;
                DefaultModelDataSource pluginDatasource = new DefaultModelDataSource(pluginContainer.getProperties(), MODEL_CONTAINER_FACTORIES);
                DefaultModelDataSource managementDatasource = new DefaultModelDataSource(managementContainer.getProperties(), MODEL_CONTAINER_FACTORIES);
                List managementExecutionContainers = managementDatasource.queryFor(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri);
                ArrayList<ModelProperty> managementPropertiesWithoutExecutions = new ArrayList<ModelProperty>(managementContainer.getProperties());
                for (ModelContainer a : managementExecutionContainers) {
                    managementPropertiesWithoutExecutions.removeAll(a.getProperties());
                }
                source.joinWithOriginalOrder(pluginContainer, new ArtifactModelContainerFactory().create(managementPropertiesWithoutExecutions));
                List pluginExecutionContainers = pluginDatasource.queryFor(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri);
                ArrayList<ModelContainer> joinedExecutionContainers = new ArrayList<ModelContainer>();
                for (ModelContainer a : managementExecutionContainers) {
                    boolean hasId = false;
                    for (ModelProperty mp : a.getProperties()) {
                        if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.id)) continue;
                        hasId = true;
                        break;
                    }
                    ModelContainer c = a;
                    if (!hasId) {
                        ArrayList<ModelProperty> listWithId = new ArrayList<ModelProperty>(a.getProperties());
                        listWithId.add(1, new ModelProperty(ProjectUri.Build.Plugins.Plugin.Executions.Execution.id, "default"));
                        c = new IdModelContainerFactory(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri).create(listWithId);
                    }
                    for (ModelContainer b : pluginExecutionContainers) {
                        if (!b.containerAction(c).equals((Object)ModelContainerAction.JOIN)) continue;
                        joinedContainers.addAll(source.join(b, c).getProperties());
                        joinedExecutionContainers.add(a);
                    }
                }
                ModelProperty executionsProperty = null;
                for (ModelProperty a : pluginContainer.getProperties()) {
                    if (!a.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.xUri)) continue;
                    executionsProperty = a;
                    break;
                }
                if (executionsProperty == null) {
                    for (ModelProperty a : managementPropertiesWithoutExecutions) {
                        if (!a.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.xUri)) continue;
                        executionsProperty = a;
                        break;
                    }
                }
                if (executionsProperty == null) continue;
                managementExecutionContainers.removeAll(joinedExecutionContainers);
                Collections.reverse(managementExecutionContainers);
                for (ModelContainer a : managementExecutionContainers) {
                    source.insertModelPropertiesAfter(executionsProperty, ModelTransformerContext.sort((List)a.getProperties(), (String)ProjectUri.Build.Plugins.Plugin.Executions.xUri));
                }
            }
        }
        props = source.getModelProperties();
        HashSet removeProperties = new HashSet();
        DefaultModelDataSource dataSource = new DefaultModelDataSource(props, MODEL_CONTAINER_FACTORIES);
        List containers = dataSource.queryFor(ProjectUri.Build.Plugins.Plugin.xUri);
        for (ModelContainer modelContainer : containers) {
            DefaultModelDataSource defaultModelDataSource = new DefaultModelDataSource(modelContainer.getProperties(), Arrays.asList(new ArtifactModelContainerFactory(), new PluginExecutionIdModelContainerFactory()));
            List executionContainers = defaultModelDataSource.queryFor(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri);
            if (executionContainers.size() < 2) continue;
            boolean hasAtLeastOneWithoutId = false;
            for (ModelContainer executionContainer : executionContainers) {
                if (hasAtLeastOneWithoutId && !PomTransformer.hasExecutionId(executionContainer) && executionContainers.indexOf(executionContainer) > 0) {
                    removeProperties.addAll(executionContainer.getProperties());
                }
                if (hasAtLeastOneWithoutId) continue;
                hasAtLeastOneWithoutId = !PomTransformer.hasExecutionId(executionContainer);
            }
        }
        props.removeAll(removeProperties);
        dataSource = new DefaultModelDataSource(props, MODEL_CONTAINER_FACTORIES);
        for (ModelContainer modelContainer : dataSource.queryFor(ProjectUri.Build.Plugins.Plugin.xUri)) {
            DefaultModelDataSource defaultModelDataSource = new DefaultModelDataSource(modelContainer.getProperties(), Arrays.asList(new IdModelContainerFactory(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri), new AlwaysJoinModelContainerFactory()));
            for (ModelContainer es : defaultModelDataSource.queryFor(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri)) {
                ExecutionRule rule = new ExecutionRule();
                List x = !PomTransformer.aContainsAnyOfB(es.getProperties(), joinedContainers) ? rule.execute(es.getProperties()) : ModelTransformerContext.sort(rule.execute(es.getProperties()), (String)ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri);
                dataSource.replace(es, es.createNewInstance(x));
            }
        }
        props = dataSource.getModelProperties();
        for (ModelEventListener modelEventListener : eventListeners) {
            DefaultModelDataSource defaultModelDataSource = new DefaultModelDataSource(props, modelEventListener.getModelContainerFactories());
            for (String uri : modelEventListener.getUris()) {
                modelEventListener.fire(defaultModelDataSource.queryFor(uri));
            }
        }
        ArrayList<ModelProperty> p = new ArrayList<ModelProperty>();
        for (ModelProperty modelProperty : props) {
            if (modelProperty.getResolvedValue() != null && modelProperty.getResolvedValue().trim().equals("")) {
                int index = props.indexOf(modelProperty) + 1;
                if (index <= props.size() && modelProperty.isParentOf((ModelProperty)props.get(index)) && modelProperty.getDepth() != ((ModelProperty)props.get(index)).getDepth() && !((ModelProperty)props.get(index)).getUri().contains("#property")) {
                    p.add(new ModelProperty(modelProperty.getUri(), null));
                    continue;
                }
                p.add(modelProperty);
                continue;
            }
            if (modelProperty.getResolvedValue() != null && PATH_URIS.contains(modelProperty.getUri())) {
                p.add(new ModelProperty(modelProperty.getUri(), new File(modelProperty.getResolvedValue()).getPath()));
                continue;
            }
            p.add(modelProperty);
        }
        return this.factory.createDomainModel(p);
    }

    private static boolean aContainsAnyOfB(List<ModelProperty> a, List<ModelProperty> b) {
        for (ModelProperty mpA : a) {
            for (ModelProperty mpB : b) {
                if (!mpA.equals(mpB)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<ModelProperty> transformDependencyManagement(List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> transformedProperties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.DependencyManagement.xUri)) continue;
            transformedProperties.add(new ModelProperty(mp.getUri().replace(ProjectUri.DependencyManagement.xUri, ProjectUri.xUri), mp.getResolvedValue()));
        }
        return transformedProperties;
    }

    public final List<ModelProperty> transformToModelProperties(List<? extends DomainModel> domainModels) throws IOException {
        if (domainModels == null || domainModels.isEmpty()) {
            throw new IllegalArgumentException("domainModels: null or empty");
        }
        ArrayList<ModelProperty> modelProperties = new ArrayList();
        ArrayList<String> projectNames = new ArrayList<String>();
        StringBuilder projectUrl = new StringBuilder(128);
        StringBuilder siteUrl = new StringBuilder(128);
        StringBuilder scmUrl = new StringBuilder(128);
        StringBuilder scmConnectionUrl = new StringBuilder(128);
        StringBuilder scmDeveloperUrl = new StringBuilder(128);
        boolean containsBuildResources = false;
        boolean containsTestResources = false;
        boolean containsPluginRepositories = false;
        boolean containsLicenses = false;
        boolean containsDevelopers = false;
        boolean containsContributors = false;
        boolean containsMailingLists = false;
        boolean containsOrganization = false;
        boolean containsIssueManagement = false;
        boolean containsCiManagement = false;
        boolean containsDistRepo = false;
        boolean containsDistSnapRepo = false;
        boolean containsDistSite = false;
        int domainModelIndex = -1;
        for (DomainModel domainModel : domainModels) {
            String uri;
            int j;
            List containers;
            ArrayList removeProperties;
            ModelProperty parentGroupId;
            ModelProperty modulesProperty;
            ModelProperty parentVersion;
            ++domainModelIndex;
            List tmp = domainModel.getModelProperties();
            ArrayList<ModelProperty> clearedProperties = new ArrayList<ModelProperty>();
            DefaultModelDataSource s = new DefaultModelDataSource(tmp, Arrays.asList(new ArtifactModelContainerFactory()));
            for (ModelContainer mc : s.queryFor(ProjectUri.Dependencies.Dependency.xUri)) {
                boolean containsScope = false;
                for (ModelProperty mp : mc.getProperties()) {
                    if (!mp.getUri().equals(ProjectUri.Dependencies.Dependency.scope)) continue;
                    containsScope = true;
                    break;
                }
                if (containsScope) continue;
                tmp.add(tmp.indexOf(mc.getProperties().get(0)) + 1, new ModelProperty(ProjectUri.Dependencies.Dependency.scope, "compile"));
            }
            ArrayList<ModelProperty> replace = new ArrayList<ModelProperty>();
            for (ModelProperty mp : tmp) {
                if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.id) || mp.getResolvedValue() == null || !mp.getResolvedValue().equals("default-execution-id")) continue;
                replace.add(mp);
            }
            tmp.removeAll(replace);
            if (PomTransformer.getPropertyFor(ProjectUri.version, tmp) == null && (parentVersion = PomTransformer.getPropertyFor(ProjectUri.Parent.version, tmp)) != null) {
                tmp.add(new ModelProperty(ProjectUri.version, parentVersion.getResolvedValue()));
            }
            if (domainModelIndex > 0 && (modulesProperty = PomTransformer.getPropertyFor(ProjectUri.Modules.xUri, tmp)) != null) {
                tmp.remove(modulesProperty);
                tmp.removeAll(PomTransformer.getPropertiesFor(ProjectUri.Modules.module, tmp));
            }
            if (PomTransformer.getPropertyFor(ProjectUri.groupId, tmp) == null && (parentGroupId = PomTransformer.getPropertyFor(ProjectUri.Parent.groupId, tmp)) != null) {
                tmp.add(new ModelProperty(ProjectUri.groupId, parentGroupId.getResolvedValue()));
            }
            if (domainModelIndex > 0) {
                removeProperties = new ArrayList();
                DefaultModelDataSource source = new DefaultModelDataSource(tmp, Arrays.asList(new ArtifactModelContainerFactory(), new PluginExecutionIdModelContainerFactory()));
                containers = source.queryFor(ProjectUri.Build.Plugins.Plugin.Executions.Execution.xUri);
                block4: for (ModelContainer container : containers) {
                    for (ModelProperty mp : container.getProperties()) {
                        if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.inherited) || mp.getResolvedValue() == null || !mp.getResolvedValue().equals("false")) continue;
                        removeProperties.addAll(container.getProperties());
                        for (j = tmp.indexOf(mp); j >= 0; --j) {
                            if (!((ModelProperty)tmp.get(j)).getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.xUri)) continue;
                            removeProperties.add(tmp.get(j));
                            continue block4;
                        }
                        continue block4;
                    }
                }
                tmp.removeAll(removeProperties);
            }
            if (domainModelIndex > 0) {
                removeProperties = new ArrayList();
                DefaultModelDataSource source = new DefaultModelDataSource(tmp, MODEL_CONTAINER_FACTORIES);
                containers = source.queryFor(ProjectUri.Build.Plugins.Plugin.xUri);
                block7: for (ModelContainer container : containers) {
                    for (ModelProperty mp : container.getProperties()) {
                        if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.inherited) || mp.getResolvedValue() == null || !mp.getResolvedValue().equals("false")) continue;
                        removeProperties.addAll(container.getProperties());
                        for (j = tmp.indexOf(mp); j >= 0; --j) {
                            if (!((ModelProperty)tmp.get(j)).getUri().equals(ProjectUri.Build.Plugins.Plugin.xUri)) continue;
                            removeProperties.add(tmp.get(j));
                            continue block7;
                        }
                        continue block7;
                    }
                }
                tmp.removeAll(removeProperties);
            }
            this.adjustUrl(projectUrl, tmp, ProjectUri.url, projectNames);
            this.adjustUrl(siteUrl, tmp, ProjectUri.DistributionManagement.Site.url, projectNames);
            this.adjustUrl(scmUrl, tmp, ProjectUri.Scm.url, projectNames);
            this.adjustUrl(scmConnectionUrl, tmp, ProjectUri.Scm.connection, projectNames);
            this.adjustUrl(scmDeveloperUrl, tmp, ProjectUri.Scm.developerConnection, projectNames);
            if (domainModelIndex > 0) {
                for (ModelProperty mp : tmp) {
                    uri = mp.getUri();
                    if (!uri.equals(ProjectUri.name) && !uri.equals(ProjectUri.packaging) && !uri.startsWith(ProjectUri.Profiles.xUri) && !uri.startsWith(ProjectUri.Parent.relativePath) && !uri.startsWith(ProjectUri.Prerequisites.xUri) && !uri.startsWith(ProjectUri.DistributionManagement.Relocation.xUri)) continue;
                    clearedProperties.add(mp);
                }
            }
            for (ModelProperty mp : tmp) {
                uri = mp.getUri();
                if (!(containsBuildResources && uri.startsWith(ProjectUri.Build.Resources.xUri) || containsTestResources && uri.startsWith(ProjectUri.Build.TestResources.xUri) || containsPluginRepositories && uri.startsWith(ProjectUri.PluginRepositories.xUri) || containsOrganization && uri.startsWith(ProjectUri.Organization.xUri) || containsLicenses && uri.startsWith(ProjectUri.Licenses.xUri) || containsDevelopers && uri.startsWith(ProjectUri.Developers.xUri) || containsContributors && uri.startsWith(ProjectUri.Contributors.xUri) || containsMailingLists && uri.startsWith(ProjectUri.MailingLists.xUri) || containsCiManagement && uri.startsWith(ProjectUri.CiManagement.xUri) || containsIssueManagement && uri.startsWith(ProjectUri.IssueManagement.xUri) || containsDistRepo && uri.startsWith(ProjectUri.DistributionManagement.Repository.xUri) || containsDistSnapRepo && uri.startsWith(ProjectUri.DistributionManagement.SnapshotRepository.xUri)) && (!containsDistSite || !uri.startsWith(ProjectUri.DistributionManagement.Site.xUri))) continue;
                clearedProperties.add(mp);
            }
            containsBuildResources |= PomTransformer.hasProjectUri(ProjectUri.Build.Resources.xUri, tmp);
            containsTestResources |= PomTransformer.hasProjectUri(ProjectUri.Build.TestResources.xUri, tmp);
            containsPluginRepositories |= PomTransformer.hasProjectUri(ProjectUri.PluginRepositories.xUri, tmp);
            containsOrganization |= PomTransformer.hasProjectUri(ProjectUri.Organization.xUri, tmp);
            containsLicenses |= PomTransformer.hasProjectUri(ProjectUri.Licenses.xUri, tmp);
            containsDevelopers |= PomTransformer.hasProjectUri(ProjectUri.Developers.xUri, tmp);
            containsContributors |= PomTransformer.hasProjectUri(ProjectUri.Contributors.xUri, tmp);
            containsMailingLists |= PomTransformer.hasProjectUri(ProjectUri.MailingLists.xUri, tmp);
            containsCiManagement |= PomTransformer.hasProjectUri(ProjectUri.CiManagement.xUri, tmp);
            containsIssueManagement |= PomTransformer.hasProjectUri(ProjectUri.IssueManagement.xUri, tmp);
            containsDistRepo |= PomTransformer.hasProjectUri(ProjectUri.DistributionManagement.Repository.xUri, tmp);
            containsDistSnapRepo |= PomTransformer.hasProjectUri(ProjectUri.DistributionManagement.SnapshotRepository.xUri, tmp);
            containsDistSite |= PomTransformer.hasProjectUri(ProjectUri.DistributionManagement.Site.xUri, tmp);
            ModelProperty artifactId = PomTransformer.getPropertyFor(ProjectUri.artifactId, tmp);
            if (artifactId != null) {
                projectNames.add(0, artifactId.getResolvedValue());
            }
            tmp.removeAll(clearedProperties);
            modelProperties.addAll(tmp);
            modelProperties.removeAll(clearedProperties);
        }
        DefaultModelDataSource source = new DefaultModelDataSource(modelProperties, MODEL_CONTAINER_FACTORIES);
        List list = source.queryFor(ProjectUri.Reporting.Plugins.Plugin.xUri);
        block12: for (ModelContainer pluginContainer : source.queryFor(ProjectUri.Build.Plugins.Plugin.xUri)) {
            ModelContainer transformedReportContainer = new ArtifactModelContainerFactory().create(PomTransformer.transformPlugin(pluginContainer.getProperties()));
            for (ModelContainer reportContainer : list) {
                ModelContainerAction action = transformedReportContainer.containerAction(reportContainer);
                if (!action.equals((Object)ModelContainerAction.JOIN)) continue;
                source.join(transformedReportContainer, reportContainer);
                continue block12;
            }
        }
        modelProperties = source.getModelProperties();
        return modelProperties;
    }

    public void interpolateModelProperties(List<ModelProperty> modelProperties, List<InterpolatorProperty> interpolatorProperties, DomainModel domainModel) throws IOException {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("project.", "pom.");
        aliases.put("\\$\\{project.build.", "\\$\\{build.");
        if (!PomTransformer.containsProjectVersion(interpolatorProperties)) {
            aliases.put("\\$\\{project.version\\}", "\\$\\{version\\}");
        }
        ArrayList<ModelProperty> firstPassModelProperties = new ArrayList<ModelProperty>();
        ArrayList<ModelProperty> secondPassModelProperties = new ArrayList<ModelProperty>();
        ModelProperty buildProperty = new ModelProperty(ProjectUri.Build.xUri, null);
        for (ModelProperty mp : modelProperties) {
            if (mp.getValue() == null || mp.getUri().contains("#property") || mp.getUri().contains("#collection")) continue;
            if (!buildProperty.isParentOf(mp) || mp.getUri().equals(ProjectUri.Build.finalName)) {
                firstPassModelProperties.add(mp);
                continue;
            }
            secondPassModelProperties.add(mp);
        }
        ArrayList<InterpolatorProperty> standardInterpolatorProperties = new ArrayList<InterpolatorProperty>();
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.properties) || mp.getValue() == null) continue;
            String uri = mp.getUri();
            standardInterpolatorProperties.add(new InterpolatorProperty("${" + uri.substring(uri.lastIndexOf("/") + 1, uri.length()) + "}", mp.getValue(), PomInterpolatorTag.PROJECT_PROPERTIES.name()));
        }
        ArrayList<InterpolatorProperty> ips1 = new ArrayList<InterpolatorProperty>(interpolatorProperties);
        ips1.addAll(standardInterpolatorProperties);
        ips1.addAll(ModelTransformerContext.createInterpolatorProperties(firstPassModelProperties, (String)ProjectUri.baseUri, aliases, (String)PomInterpolatorTag.PROJECT_PROPERTIES.name(), (boolean)false, (boolean)false));
        Collections.sort(ips1, new Comparator<InterpolatorProperty>(){

            @Override
            public int compare(InterpolatorProperty o, InterpolatorProperty o1) {
                if (o.getTag() == null || o1.getTag() == null) {
                    return 0;
                }
                return PomInterpolatorTag.valueOf(o.getTag()).compareTo(PomInterpolatorTag.valueOf(o1.getTag()));
            }
        });
        ModelTransformerContext.interpolateModelProperties(modelProperties, ips1);
    }

    public List<ModelProperty> preprocessModelProperties(List<ModelProperty> modelProperties) {
        return new ArrayList<ModelProperty>(modelProperties);
    }

    public final String getBaseUri() {
        return ProjectUri.baseUri;
    }

    private void adjustUrl(StringBuilder url, List<ModelProperty> properties, String uri, List<String> ids) {
        ModelProperty property;
        if (url.length() == 0 && (property = PomTransformer.getPropertyFor(uri, properties)) != null) {
            url.append(property.getResolvedValue());
            for (String id : ids) {
                if (url.length() > 0 && url.charAt(url.length() - 1) != '/') {
                    url.append('/');
                }
                url.append(id);
            }
            int index = properties.indexOf(property);
            properties.set(index, new ModelProperty(uri, url.toString()));
        }
    }

    private static boolean containsProjectVersion(List<InterpolatorProperty> interpolatorProperties) {
        InterpolatorProperty versionInterpolatorProperty = new ModelProperty(ProjectUri.version, "").asInterpolatorProperty(ProjectUri.baseUri);
        for (InterpolatorProperty ip : interpolatorProperties) {
            if (!ip.equals((Object)versionInterpolatorProperty)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExecutionId(ModelContainer executionContainer) {
        for (ModelProperty mp : executionContainer.getProperties()) {
            if (!mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Executions.Execution.id)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasProjectUri(String projectUri, List<ModelProperty> modelProperties) {
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().equals(projectUri)) continue;
            return true;
        }
        return false;
    }

    private static List<ModelProperty> getPropertiesFor(String uri, List<ModelProperty> properties) {
        ArrayList<ModelProperty> modelProperties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : properties) {
            if (!uri.equals(mp.getUri())) continue;
            modelProperties.add(mp);
        }
        return modelProperties;
    }

    private static ModelProperty getPropertyFor(String uri, List<ModelProperty> properties) {
        for (ModelProperty mp : properties) {
            if (!uri.equals(mp.getUri())) continue;
            return mp;
        }
        return null;
    }

    private static List<ModelProperty> transformPlugin(List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> transformedProperties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.Build.Plugins.xUri) || !mp.getUri().startsWith(ProjectUri.Build.Plugins.Plugin.configuration) && !mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.groupId) && !mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.artifactId) && !mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.version) && !mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.xUri)) continue;
            transformedProperties.add(new ModelProperty(mp.getUri().replace(ProjectUri.Build.Plugins.xUri, ProjectUri.Reporting.Plugins.xUri), mp.getResolvedValue()));
        }
        return transformedProperties;
    }
}

