/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hslf.record.AnimationInfo;
import org.apache.poi.hslf.record.AnimationInfoAtom;
import org.apache.poi.hslf.record.BinaryTagDataBlob;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.Comment2000;
import org.apache.poi.hslf.record.Comment2000Atom;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.DocumentEncryptionAtom;
import org.apache.poi.hslf.record.DummyPositionSensitiveRecordWithChildren;
import org.apache.poi.hslf.record.Environment;
import org.apache.poi.hslf.record.ExAviMovie;
import org.apache.poi.hslf.record.ExControl;
import org.apache.poi.hslf.record.ExControlAtom;
import org.apache.poi.hslf.record.ExEmbed;
import org.apache.poi.hslf.record.ExEmbedAtom;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExHyperlinkAtom;
import org.apache.poi.hslf.record.ExMCIMovie;
import org.apache.poi.hslf.record.ExMediaAtom;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.ExObjListAtom;
import org.apache.poi.hslf.record.ExObjRefAtom;
import org.apache.poi.hslf.record.ExOleObjAtom;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.hslf.record.ExVideoContainer;
import org.apache.poi.hslf.record.FontCollection;
import org.apache.poi.hslf.record.FontEntityAtom;
import org.apache.poi.hslf.record.HeadersFootersAtom;
import org.apache.poi.hslf.record.HeadersFootersContainer;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.MasterTextPropAtom;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.NotesAtom;
import org.apache.poi.hslf.record.OEPlaceholderAtom;
import org.apache.poi.hslf.record.OutlineTextRefAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.PPDrawingGroup;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RoundTripHFPlaceholder12;
import org.apache.poi.hslf.record.SSSlideInfoAtom;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.Sound;
import org.apache.poi.hslf.record.SoundCollection;
import org.apache.poi.hslf.record.SoundData;
import org.apache.poi.hslf.record.StyleTextProp9Atom;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.hslf.record.TextRulerAtom;
import org.apache.poi.hslf.record.TextSpecInfoAtom;
import org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import org.apache.poi.hslf.record.TxMasterStyleAtom;
import org.apache.poi.hslf.record.UnknownRecordPlaceholder;
import org.apache.poi.hslf.record.UserEditAtom;

public enum RecordTypes {
    Unknown(0, null),
    UnknownRecordPlaceholder(-1, UnknownRecordPlaceholder.class),
    Document(1000, Document.class),
    DocumentAtom(1001, DocumentAtom.class),
    EndDocument(1002, null),
    Slide(1006, Slide.class),
    SlideAtom(1007, SlideAtom.class),
    Notes(1008, Notes.class),
    NotesAtom(1009, NotesAtom.class),
    Environment(1010, Environment.class),
    SlidePersistAtom(1011, SlidePersistAtom.class),
    SSlideLayoutAtom(1015, null),
    MainMaster(1016, MainMaster.class),
    SSSlideInfoAtom(1017, SSSlideInfoAtom.class),
    SlideViewInfo(1018, null),
    GuideAtom(1019, null),
    ViewInfo(1020, null),
    ViewInfoAtom(1021, null),
    SlideViewInfoAtom(1022, null),
    VBAInfo(1023, null),
    VBAInfoAtom(1024, null),
    SSDocInfoAtom(1025, null),
    Summary(1026, null),
    DocRoutingSlip(1030, null),
    OutlineViewInfo(1031, null),
    SorterViewInfo(1032, null),
    ExObjList(1033, ExObjList.class),
    ExObjListAtom(1034, ExObjListAtom.class),
    PPDrawingGroup(1035, PPDrawingGroup.class),
    PPDrawing(1036, PPDrawing.class),
    NamedShows(1040, null),
    NamedShow(1041, null),
    NamedShowSlides(1042, null),
    SheetProperties(1044, null),
    RoundTripCustomTableStyles12Atom(1064, null),
    List(2000, null),
    FontCollection(2005, FontCollection.class),
    BookmarkCollection(2019, null),
    SoundCollection(2020, SoundCollection.class),
    SoundCollAtom(2021, null),
    Sound(2022, Sound.class),
    SoundData(2023, SoundData.class),
    BookmarkSeedAtom(2025, null),
    ColorSchemeAtom(2032, ColorSchemeAtom.class),
    ExObjRefAtom(3009, ExObjRefAtom.class),
    OEPlaceholderAtom(3011, OEPlaceholderAtom.class),
    GPopublicintAtom(3024, null),
    GRatioAtom(3031, null),
    OutlineTextRefAtom(3998, OutlineTextRefAtom.class),
    TextHeaderAtom(3999, TextHeaderAtom.class),
    TextCharsAtom(4000, TextCharsAtom.class),
    StyleTextPropAtom(4001, StyleTextPropAtom.class),
    MasterTextPropAtom(4002, MasterTextPropAtom.class),
    TxMasterStyleAtom(4003, TxMasterStyleAtom.class),
    TxCFStyleAtom(4004, null),
    TxPFStyleAtom(4005, null),
    TextRulerAtom(4006, TextRulerAtom.class),
    TextBookmarkAtom(4007, null),
    TextBytesAtom(4008, TextBytesAtom.class),
    TxSIStyleAtom(4009, null),
    TextSpecInfoAtom(4010, TextSpecInfoAtom.class),
    DefaultRulerAtom(4011, null),
    StyleTextProp9Atom(4012, StyleTextProp9Atom.class),
    FontEntityAtom(4023, FontEntityAtom.class),
    FontEmbeddedData(4024, null),
    CString(4026, CString.class),
    MetaFile(4033, null),
    ExOleObjAtom(4035, ExOleObjAtom.class),
    SrKinsoku(4040, null),
    HandOut(4041, DummyPositionSensitiveRecordWithChildren.class),
    ExEmbed(4044, ExEmbed.class),
    ExEmbedAtom(4045, ExEmbedAtom.class),
    ExLink(4046, null),
    BookmarkEntityAtom(4048, null),
    ExLinkAtom(4049, null),
    SrKinsokuAtom(4050, null),
    ExHyperlinkAtom(4051, ExHyperlinkAtom.class),
    ExHyperlink(4055, ExHyperlink.class),
    SlideNumberMCAtom(4056, null),
    HeadersFooters(4057, HeadersFootersContainer.class),
    HeadersFootersAtom(4058, HeadersFootersAtom.class),
    TxInteractiveInfoAtom(4063, TxInteractiveInfoAtom.class),
    CharFormatAtom(4066, null),
    ParaFormatAtom(4067, null),
    RecolorInfoAtom(4071, null),
    ExQuickTimeMovie(4074, null),
    ExQuickTimeMovieData(4075, null),
    ExControl(4078, ExControl.class),
    SlideListWithText(4080, SlideListWithText.class),
    InteractiveInfo(4082, InteractiveInfo.class),
    InteractiveInfoAtom(4083, InteractiveInfoAtom.class),
    UserEditAtom(4085, UserEditAtom.class),
    CurrentUserAtom(4086, null),
    DateTimeMCAtom(4087, null),
    GenericDateMCAtom(4088, null),
    FooterMCAtom(4090, null),
    ExControlAtom(4091, ExControlAtom.class),
    ExMediaAtom(4100, ExMediaAtom.class),
    ExVideoContainer(4101, ExVideoContainer.class),
    ExAviMovie(4102, ExAviMovie.class),
    ExMCIMovie(4103, ExMCIMovie.class),
    ExMIDIAudio(4109, null),
    ExCDAudio(4110, null),
    ExWAVAudioEmbedded(4111, null),
    ExWAVAudioLink(4112, null),
    ExOleObjStg(4113, ExOleObjStg.class),
    ExCDAudioAtom(4114, null),
    ExWAVAudioEmbeddedAtom(4115, null),
    AnimationInfo(4116, AnimationInfo.class),
    AnimationInfoAtom(4081, AnimationInfoAtom.class),
    RTFDateTimeMCAtom(4117, null),
    ProgTags(5000, DummyPositionSensitiveRecordWithChildren.class),
    ProgStringTag(5001, null),
    ProgBinaryTag(5002, DummyPositionSensitiveRecordWithChildren.class),
    BinaryTagData(5003, BinaryTagDataBlob.class),
    PrpublicintOptions(6000, null),
    PersistPtrFullBlock(6001, PersistPtrHolder.class),
    PersistPtrIncrementalBlock(6002, PersistPtrHolder.class),
    GScalingAtom(10001, null),
    GRColorAtom(10002, null),
    Comment2000(12000, Comment2000.class),
    Comment2000Atom(12001, Comment2000Atom.class),
    Comment2000Summary(12004, null),
    Comment2000SummaryAtom(12005, null),
    DocumentEncryptionAtom(12052, DocumentEncryptionAtom.class),
    OriginalMainMasterId(1052, null),
    CompositeMasterId(1052, null),
    RoundTripContentMasterInfo12(1054, null),
    RoundTripShapeId12(1055, null),
    RoundTripHFPlaceholder12(1056, RoundTripHFPlaceholder12.class),
    RoundTripContentMasterId(1058, null),
    RoundTripOArtTextStyles12(1059, null),
    RoundTripShapeCheckSumForCustomLayouts12(1062, null),
    RoundTripNotesMasterTextStyles12(1063, null),
    RoundTripCustomTableStyles12(1064, null),
    EscherDggContainer(61440, null),
    EscherDgg(61446, null),
    EscherCLSID(61462, null),
    EscherOPT(61451, null),
    EscherBStoreContainer(61441, null),
    EscherBSE(61447, null),
    EscherBlip_START(61464, null),
    EscherBlip_END(61719, null),
    EscherDgContainer(61442, null),
    EscherDg(61448, null),
    EscherRegroupItems(61720, null),
    EscherColorScheme(61728, null),
    EscherSpgrContainer(61443, null),
    EscherSpContainer(61444, null),
    EscherSpgr(61449, null),
    EscherSp(61450, null),
    EscherTextbox(61452, null),
    EscherClientTextbox(61453, null),
    EscherAnchor(61454, null),
    EscherChildAnchor(61455, null),
    EscherClientAnchor(61456, null),
    EscherClientData(61457, null),
    EscherSolverContainer(61445, null),
    EscherConnectorRule(61458, null),
    EscherAlignRule(61459, null),
    EscherArcRule(61460, null),
    EscherClientRule(61461, null),
    EscherCalloutRule(61463, null),
    EscherSelection(61721, null),
    EscherColorMRU(61722, null),
    EscherDeletedPspl(61725, null),
    EscherSplitMenuColors(61726, null),
    EscherOleObject(61727, null),
    EscherUserDefined(61730, null);

    private static final Map<Short, RecordTypes> LOOKUP;
    public final short typeID;
    public final Class<? extends Record> handlingClass;

    private RecordTypes(int typeID, Class<? extends Record> handlingClass) {
        this.typeID = (short)typeID;
        this.handlingClass = handlingClass;
    }

    public static RecordTypes forTypeID(int typeID) {
        RecordTypes rt = LOOKUP.get((short)typeID);
        return rt != null ? rt : UnknownRecordPlaceholder;
    }

    static {
        LOOKUP = new HashMap<Short, RecordTypes>();
        for (RecordTypes s : RecordTypes.values()) {
            LOOKUP.put(s.typeID, s);
        }
    }
}

