/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.execute.sql.execute;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.sharding.execute.sql.StatementExecuteUnit;
import org.apache.shardingsphere.sharding.execute.sql.execute.threadlocal.ExecutorExceptionHandler;
import org.apache.shardingsphere.spi.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.underlying.executor.constant.ConnectionMode;
import org.apache.shardingsphere.underlying.executor.context.ExecutionUnit;
import org.apache.shardingsphere.underlying.executor.engine.GroupedCallback;
import org.apache.shardingsphere.underlying.executor.hook.SPISQLExecutionHook;

public abstract class SQLExecuteCallback<T>
implements GroupedCallback<StatementExecuteUnit, T> {
    private static final Map<String, DataSourceMetaData> CACHED_DATASOURCE_METADATA = new ConcurrentHashMap<String, DataSourceMetaData>();
    private final DatabaseType databaseType;
    private final boolean isExceptionThrown;

    public final Collection<T> execute(Collection<StatementExecuteUnit> statementExecuteUnits, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (StatementExecuteUnit each : statementExecuteUnits) {
            result.add(this.execute0(each, isTrunkThread, dataMap));
        }
        return result;
    }

    private T execute0(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        ExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        DataSourceMetaData dataSourceMetaData = this.getDataSourceMetaData(statementExecuteUnit.getStatement().getConnection().getMetaData());
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        try {
            ExecutionUnit executionUnit = statementExecuteUnit.getExecutionUnit();
            sqlExecutionHook.start(executionUnit.getDataSourceName(), executionUnit.getSqlUnit().getSql(), executionUnit.getSqlUnit().getParameters(), dataSourceMetaData, isTrunkThread, dataMap);
            T result = this.executeSQL(executionUnit.getSqlUnit().getSql(), statementExecuteUnit.getStatement(), statementExecuteUnit.getConnectionMode());
            sqlExecutionHook.finishSuccess();
            return result;
        }
        catch (SQLException ex) {
            sqlExecutionHook.finishFailure((Exception)ex);
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    private DataSourceMetaData getDataSourceMetaData(DatabaseMetaData metaData) throws SQLException {
        String url = metaData.getURL();
        if (CACHED_DATASOURCE_METADATA.containsKey(url)) {
            return CACHED_DATASOURCE_METADATA.get(url);
        }
        DataSourceMetaData result = this.databaseType.getDataSourceMetaData(url, metaData.getUserName());
        CACHED_DATASOURCE_METADATA.put(url, result);
        return result;
    }

    protected abstract T executeSQL(String var1, Statement var2, ConnectionMode var3) throws SQLException;

    @Generated
    public SQLExecuteCallback(DatabaseType databaseType, boolean isExceptionThrown) {
        this.databaseType = databaseType;
        this.isExceptionThrown = isExceptionThrown;
    }
}

