/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.execute.sql.execute.result;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.shardingsphere.underlying.executor.QueryResult;

public final class StreamQueryResult
implements QueryResult {
    private final ResultSetMetaData resultSetMetaData;
    private final ResultSet resultSet;

    public StreamQueryResult(ResultSet resultSet) throws SQLException {
        this.resultSetMetaData = resultSet.getMetaData();
        this.resultSet = resultSet;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Boolean.TYPE == type) {
            return this.resultSet.getBoolean(columnIndex);
        }
        if (Byte.TYPE == type) {
            return this.resultSet.getByte(columnIndex);
        }
        if (Short.TYPE == type) {
            return this.resultSet.getShort(columnIndex);
        }
        if (Integer.TYPE == type) {
            return this.resultSet.getInt(columnIndex);
        }
        if (Long.TYPE == type) {
            return this.resultSet.getLong(columnIndex);
        }
        if (Float.TYPE == type) {
            return Float.valueOf(this.resultSet.getFloat(columnIndex));
        }
        if (Double.TYPE == type) {
            return this.resultSet.getDouble(columnIndex);
        }
        if (String.class == type) {
            return this.resultSet.getString(columnIndex);
        }
        if (BigDecimal.class == type) {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        if (byte[].class == type) {
            return this.resultSet.getBytes(columnIndex);
        }
        if (Date.class == type) {
            return this.resultSet.getDate(columnIndex);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnIndex);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnIndex);
        }
        if (Blob.class == type) {
            return this.resultSet.getBlob(columnIndex);
        }
        if (Clob.class == type) {
            return this.resultSet.getClob(columnIndex);
        }
        return this.resultSet.getObject(columnIndex);
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.resultSet.getDate(columnIndex, calendar);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnIndex, calendar);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnIndex, calendar);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        switch (type) {
            case "Ascii": {
                return this.resultSet.getAsciiStream(columnIndex);
            }
            case "Unicode": {
                return this.resultSet.getUnicodeStream(columnIndex);
            }
            case "Binary": {
                return this.resultSet.getBinaryStream(columnIndex);
            }
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public int getColumnCount() throws SQLException {
        return this.resultSetMetaData.getColumnCount();
    }

    public String getColumnName(int columnIndex) throws SQLException {
        return this.resultSetMetaData.getColumnName(columnIndex);
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.resultSetMetaData.getColumnLabel(columnIndex);
    }
}

