/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.execute.sql.execute.threadlocal;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorExceptionHandler.class);
    private static final ThreadLocal<Boolean> IS_EXCEPTION_THROWN = ThreadLocal.withInitial(() -> true);

    public static void setExceptionThrown(boolean isExceptionThrown) {
        IS_EXCEPTION_THROWN.set(isExceptionThrown);
    }

    public static boolean isExceptionThrown() {
        return IS_EXCEPTION_THROWN.get();
    }

    public static void handleException(Exception exception) throws SQLException {
        if (ExecutorExceptionHandler.isExceptionThrown()) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new ShardingSphereException(exception);
        }
        log.error("exception occur: ", (Throwable)exception);
    }

    @Generated
    private ExecutorExceptionHandler() {
    }
}

