/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.execute.sql.prepare;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.sharding.execute.sql.StatementExecuteUnit;
import org.apache.shardingsphere.sharding.execute.sql.prepare.SQLExecutePrepareCallback;
import org.apache.shardingsphere.underlying.executor.constant.ConnectionMode;
import org.apache.shardingsphere.underlying.executor.context.ExecutionUnit;
import org.apache.shardingsphere.underlying.executor.context.SQLUnit;
import org.apache.shardingsphere.underlying.executor.engine.InputGroup;

public final class SQLExecutePrepareTemplate {
    private final int maxConnectionsSizePerQuery;

    public Collection<InputGroup<StatementExecuteUnit>> getExecuteUnitGroups(Collection<ExecutionUnit> executionUnits, SQLExecutePrepareCallback callback) throws SQLException {
        return this.getSynchronizedExecuteUnitGroups(executionUnits, callback);
    }

    private Collection<InputGroup<StatementExecuteUnit>> getSynchronizedExecuteUnitGroups(Collection<ExecutionUnit> executionUnits, SQLExecutePrepareCallback callback) throws SQLException {
        Map<String, List<SQLUnit>> sqlUnitGroups = this.getSQLUnitGroups(executionUnits);
        LinkedList<InputGroup<StatementExecuteUnit>> result = new LinkedList<InputGroup<StatementExecuteUnit>>();
        for (Map.Entry<String, List<SQLUnit>> entry : sqlUnitGroups.entrySet()) {
            result.addAll(this.getSQLExecuteGroups(entry.getKey(), entry.getValue(), callback));
        }
        return result;
    }

    private Map<String, List<SQLUnit>> getSQLUnitGroups(Collection<ExecutionUnit> executionUnits) {
        LinkedHashMap<String, List<SQLUnit>> result = new LinkedHashMap<String, List<SQLUnit>>(executionUnits.size(), 1.0f);
        for (ExecutionUnit each : executionUnits) {
            if (!result.containsKey(each.getDataSourceName())) {
                result.put(each.getDataSourceName(), new LinkedList());
            }
            ((List)result.get(each.getDataSourceName())).add(each.getSqlUnit());
        }
        return result;
    }

    private List<InputGroup<StatementExecuteUnit>> getSQLExecuteGroups(String dataSourceName, List<SQLUnit> sqlUnits, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<InputGroup<StatementExecuteUnit>> result = new LinkedList<InputGroup<StatementExecuteUnit>>();
        int desiredPartitionSize = Math.max(0 == sqlUnits.size() % this.maxConnectionsSizePerQuery ? sqlUnits.size() / this.maxConnectionsSizePerQuery : sqlUnits.size() / this.maxConnectionsSizePerQuery + 1, 1);
        List sqlUnitPartitions = Lists.partition(sqlUnits, (int)desiredPartitionSize);
        ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < sqlUnits.size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
        List<Connection> connections = callback.getConnections(connectionMode, dataSourceName, sqlUnitPartitions.size());
        int count = 0;
        for (List each : sqlUnitPartitions) {
            result.add(this.getSQLExecuteGroup(connectionMode, connections.get(count++), dataSourceName, each, callback));
        }
        return result;
    }

    private InputGroup<StatementExecuteUnit> getSQLExecuteGroup(ConnectionMode connectionMode, Connection connection, String dataSourceName, List<SQLUnit> sqlUnitGroup, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<StatementExecuteUnit> result = new LinkedList<StatementExecuteUnit>();
        for (SQLUnit each : sqlUnitGroup) {
            result.add(callback.createStatementExecuteUnit(connection, new ExecutionUnit(dataSourceName, each), connectionMode));
        }
        return new InputGroup(result);
    }

    @Generated
    public SQLExecutePrepareTemplate(int maxConnectionsSizePerQuery) {
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
    }
}

