/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.rule.BindingTableRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.core.strategy.route.hint.HintShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.InsertClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.WhereClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngineFactory;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidatorFactory;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.underlying.route.context.RouteContext;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.decorator.RouteDecorator;

public final class ShardingRouteDecorator
implements RouteDecorator<ShardingRule> {
    public RouteContext decorate(RouteContext routeContext, ShardingSphereMetaData metaData, ShardingRule shardingRule, ConfigurationProperties properties) {
        SQLStatementContext sqlStatementContext = routeContext.getSqlStatementContext();
        List parameters = routeContext.getParameters();
        ShardingStatementValidatorFactory.newInstance(sqlStatementContext.getSqlStatement()).ifPresent(validator -> validator.validate(shardingRule, sqlStatementContext.getSqlStatement(), parameters));
        ShardingConditions shardingConditions = this.getShardingConditions(parameters, sqlStatementContext, metaData.getSchema(), shardingRule);
        boolean needMergeShardingValues = this.isNeedMergeShardingValues(sqlStatementContext, shardingRule);
        if (sqlStatementContext.getSqlStatement() instanceof DMLStatement && needMergeShardingValues) {
            this.checkSubqueryShardingValues(sqlStatementContext, shardingRule, shardingConditions);
            this.mergeShardingConditions(shardingConditions);
        }
        ShardingRouteEngine shardingRouteEngine = ShardingRouteEngineFactory.newInstance(shardingRule, metaData, sqlStatementContext, shardingConditions, properties);
        RouteResult routeResult = shardingRouteEngine.route(shardingRule);
        if (needMergeShardingValues) {
            Preconditions.checkState((1 == routeResult.getRouteUnits().size() ? 1 : 0) != 0, (Object)"Must have one sharding with subquery.");
        }
        return new RouteContext(sqlStatementContext, parameters, routeResult);
    }

    private ShardingConditions getShardingConditions(List<Object> parameters, SQLStatementContext sqlStatementContext, SchemaMetaData schemaMetaData, ShardingRule shardingRule) {
        if (sqlStatementContext.getSqlStatement() instanceof DMLStatement) {
            if (sqlStatementContext instanceof InsertStatementContext) {
                return new ShardingConditions(new InsertClauseShardingConditionEngine(shardingRule).createShardingConditions((InsertStatementContext)sqlStatementContext, parameters));
            }
            return new ShardingConditions(new WhereClauseShardingConditionEngine(shardingRule, schemaMetaData).createShardingConditions(sqlStatementContext, parameters));
        }
        return new ShardingConditions(Collections.emptyList());
    }

    private boolean isNeedMergeShardingValues(SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsSubquery() && !shardingRule.getShardingLogicTableNames(sqlStatementContext.getTablesContext().getTableNames()).isEmpty();
    }

    private void checkSubqueryShardingValues(SQLStatementContext sqlStatementContext, ShardingRule shardingRule, ShardingConditions shardingConditions) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            Optional tableRule = shardingRule.findTableRule(each);
            if (!tableRule.isPresent() || !this.isRoutingByHint(shardingRule, (TableRule)tableRule.get()) || HintManager.getDatabaseShardingValues((String)each).isEmpty() || HintManager.getTableShardingValues((String)each).isEmpty()) continue;
            return;
        }
        Preconditions.checkState((!shardingConditions.getConditions().isEmpty() ? 1 : 0) != 0, (Object)"Must have sharding column with subquery.");
        if (shardingConditions.getConditions().size() > 1) {
            Preconditions.checkState((boolean)this.isSameShardingCondition(shardingRule, shardingConditions), (Object)"Sharding value must same with subquery.");
        }
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, TableRule tableRule) {
        return shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy && shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingConditions shardingConditions) {
        ShardingCondition example = shardingConditions.getConditions().remove(shardingConditions.getConditions().size() - 1);
        for (ShardingCondition each : shardingConditions.getConditions()) {
            if (this.isSameShardingCondition(shardingRule, example, each)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingCondition shardingCondition1, ShardingCondition shardingCondition2) {
        if (shardingCondition1.getRouteValues().size() != shardingCondition2.getRouteValues().size()) {
            return false;
        }
        for (int i = 0; i < shardingCondition1.getRouteValues().size(); ++i) {
            RouteValue shardingValue2;
            RouteValue shardingValue1 = shardingCondition1.getRouteValues().get(i);
            if (this.isSameRouteValue(shardingRule, (ListRouteValue)shardingValue1, (ListRouteValue)(shardingValue2 = shardingCondition2.getRouteValues().get(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameRouteValue(ShardingRule shardingRule, ListRouteValue routeValue1, ListRouteValue routeValue2) {
        return this.isSameLogicTable(shardingRule, routeValue1, routeValue2) && routeValue1.getColumnName().equals(routeValue2.getColumnName()) && routeValue1.getValues().equals(routeValue2.getValues());
    }

    private boolean isSameLogicTable(ShardingRule shardingRule, ListRouteValue shardingValue1, ListRouteValue shardingValue2) {
        return shardingValue1.getTableName().equals(shardingValue2.getTableName()) || this.isBindingTable(shardingRule, shardingValue1, shardingValue2);
    }

    private boolean isBindingTable(ShardingRule shardingRule, ListRouteValue shardingValue1, ListRouteValue shardingValue2) {
        Optional bindingRule = shardingRule.findBindingTableRule(shardingValue1.getTableName());
        return bindingRule.isPresent() && ((BindingTableRule)bindingRule.get()).hasLogicTable(shardingValue2.getTableName());
    }

    private void mergeShardingConditions(ShardingConditions shardingConditions) {
        if (shardingConditions.getConditions().size() > 1) {
            ShardingCondition shardingCondition = shardingConditions.getConditions().remove(shardingConditions.getConditions().size() - 1);
            shardingConditions.getConditions().clear();
            shardingConditions.getConditions().add(shardingCondition);
        }
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getType() {
        return ShardingRule.class;
    }
}

