/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ConditionValue {
    private final Comparable value;

    public ConditionValue(ExpressionSegment expressionSegment, List<Object> parameters) {
        this.value = this.getValue(expressionSegment, parameters);
    }

    private Comparable getValue(ExpressionSegment expressionSegment, List<Object> parameters) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            return this.getValue((ParameterMarkerExpressionSegment)expressionSegment, parameters);
        }
        if (expressionSegment instanceof LiteralExpressionSegment) {
            return this.getValue((LiteralExpressionSegment)expressionSegment);
        }
        return null;
    }

    private Comparable getValue(ParameterMarkerExpressionSegment expressionSegment, List<Object> parameters) {
        Object result = parameters.get(expressionSegment.getParameterMarkerIndex());
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    private Comparable getValue(LiteralExpressionSegment expressionSegment) {
        Object result = expressionSegment.getLiterals();
        Preconditions.checkArgument((boolean)(result instanceof Comparable), (Object)"Sharding value must implements Comparable.");
        return (Comparable)result;
    }

    public Optional<Comparable> getValue() {
        return Optional.ofNullable(this.value);
    }
}

