/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.spi.SPITimeService;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;

public final class ConditionValueCompareOperatorGenerator
implements ConditionValueGenerator<PredicateCompareRightValue> {
    private static final String EQUAL = "=";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN = "<";
    private static final String AT_MOST = "<=";
    private static final String AT_LEAST = ">=";
    private static final List<String> OPERATORS = Arrays.asList("=", ">", "<", ">=", "<=");

    @Override
    public Optional<RouteValue> generate(PredicateCompareRightValue predicateRightValue, Column column, List<Object> parameters) {
        String operator = predicateRightValue.getOperator();
        if (!this.isSupportedOperator(operator)) {
            return Optional.empty();
        }
        Optional<Comparable> routeValue = new ConditionValue(predicateRightValue.getExpression(), parameters).getValue();
        if (routeValue.isPresent()) {
            return this.generate(routeValue.get(), column, operator);
        }
        if (ExpressionConditionUtils.isNowExpression(predicateRightValue.getExpression())) {
            return this.generate(new SPITimeService().getTime(), column, operator);
        }
        return Optional.empty();
    }

    private Optional<RouteValue> generate(Comparable comparable, Column column, String operator) {
        String columnName = column.getName();
        String tableName = column.getTableName();
        switch (operator) {
            case "=": {
                return Optional.of(new ListRouteValue(columnName, tableName, (Collection)Lists.newArrayList((Object[])new Comparable[]{comparable})));
            }
            case ">": {
                return Optional.of(new RangeRouteValue(columnName, tableName, Range.greaterThan((Comparable)comparable)));
            }
            case "<": {
                return Optional.of(new RangeRouteValue(columnName, tableName, Range.lessThan((Comparable)comparable)));
            }
            case "<=": {
                return Optional.of(new RangeRouteValue(columnName, tableName, Range.atMost((Comparable)comparable)));
            }
            case ">=": {
                return Optional.of(new RangeRouteValue(columnName, tableName, Range.atLeast((Comparable)comparable)));
            }
        }
        return Optional.empty();
    }

    private boolean isSupportedOperator(String operator) {
        return OPERATORS.contains(operator);
    }
}

