/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.broadcast;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class ShardingTableBroadcastRoutingEngine
implements ShardingRouteEngine {
    private final SchemaMetaData schemaMetaData;
    private final SQLStatementContext sqlStatementContext;

    @Override
    public RouteResult route(ShardingRule shardingRule) {
        RouteResult result = new RouteResult();
        for (String each : this.getLogicTableNames()) {
            result.getRouteUnits().addAll(this.getAllRouteUnits(shardingRule, each));
        }
        return result;
    }

    private Collection<String> getLogicTableNames() {
        return this.sqlStatementContext.getSqlStatement() instanceof DropIndexStatement && !((DropIndexStatement)this.sqlStatementContext.getSqlStatement()).getIndexes().isEmpty() ? this.getTableNamesFromMetaData((DropIndexStatement)this.sqlStatementContext.getSqlStatement()) : this.sqlStatementContext.getTablesContext().getTableNames();
    }

    private Collection<String> getTableNamesFromMetaData(DropIndexStatement dropIndexStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IndexSegment each : dropIndexStatement.getIndexes()) {
            Optional<String> tableName = this.findLogicTableNameFromMetaData(each.getIdentifier().getValue());
            Preconditions.checkState((boolean)tableName.isPresent(), (String)"Cannot find index name `%s`.", (Object[])new Object[]{each.getIdentifier().getValue()});
            result.add(tableName.get());
        }
        return result;
    }

    private Optional<String> findLogicTableNameFromMetaData(String logicIndexName) {
        for (String each : this.schemaMetaData.getAllTableNames()) {
            if (!this.schemaMetaData.get(each).getIndexes().containsKey(logicIndexName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Collection<RouteUnit> getAllRouteUnits(ShardingRule shardingRule, String logicTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        TableRule tableRule = shardingRule.getTableRule(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            RouteUnit routeUnit = new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, each.getTableName())));
            result.add(routeUnit);
        }
        return result;
    }

    @Generated
    public ShardingTableBroadcastRoutingEngine(SchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext) {
        this.schemaMetaData = schemaMetaData;
        this.sqlStatementContext = sqlStatementContext;
    }
}

