/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.unicast;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.underlying.common.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class ShardingUnicastRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;

    @Override
    public RouteResult route(ShardingRule shardingRule) {
        RouteResult result = new RouteResult();
        String dataSourceName = shardingRule.getShardingDataSourceNames().getRandomDataSourceName();
        RouteMapper dataSourceMapper = new RouteMapper(dataSourceName, dataSourceName);
        if (shardingRule.isAllBroadcastTables(this.logicTables)) {
            ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
            for (String each : this.logicTables) {
                tableMappers.add(new RouteMapper(each, each));
            }
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, tableMappers));
        } else if (this.logicTables.isEmpty()) {
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
        } else if (1 == this.logicTables.size()) {
            String logicTableName = this.logicTables.iterator().next();
            if (!shardingRule.findTableRule(logicTableName).isPresent()) {
                result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.emptyList()));
                return result;
            }
            DataNode dataNode = shardingRule.getDataNode(logicTableName);
            result.getRouteUnits().add(new RouteUnit(dataSourceMapper, Collections.singletonList(new RouteMapper(logicTableName, dataNode.getTableName()))));
        } else {
            ArrayList<RouteMapper> tableMappers = new ArrayList<RouteMapper>(this.logicTables.size());
            Sets.SetView availableDatasourceNames = null;
            boolean first = true;
            for (String each : this.logicTables) {
                TableRule tableRule = shardingRule.getTableRule(each);
                DataNode dataNode = (DataNode)tableRule.getActualDataNodes().get(0);
                tableMappers.add(new RouteMapper(each, dataNode.getTableName()));
                Sets.SetView currentDataSourceNames = new HashSet(tableRule.getActualDatasourceNames().size());
                for (DataNode eachDataNode : tableRule.getActualDataNodes()) {
                    currentDataSourceNames.add(eachDataNode.getDataSourceName());
                }
                if (first) {
                    availableDatasourceNames = currentDataSourceNames;
                    first = false;
                    continue;
                }
                availableDatasourceNames = Sets.intersection(availableDatasourceNames, currentDataSourceNames);
            }
            if (availableDatasourceNames.isEmpty()) {
                throw new ShardingSphereConfigurationException("Cannot find actual datasource intersection for logic tables: %s", new Object[]{this.logicTables});
            }
            dataSourceName = shardingRule.getShardingDataSourceNames().getRandomDataSourceName((Collection)availableDatasourceNames);
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), tableMappers));
        }
        return result;
    }

    @Generated
    public ShardingUnicastRoutingEngine(Collection<String> logicTables) {
        this.logicTables = logicTables;
    }
}

