/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.impl;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class ShardingInsertStatementValidator
implements ShardingStatementValidator<InsertStatement> {
    @Override
    public void validate(ShardingRule shardingRule, InsertStatement sqlStatement, List<Object> parameters) {
        Optional onDuplicateKeyColumnsSegment = sqlStatement.getOnDuplicateKeyColumns();
        if (onDuplicateKeyColumnsSegment.isPresent() && this.isUpdateShardingKey(shardingRule, (OnDuplicateKeyColumnsSegment)onDuplicateKeyColumnsSegment.get(), sqlStatement.getTable().getTableName().getIdentifier().getValue())) {
            throw new ShardingSphereException("INSERT INTO .... ON DUPLICATE KEY UPDATE can not support update for sharding column.", new Object[0]);
        }
    }

    private boolean isUpdateShardingKey(ShardingRule shardingRule, OnDuplicateKeyColumnsSegment onDuplicateKeyColumnsSegment, String tableName) {
        for (AssignmentSegment each : onDuplicateKeyColumnsSegment.getColumns()) {
            if (!shardingRule.isShardingColumn(each.getColumn().getIdentifier().getValue(), tableName)) continue;
            return true;
        }
        return false;
    }
}

