/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.UpdateStatement;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class ShardingUpdateStatementValidator
implements ShardingStatementValidator<UpdateStatement> {
    @Override
    public void validate(ShardingRule shardingRule, UpdateStatement sqlStatement, List<Object> parameters) {
        String tableName = ((SimpleTableSegment)sqlStatement.getTables().iterator().next()).getTableName().getIdentifier().getValue();
        for (AssignmentSegment each : sqlStatement.getSetAssignment().getAssignments()) {
            String shardingColumn = each.getColumn().getIdentifier().getValue();
            if (!shardingRule.isShardingColumn(shardingColumn, tableName)) continue;
            Optional<Object> shardingColumnSetAssignmentValue = this.getShardingColumnSetAssignmentValue(each, parameters);
            Optional<Object> shardingValue = Optional.empty();
            Optional whereSegmentOptional = sqlStatement.getWhere();
            if (whereSegmentOptional.isPresent()) {
                shardingValue = this.getShardingValue((WhereSegment)whereSegmentOptional.get(), parameters, shardingColumn);
            }
            if (shardingColumnSetAssignmentValue.isPresent() && shardingValue.isPresent() && shardingColumnSetAssignmentValue.get().equals(shardingValue.get())) continue;
            throw new ShardingSphereException("Can not update sharding key, logic table: [%s], column: [%s].", new Object[]{tableName, each});
        }
    }

    private Optional<Object> getShardingColumnSetAssignmentValue(AssignmentSegment assignmentSegment, List<Object> parameters) {
        ExpressionSegment segment = assignmentSegment.getValue();
        int shardingSetAssignIndex = -1;
        if (segment instanceof ParameterMarkerExpressionSegment) {
            shardingSetAssignIndex = ((ParameterMarkerExpressionSegment)segment).getParameterMarkerIndex();
        }
        if (segment instanceof LiteralExpressionSegment) {
            return Optional.of(((LiteralExpressionSegment)segment).getLiterals());
        }
        if (-1 == shardingSetAssignIndex || shardingSetAssignIndex > parameters.size() - 1) {
            return Optional.empty();
        }
        return Optional.of(parameters.get(shardingSetAssignIndex));
    }

    private Optional<Object> getShardingValue(WhereSegment whereSegment, List<Object> parameters, String shardingColumn) {
        Iterator iterator = whereSegment.getAndPredicates().iterator();
        if (iterator.hasNext()) {
            AndPredicate each = (AndPredicate)iterator.next();
            return this.getShardingValue(each, parameters, shardingColumn);
        }
        return Optional.empty();
    }

    private Optional<Object> getShardingValue(AndPredicate andPredicate, List<Object> parameters, String shardingColumn) {
        for (PredicateSegment each : andPredicate.getPredicates()) {
            if (!shardingColumn.equalsIgnoreCase(each.getColumn().getIdentifier().getValue())) continue;
            PredicateRightValue rightValue = each.getRightValue();
            if (rightValue instanceof PredicateCompareRightValue) {
                ExpressionSegment segment = ((PredicateCompareRightValue)rightValue).getExpression();
                return this.getPredicateCompareShardingValue(segment, parameters);
            }
            if (!(rightValue instanceof PredicateInRightValue)) continue;
            Collection segments = ((PredicateInRightValue)rightValue).getSqlExpressions();
            return this.getPredicateInShardingValue(segments, parameters);
        }
        return Optional.empty();
    }

    private Optional<Object> getPredicateCompareShardingValue(ExpressionSegment segment, List<Object> parameters) {
        if (segment instanceof ParameterMarkerExpressionSegment) {
            int shardingValueParameterMarkerIndex = ((ParameterMarkerExpressionSegment)segment).getParameterMarkerIndex();
            if (-1 == shardingValueParameterMarkerIndex || shardingValueParameterMarkerIndex > parameters.size() - 1) {
                return Optional.empty();
            }
            return Optional.of(parameters.get(shardingValueParameterMarkerIndex));
        }
        if (segment instanceof LiteralExpressionSegment) {
            return Optional.of(((LiteralExpressionSegment)segment).getLiterals());
        }
        return Optional.empty();
    }

    private Optional<Object> getPredicateInShardingValue(Collection<ExpressionSegment> segments, List<Object> parameters) {
        for (ExpressionSegment each : segments) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                int shardingColumnWhereIndex = ((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex();
                if (-1 == shardingColumnWhereIndex || shardingColumnWhereIndex > parameters.size() - 1) continue;
                return Optional.of(parameters.get(shardingColumnWhereIndex));
            }
            if (!(each instanceof LiteralExpressionSegment)) continue;
            return Optional.of(((LiteralExpressionSegment)each).getLiterals());
        }
        return Optional.empty();
    }
}

