/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;

public final class RowNumberPaginationContextEngine {
    private static final Collection<String> ROW_NUMBER_IDENTIFIERS = new HashSet<String>();

    public PaginationContext createPaginationContext(Collection<AndPredicate> andPredicates, ProjectionsContext projectionsContext, List<Object> parameters) {
        Optional<String> rowNumberAlias = this.isRowNumberAlias(projectionsContext);
        if (!rowNumberAlias.isPresent()) {
            return new PaginationContext(null, null, parameters);
        }
        Collection<PredicateSegment> rowNumberPredicates = this.getRowNumberPredicates(andPredicates, rowNumberAlias.get());
        return rowNumberPredicates.isEmpty() ? new PaginationContext(null, null, parameters) : this.createPaginationWithRowNumber(rowNumberPredicates, parameters);
    }

    private Collection<PredicateSegment> getRowNumberPredicates(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        LinkedList<PredicateSegment> result = new LinkedList<PredicateSegment>();
        for (AndPredicate each : andPredicates) {
            for (PredicateSegment predicate : each.getPredicates()) {
                if (!this.isRowNumberColumn(predicate, rowNumberAlias) || !this.isCompareCondition(predicate)) continue;
                result.add(predicate);
            }
        }
        return result;
    }

    private Optional<String> isRowNumberAlias(ProjectionsContext projectionsContext) {
        for (String each : ROW_NUMBER_IDENTIFIERS) {
            Optional<String> result = projectionsContext.findAlias(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private boolean isRowNumberColumn(PredicateSegment predicate, String rowNumberAlias) {
        return ROW_NUMBER_IDENTIFIERS.contains(predicate.getColumn().getIdentifier().getValue()) || predicate.getColumn().getIdentifier().getValue().equalsIgnoreCase(rowNumberAlias);
    }

    private boolean isCompareCondition(PredicateSegment predicate) {
        if (predicate.getRightValue() instanceof PredicateCompareRightValue) {
            String operator = ((PredicateCompareRightValue)predicate.getRightValue()).getOperator();
            return "<".equals(operator) || "<=".equals(operator) || ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private PaginationContext createPaginationWithRowNumber(Collection<PredicateSegment> rowNumberPredicates, List<Object> parameters) {
        RowNumberValueSegment offset = null;
        RowNumberValueSegment rowCount = null;
        for (PredicateSegment each : rowNumberPredicates) {
            ExpressionSegment expression = ((PredicateCompareRightValue)each.getRightValue()).getExpression();
            switch (((PredicateCompareRightValue)each.getRightValue()).getOperator()) {
                case ">": {
                    offset = this.createRowNumberValueSegment(expression, false);
                    break;
                }
                case ">=": {
                    offset = this.createRowNumberValueSegment(expression, true);
                    break;
                }
                case "<": {
                    rowCount = this.createRowNumberValueSegment(expression, false);
                    break;
                }
                case "<=": {
                    rowCount = this.createRowNumberValueSegment(expression, true);
                    break;
                }
            }
        }
        return new PaginationContext((PaginationValueSegment)offset, (PaginationValueSegment)rowCount, parameters);
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        return expression instanceof LiteralExpressionSegment ? new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, (long)((Integer)((LiteralExpressionSegment)expression).getLiterals()).intValue(), boundOpened) : new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
    }

    static {
        ROW_NUMBER_IDENTIFIERS.add("rownum");
        ROW_NUMBER_IDENTIFIERS.add("ROW_NUMBER");
    }
}

