/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import org.apache.commons.lang.ClassUtils;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.JSR250LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.lifecycle.ScopeLifecycleManager;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.utils.FileLoader;
import org.apache.wink.server.handlers.Handler;
import org.apache.wink.server.handlers.HandlersFactory;
import org.apache.wink.server.handlers.MediaTypeMapperFactory;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.handlers.RequestHandlersChain;
import org.apache.wink.server.handlers.ResponseHandler;
import org.apache.wink.server.handlers.ResponseHandlersChain;
import org.apache.wink.server.internal.MediaTypeMapper;
import org.apache.wink.server.internal.application.ApplicationProcessor;
import org.apache.wink.server.internal.handlers.CheckLocationHeaderHandler;
import org.apache.wink.server.internal.handlers.CreateInvocationParametersHandler;
import org.apache.wink.server.internal.handlers.FindResourceMethodHandler;
import org.apache.wink.server.internal.handlers.FindRootResourceHandler;
import org.apache.wink.server.internal.handlers.FlushResultHandler;
import org.apache.wink.server.internal.handlers.HeadMethodHandler;
import org.apache.wink.server.internal.handlers.InvokeMethodHandler;
import org.apache.wink.server.internal.handlers.OptionsMethodHandler;
import org.apache.wink.server.internal.handlers.PopulateErrorResponseHandler;
import org.apache.wink.server.internal.handlers.PopulateResponseMediaTypeHandler;
import org.apache.wink.server.internal.handlers.PopulateResponseStatusHandler;
import org.apache.wink.server.internal.handlers.SearchResultHandler;
import org.apache.wink.server.internal.log.Requests;
import org.apache.wink.server.internal.log.ResourceInvocation;
import org.apache.wink.server.internal.log.Responses;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.registry.ServerInjectableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentConfiguration
implements WinkConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfiguration.class);
    private static final String ALTERNATIVE_SHORTCUTS = "META-INF/wink-alternate-shortcuts.properties";
    private static final String HTTP_METHOD_OVERRIDE_HEADERS_PROP = "wink.httpMethodOverrideHeaders";
    private static final String HANDLERS_FACTORY_CLASS_PROP = "wink.handlersFactoryClass";
    private static final String MEDIATYPE_MAPPER_FACTORY_CLASS_PROP = "wink.mediaTypeMapperFactoryClass";
    private static final String VALIDATE_LOCATION_HEADER = "wink.validateLocationHeader";
    private static final String DEFAULT_RESPONSE_CHARSET = "wink.response.defaultCharset";
    private static final String USE_ACCEPT_CHARSET = "wink.response.useAcceptCharset";
    private boolean isChainInitialized = false;
    private RequestHandlersChain requestHandlersChain;
    private ResponseHandlersChain responseHandlersChain;
    private ResponseHandlersChain errorHandlersChain;
    private List<RequestHandler> requestUserHandlers;
    private List<ResponseHandler> responseUserHandlers;
    private List<ResponseHandler> errorUserHandlers;
    private ProvidersRegistry providersRegistry;
    private ResourceRegistry resourceRegistry;
    private LifecycleManagersRegistry ofFactoryRegistry;
    private MediaTypeMapper mediaTypeMapper;
    private Map<String, String> alternateShortcutMap;
    private Properties properties;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private FilterConfig filterConfig;
    private List<Application> applications;
    private String[] httpMethodOverrideHeaders;
    private Set<ObjectFactory<?>> appObjectFactories;
    private boolean isUseAcceptCharset = false;
    private boolean isDefaultResponseCharset = false;

    public void init() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.appObjectFactories = new HashSet(8);
        logger.trace("Deployment configuration properties: {}", (Object)this.properties);
        String httpMethodOverrideHeadersProperty = this.properties.getProperty(HTTP_METHOD_OVERRIDE_HEADERS_PROP);
        this.httpMethodOverrideHeaders = httpMethodOverrideHeadersProperty != null && httpMethodOverrideHeadersProperty.length() > 0 ? httpMethodOverrideHeadersProperty.split(",") : null;
        this.initRegistries();
        this.initAlternateShortcutMap();
        this.initMediaTypeMapper();
        this.initHandlers();
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Configuration Settings:");
                logger.trace("Request Handlers Chain : {}", (Object)this.requestHandlersChain);
                logger.trace("Response Handlers Chain: {}", (Object)this.responseHandlersChain);
                logger.trace("Error Handlers Chain: {}", (Object)this.errorHandlersChain);
                logger.debug("Request User Handlers: {}", (Object)String.format("%1$s", this.requestUserHandlers));
                logger.debug("Response User Handlers: {}", (Object)String.format("%1$s", this.responseUserHandlers));
                logger.debug("Error User Handlers: {}", (Object)String.format("%1$s", this.errorUserHandlers));
                logger.trace("LifecycleManagerRegistry: {}", (Object)this.ofFactoryRegistry.getLifecycleManagers());
                logger.debug("MediaTypeMapper: {}", (Object)this.mediaTypeMapper);
                logger.debug("AlternateShortcutMap: {}", this.alternateShortcutMap);
                logger.debug("Properties: {}", (Object)this.properties);
                logger.trace("ServletConfig: {}", (Object)this.servletConfig);
                logger.trace("ServletContext: {}", (Object)this.servletContext);
                logger.trace("FilterConfig: {}", (Object)this.filterConfig);
                logger.trace("Applications: {}", this.applications);
                ArrayList<String> httpMethodOverrideHeadersList = new ArrayList<String>();
                if (this.httpMethodOverrideHeaders != null) {
                    for (int i = 0; i < this.httpMethodOverrideHeaders.length; ++i) {
                        httpMethodOverrideHeadersList.add(this.httpMethodOverrideHeaders[i]);
                    }
                }
                logger.debug("HttpMethodOverrideHeaders: {}", httpMethodOverrideHeadersList);
            }
            catch (Exception e) {
                logger.debug("An Exception occurred when logging the configuration {}", (Throwable)e);
            }
        }
    }

    public RequestHandlersChain getRequestHandlersChain() {
        if (!this.isChainInitialized) {
            this.initHandlersChain();
        }
        return this.requestHandlersChain;
    }

    public void setRequestHandlersChain(RequestHandlersChain requestHandlersChain) {
        this.requestHandlersChain = requestHandlersChain;
    }

    public ResponseHandlersChain getResponseHandlersChain() {
        if (!this.isChainInitialized) {
            this.initHandlersChain();
        }
        return this.responseHandlersChain;
    }

    public void setResponseHandlersChain(ResponseHandlersChain responseHandlersChain) {
        this.responseHandlersChain = responseHandlersChain;
    }

    public ResponseHandlersChain getErrorHandlersChain() {
        if (!this.isChainInitialized) {
            this.initHandlersChain();
        }
        return this.errorHandlersChain;
    }

    public void setErrorHandlersChain(ResponseHandlersChain errorHandlersChain) {
        this.errorHandlersChain = errorHandlersChain;
    }

    public ProvidersRegistry getProvidersRegistry() {
        return this.providersRegistry;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return this.mediaTypeMapper;
    }

    public void setMediaTypeMapper(MediaTypeMapper mediaTypeMapper) {
        this.mediaTypeMapper = mediaTypeMapper;
    }

    public void setOfFactoryRegistry(LifecycleManagersRegistry ofFactoryRegistry) {
        this.ofFactoryRegistry = ofFactoryRegistry;
    }

    public LifecycleManagersRegistry getOfFactoryRegistry() {
        return this.ofFactoryRegistry;
    }

    public Map<String, String> getAlternateShortcutMap() {
        return this.alternateShortcutMap;
    }

    public void setAlternateShortcutMap(Map<String, String> alternateShortcutMap) {
        this.alternateShortcutMap = alternateShortcutMap;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        String val = properties.getProperty(USE_ACCEPT_CHARSET);
        this.isUseAcceptCharset = Boolean.valueOf(val);
        val = properties.getProperty(DEFAULT_RESPONSE_CHARSET);
        this.isDefaultResponseCharset = Boolean.valueOf(val);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setRequestUserHandlers(List<RequestHandler> requestUserHandlers) {
        this.requestUserHandlers = requestUserHandlers;
    }

    public void setResponseUserHandlers(List<ResponseHandler> responseUserHandlers) {
        this.responseUserHandlers = responseUserHandlers;
    }

    public List<ResponseHandler> getResponseUserHandlers() {
        return this.responseUserHandlers;
    }

    public List<RequestHandler> getRequestUserHandlers() {
        return this.requestUserHandlers;
    }

    public void setErrorUserHandlers(List<ResponseHandler> errorUserHandlers) {
        this.errorUserHandlers = errorUserHandlers;
    }

    public List<ResponseHandler> getErrorUserHandlers() {
        return this.errorUserHandlers;
    }

    public void addApplication(Application application, boolean isSystemApplication) {
        if (this.applications == null) {
            this.applications = new ArrayList<Application>(1);
        }
        new ApplicationProcessor(application, this.resourceRegistry, this.providersRegistry, isSystemApplication).process();
        this.applications.add(application);
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    protected void initRegistries() {
        InjectableFactory.setInstance((InjectableFactory)new ServerInjectableFactory());
        if (this.ofFactoryRegistry == null) {
            this.ofFactoryRegistry = new LifecycleManagersRegistry();
            this.ofFactoryRegistry.addFactoryFactory((LifecycleManager)new ScopeLifecycleManager());
            this.ofFactoryRegistry.addFactoryFactory((LifecycleManager)new JSR250LifecycleManager());
        }
        ApplicationValidator applicationValidator = new ApplicationValidator();
        this.providersRegistry = new ProvidersRegistry(this.ofFactoryRegistry, applicationValidator);
        this.resourceRegistry = new ResourceRegistry(this.ofFactoryRegistry, applicationValidator, this.properties);
    }

    protected void initAlternateShortcutMap() {
        if (this.alternateShortcutMap == null) {
            InputStream is = null;
            try {
                is = FileLoader.loadFileAsStream((String)ALTERNATIVE_SHORTCUTS);
                Properties lproperties = new Properties();
                lproperties.load(is);
                logger.trace("Alternative shortcuts properties: {}", (Object)lproperties);
                this.alternateShortcutMap = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : lproperties.entrySet()) {
                    this.alternateShortcutMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                logger.trace("Alternative shortcuts map: {}", this.alternateShortcutMap);
            }
            catch (IOException e) {
                logger.error(Messages.getMessage((String)"alternateShortcutMapLoadFailure"), (Throwable)e);
                throw new WebApplicationException((Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.info(Messages.getMessage((String)"alternateShortcutMapCloseFailure") + ALTERNATIVE_SHORTCUTS, (Throwable)e);
                }
            }
        }
    }

    protected void initMediaTypeMapper() {
        block7: {
            String mediaTypeMapperFactoryClassName;
            if (this.mediaTypeMapper == null && (mediaTypeMapperFactoryClassName = this.properties.getProperty(MEDIATYPE_MAPPER_FACTORY_CLASS_PROP)) != null) {
                this.mediaTypeMapper = new MediaTypeMapper();
                try {
                    logger.trace("MediaTypeMappingFactory Class is: {}", (Object)mediaTypeMapperFactoryClassName);
                    Class<?> handlerFactoryClass = Class.forName(mediaTypeMapperFactoryClassName);
                    MediaTypeMapperFactory handlersFactory = (MediaTypeMapperFactory)handlerFactoryClass.newInstance();
                    this.mediaTypeMapper.addMappings(handlersFactory.getMediaTypeMappings());
                }
                catch (ClassNotFoundException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error(Messages.getMessage((String)"isNotAClassWithMsgFormat", (Object[])new Object[]{mediaTypeMapperFactoryClassName}), (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error(Messages.getMessage((String)"classInstantiationExceptionWithMsgFormat", (Object[])new Object[]{mediaTypeMapperFactoryClassName}), (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (!logger.isErrorEnabled()) break block7;
                    logger.error(Messages.getMessage((String)"classIllegalAccessWithMsgFormat", (Object[])new Object[]{mediaTypeMapperFactoryClassName}), (Throwable)e);
                }
            }
        }
    }

    private void initHandlers() {
        String handlersFactoryClassName = this.properties.getProperty(HANDLERS_FACTORY_CLASS_PROP);
        if (handlersFactoryClassName != null) {
            try {
                logger.trace("Handlers Factory Class is: {}", (Object)handlersFactoryClassName);
                Class handlerFactoryClass = ClassUtils.getClass((String)handlersFactoryClassName);
                HandlersFactory handlersFactory = (HandlersFactory)handlerFactoryClass.newInstance();
                if (this.requestUserHandlers == null) {
                    this.requestUserHandlers = handlersFactory.getRequestHandlers();
                }
                if (this.responseUserHandlers == null) {
                    this.responseUserHandlers = handlersFactory.getResponseHandlers();
                }
                if (this.errorUserHandlers == null) {
                    this.errorUserHandlers = handlersFactory.getErrorHandlers();
                }
            }
            catch (ClassNotFoundException e) {
                logger.error(Messages.getMessage((String)"isNotAClassWithMsgFormat", (Object[])new Object[]{handlersFactoryClassName}), (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error(Messages.getMessage((String)"classInstantiationExceptionWithMsgFormat", (Object[])new Object[]{handlersFactoryClassName}), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(Messages.getMessage((String)"classIllegalAccessWithMsgFormat", (Object[])new Object[]{handlersFactoryClassName}), (Throwable)e);
            }
        }
        if (this.requestUserHandlers == null) {
            this.requestUserHandlers = this.initRequestUserHandlers();
        }
        if (this.responseUserHandlers == null) {
            this.responseUserHandlers = this.initResponseUserHandlers();
        }
        if (this.errorUserHandlers == null) {
            this.errorUserHandlers = this.initErrorUserHandlers();
        }
    }

    private void initHandlersChain() {
        if (this.requestHandlersChain == null) {
            this.requestHandlersChain = this.initRequestHandlersChain();
        }
        if (this.responseHandlersChain == null) {
            this.responseHandlersChain = this.initResponseHandlersChain();
        }
        if (this.errorHandlersChain == null) {
            this.errorHandlersChain = this.initErrorHandlersChain();
        }
        this.isChainInitialized = true;
    }

    protected RequestHandlersChain initRequestHandlersChain() {
        RequestHandlersChain handlersChain = new RequestHandlersChain();
        handlersChain.addHandler(this.createHandler(Requests.class));
        handlersChain.addHandler(this.createHandler(ResourceInvocation.class));
        handlersChain.addHandler(this.createHandler(SearchResultHandler.class));
        String optionsHandler = this.properties.getProperty("org.apache.wink.server.options.handler", OptionsMethodHandler.class.getName());
        if ("none".equals(optionsHandler)) {
            optionsHandler = OptionsMethodHandler.class.getName();
        }
        logger.trace("org.apache.wink.server.options.handler value is {}", (Object)optionsHandler);
        try {
            handlersChain.addHandler(this.createHandler(Class.forName(optionsHandler)));
        }
        catch (Exception e) {
            logger.trace("Could not load handlers class so adding default");
            handlersChain.addHandler(this.createHandler(OptionsMethodHandler.class));
        }
        handlersChain.addHandler(this.createHandler(HeadMethodHandler.class));
        handlersChain.addHandler(this.createHandler(FindRootResourceHandler.class));
        handlersChain.addHandler(this.createHandler(FindResourceMethodHandler.class));
        handlersChain.addHandler(this.createHandler(CreateInvocationParametersHandler.class));
        if (this.requestUserHandlers != null) {
            for (RequestHandler h : this.requestUserHandlers) {
                h.init(this.properties);
                handlersChain.addHandler(h);
            }
        }
        handlersChain.addHandler(this.createHandler(InvokeMethodHandler.class));
        logger.trace("Request handlers chain is: {}", (Object)handlersChain);
        return handlersChain;
    }

    protected List<RequestHandler> initRequestUserHandlers() {
        return Collections.emptyList();
    }

    protected List<ResponseHandler> initResponseUserHandlers() {
        ArrayList<ResponseHandler> list = new ArrayList<ResponseHandler>(1);
        if (Boolean.parseBoolean(this.properties.getProperty(VALIDATE_LOCATION_HEADER))) {
            list.add(new CheckLocationHeaderHandler());
        }
        return list;
    }

    protected List<ResponseHandler> initErrorUserHandlers() {
        return Collections.emptyList();
    }

    protected ResponseHandlersChain initResponseHandlersChain() {
        ResponseHandlersChain handlersChain = new ResponseHandlersChain();
        handlersChain.addHandler(this.createHandler(Responses.class));
        handlersChain.addHandler(this.createHandler(PopulateResponseStatusHandler.class));
        handlersChain.addHandler(this.createHandler(PopulateResponseMediaTypeHandler.class));
        if (this.responseUserHandlers != null) {
            for (ResponseHandler h : this.responseUserHandlers) {
                h.init(this.properties);
                handlersChain.addHandler(h);
            }
        }
        handlersChain.addHandler(this.createHandler(FlushResultHandler.class));
        handlersChain.addHandler(this.createHandler(HeadMethodHandler.class));
        logger.trace("Response handlers chain is: {}", (Object)handlersChain);
        return handlersChain;
    }

    protected ResponseHandlersChain initErrorHandlersChain() {
        ResponseHandlersChain handlersChain = new ResponseHandlersChain();
        Responses responsesHandler = this.createHandler(Responses.class);
        responsesHandler.setIsErrorFlow(true);
        handlersChain.addHandler(responsesHandler);
        handlersChain.addHandler(this.createHandler(PopulateErrorResponseHandler.class));
        handlersChain.addHandler(this.createHandler(PopulateResponseStatusHandler.class));
        PopulateResponseMediaTypeHandler populateMediaTypeHandler = this.createHandler(PopulateResponseMediaTypeHandler.class);
        populateMediaTypeHandler.setErrorFlow(true);
        handlersChain.addHandler(populateMediaTypeHandler);
        if (this.errorUserHandlers != null) {
            for (ResponseHandler h : this.errorUserHandlers) {
                h.init(this.properties);
                handlersChain.addHandler(h);
            }
        }
        handlersChain.addHandler(this.createHandler(FlushResultHandler.class));
        logger.trace("Error handlers chain is: {}", (Object)handlersChain);
        return handlersChain;
    }

    protected <T extends Handler> T createHandler(Class<T> cls) {
        try {
            Handler handler = (Handler)cls.newInstance();
            logger.trace("Calling {}.init(Properties)", cls);
            handler.init(this.getProperties());
            return (T)handler;
        }
        catch (InstantiationException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void setHttpMethodOverrideHeaders(String[] httpMethodOverrideHeaders) {
        this.httpMethodOverrideHeaders = httpMethodOverrideHeaders;
        if (logger.isTraceEnabled()) {
            List<String> overrideHeaders = httpMethodOverrideHeaders == null ? null : Arrays.asList(httpMethodOverrideHeaders);
            logger.trace("Setting HTTP Method override headers: {}", overrideHeaders);
        }
    }

    public String[] getHttpMethodOverrideHeaders() {
        return this.httpMethodOverrideHeaders;
    }

    public boolean isDefaultResponseCharset() {
        return this.isDefaultResponseCharset;
    }

    public void setDefaultResponseCharset(boolean val) {
        this.properties.setProperty(DEFAULT_RESPONSE_CHARSET, Boolean.toString(val));
        this.isDefaultResponseCharset = val;
    }

    public boolean isUseAcceptCharset() {
        return this.isUseAcceptCharset;
    }

    public void setUseAcceptCharset(boolean val) {
        this.properties.setProperty(USE_ACCEPT_CHARSET, Boolean.toString(val));
        this.isUseAcceptCharset = val;
    }

    public void addApplicationObjectFactory(ObjectFactory<?> of) {
        this.appObjectFactories.add(of);
    }

    public Set<ObjectFactory<?>> getApplicationObjectFactories() {
        return this.appObjectFactories;
    }
}

