/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.wink.common.internal.uri.UriEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereParametersFilter
implements Filter {
    public static final String CONTENT_TYPE_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String contentType;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HashMap<String, List<String>> paramMapWithList = new HashMap<String, List<String>>();
            String query = httpRequest.getQueryString();
            if (query != null && query.length() != 0) {
                WebSphereParametersFilter.parseQuery(paramMapWithList, query);
            }
            if ((contentType = httpRequest.getContentType()) != null && contentType.startsWith(CONTENT_TYPE_WWW_FORM_URLENCODED)) {
                int len;
                InputStreamReader isr = new InputStreamReader((InputStream)httpRequest.getInputStream());
                StringWriter sw = new StringWriter();
                char[] buffer = new char[4096];
                while ((len = isr.read(buffer)) > 0) {
                    sw.write(buffer, 0, len);
                }
                WebSphereParametersFilter.parseQuery(paramMapWithList, sw.toString());
            }
            if (!paramMapWithList.isEmpty()) {
                HashMap<String, String[]> paramMap = new HashMap<String, String[]>(paramMapWithList.size());
                for (Map.Entry e : paramMapWithList.entrySet()) {
                    paramMap.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
                }
                request = new ParametersFilterRequestWrapper(httpRequest, paramMap);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static void parseQuery(Map<String, List<String>> paramMap, String query) {
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String value;
            String name;
            String token = tokenizer.nextToken();
            int equal = token.indexOf(61);
            if (equal != -1) {
                name = UriEncoder.decodeString((String)token.substring(0, equal));
                value = UriEncoder.decodeString((String)token.substring(equal + 1));
            } else {
                name = UriEncoder.decodeString((String)token);
                value = "";
            }
            List<String> values = paramMap.get(name);
            if (values == null) {
                values = new ArrayList<String>(1);
            }
            values.add(value);
            paramMap.put(name, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParametersFilterRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> paramMap;

        ParametersFilterRequestWrapper(HttpServletRequest request, Map<String, String[]> paramMap) {
            super(request);
            this.paramMap = paramMap;
        }

        public String[] getParameterValues(String name) {
            return this.paramMap.get(name);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.paramMap.keySet());
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.paramMap);
        }

        public String getParameter(String name) {
            String[] v = this.getParameterValues(name);
            return v == null ? null : v[0];
        }
    }
}

