/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;
import org.apache.xbean.spring.generator.Utils;

public class DocumentationGenerator
implements GeneratorPlugin {
    private final File destFile;
    private LogFacade log;

    public DocumentationGenerator(File destFile) {
        this.destFile = destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        String namespace = namespaceMapping.getNamespace();
        File file = new File(this.destFile.getParentFile(), this.destFile.getName() + ".html");
        this.log.log("Generating HTML documentation file: " + file + " for namespace: " + namespace);
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            this.generateDocumentation(out, namespaceMapping);
        }
        finally {
            out.close();
        }
    }

    private void generateDocumentation(PrintWriter out, NamespaceMapping namespaceMapping) {
        String namespace = namespaceMapping.getNamespace();
        out.println("<!-- NOTE: this file is autogenerated by XBeans -->");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Schema for namespace: " + namespace + "</title>");
        out.println("<link rel='stylesheet' href='style.css' type='text/css'>");
        out.println("<link rel='stylesheet' href='http://activemq.org/style.css' type='text/css'>");
        out.println("<link rel='stylesheet' href='http://activemq.org/style-xb.css' type='text/css'>");
        out.println("</head>");
        out.println();
        out.println("<body>");
        out.println();
        this.generateRootElement(out, namespaceMapping);
        this.generateElementsSummary(out, namespaceMapping);
        out.println();
        out.println();
        this.generateElementsDetail(out, namespaceMapping);
        out.println();
        out.println("</body>");
        out.println("</html>");
    }

    private void generateRootElement(PrintWriter out, NamespaceMapping namespaceMapping) {
        ElementMapping rootElement = namespaceMapping.getRootElement();
        if (rootElement != null) {
            out.println("<h1>Root Element</h1>");
            out.println("<table>");
            out.println("  <tr><th>Element</th><th>Description</th><th>Class</th>");
            this.generateElementSummary(out, rootElement);
            out.println("</table>");
            out.println();
        }
    }

    private void generateElementsSummary(PrintWriter out, NamespaceMapping namespaceMapping) {
        out.println("<h1>Element Summary</h1>");
        out.println("<table>");
        out.println("  <tr><th>Element</th><th>Description</th><th>Class</th>");
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            this.generateElementSummary(out, element);
        }
        out.println("</table>");
    }

    private void generateElementSummary(PrintWriter out, ElementMapping element) {
        out.println("  <tr><td><a href='#" + element.getElementName() + "'>" + element.getElementName() + "</a></td>" + "<td>" + element.getDescription() + "</td>" + "<td>" + element.getClassName() + "</td></tr>");
    }

    private void generateElementsDetail(PrintWriter out, NamespaceMapping namespaceMapping) {
        out.println("<h1>Element Detail</h1>");
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            this.generateHtmlElementDetail(out, namespaceMapping, element);
        }
    }

    private void generateHtmlElementDetail(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element) {
        Type type;
        AttributeMapping attributeMapping;
        out.println("<h2>Element: <a name='" + element.getElementName() + "'>" + element.getElementName() + "</a></h2>");
        boolean hasAttributes = false;
        boolean hasElements = false;
        Iterator iterator = element.getAttributes().iterator();
        while (!(!iterator.hasNext() || hasAttributes && hasElements)) {
            attributeMapping = (AttributeMapping)iterator.next();
            type = attributeMapping.getType();
            if (Utils.isSimpleType(type)) {
                hasAttributes = true;
                continue;
            }
            hasElements = true;
        }
        if (hasAttributes) {
            out.println("<table>");
            out.println("  <tr><th>Attribute</th><th>Type</th><th>Description</th>");
            iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                attributeMapping = (AttributeMapping)iterator.next();
                type = attributeMapping.getType();
                if (!Utils.isSimpleType(type)) continue;
                out.println("  <tr><td>" + attributeMapping.getAttributeName() + "</td><td>" + Utils.getXsdType(type) + "</td><td>" + attributeMapping.getDescription() + "</td></tr>");
            }
            out.println("</table>");
        }
        if (hasElements) {
            out.println("<table>");
            out.println("  <tr><th>Element</th><th>Type</th><th>Description</th>");
            iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                attributeMapping = (AttributeMapping)iterator.next();
                type = attributeMapping.getType();
                if (Utils.isSimpleType(type)) continue;
                out.print("  <tr><td>" + attributeMapping.getAttributeName() + "</td><td>");
                this.printComplexPropertyTypeDocumentation(out, namespaceMapping, type);
                out.println("</td><td>" + attributeMapping.getDescription() + "</td></tr>");
            }
            out.println("</table>");
        }
    }

    private void printComplexPropertyTypeDocumentation(PrintWriter out, NamespaceMapping namespaceMapping, Type type) {
        if (type.isCollection()) {
            out.print("(");
        }
        List types = type.isCollection() ? Utils.findImplementationsOf(namespaceMapping, type.getNestedType()) : Utils.findImplementationsOf(namespaceMapping, type);
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            ElementMapping element = (ElementMapping)iterator.next();
            out.print("<a href='#" + element.getElementName() + "'>" + element.getElementName() + "</a>");
            if (!iterator.hasNext()) continue;
            out.print(" | ");
        }
        if (types.size() == 0) {
            out.print("&lt;spring:bean/&gt;");
        }
        if (type.isCollection()) {
            out.print(")*");
        }
    }

    public LogFacade getLog() {
        return this.log;
    }

    public void setLog(LogFacade log) {
        this.log = log;
    }
}

