/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility;

import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration> {
    public static final Duration FOREVER = new Duration();
    public static final Duration ZERO = new Duration(0L, TimeUnit.MILLISECONDS);
    public static final Duration ONE_MILLISECOND = new Duration(1L, TimeUnit.MILLISECONDS);
    public static final Duration ONE_HUNDRED_MILLISECONDS = new Duration(100L, TimeUnit.MILLISECONDS);
    public static final Duration TWO_HUNDRED_MILLISECONDS = new Duration(200L, TimeUnit.MILLISECONDS);
    public static final Duration FIVE_HUNDRED_MILLISECONDS = new Duration(500L, TimeUnit.MILLISECONDS);
    public static final Duration ONE_SECOND = new Duration(1L, TimeUnit.SECONDS);
    public static final Duration TWO_SECONDS = new Duration(2L, TimeUnit.SECONDS);
    public static final Duration FIVE_SECONDS = new Duration(5L, TimeUnit.SECONDS);
    public static final Duration TEN_SECONDS = new Duration(10L, TimeUnit.SECONDS);
    public static final Duration ONE_MINUTE = new Duration(60L, TimeUnit.SECONDS);
    public static final Duration TWO_MINUTES = new Duration(120L, TimeUnit.SECONDS);
    public static final Duration FIVE_MINUTES = new Duration(300L, TimeUnit.SECONDS);
    public static final Duration TEN_MINUTES = new Duration(600L, TimeUnit.SECONDS);
    @Deprecated
    public static final Duration SAME_AS_POLL_INTERVAL = new Duration();
    private static final int NONE = -1;
    private final long value;
    private final TimeUnit unit;

    private Duration() {
        this.value = -1L;
        this.unit = null;
    }

    public Duration(long value, TimeUnit unit) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0, was " + value);
        }
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.value = value;
        this.unit = unit;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }

    public String getTimeUnitAsString() {
        return this.unit == null ? "<not defined>" : this.unit.toString().toLowerCase();
    }

    public boolean isForever() {
        return this.unit == null && this.value == -1L;
    }

    public boolean isZero() {
        return this.equals(ZERO);
    }

    public long getValue() {
        return this.value;
    }

    public long getValueInMS() {
        if (this.value == -1L) {
            return this.value;
        }
        return TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public Duration plus(long amount) {
        return new Plus().apply(this, this.unit == null ? FOREVER : new Duration(amount, this.unit));
    }

    public Duration plus(long amount, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        return new Plus().apply(this, new Duration(amount, timeUnit));
    }

    public Duration plus(Duration duration) {
        return new Plus().apply(this, duration);
    }

    public Duration multiply(long amount) {
        return new Multiply().apply(this, this.unit == null ? FOREVER : new Duration(amount, this.unit));
    }

    public Duration divide(long amount) {
        return new Divide().apply(this, this.unit == null ? FOREVER : new Duration(amount, this.unit));
    }

    public Duration minus(long amount) {
        return new Minus().apply(this, this.unit == null ? FOREVER : new Duration(amount, this.unit));
    }

    public Duration minus(long amount, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null");
        }
        return new Minus().apply(this, new Duration(amount, timeUnit));
    }

    public Duration minus(Duration duration) {
        return new Minus().apply(this, duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.getValueInMS() == duration.getValueInMS();
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Duration{unit=" + (Object)((Object)this.unit) + ", value=" + this.value + '}';
    }

    @Override
    public int compareTo(Duration other) {
        if (other == null) {
            return 1;
        }
        return Long.compare(this.getValueInMS(), other.getValueInMS());
    }

    private static class Divide
    extends BiFunction {
        private Divide() {
        }

        @Override
        protected Duration handleSpecialCases(Duration lhs, Duration rhs) {
            if (lhs == FOREVER) {
                return FOREVER;
            }
            if (rhs == FOREVER) {
                throw new IllegalArgumentException("Cannot divide by infinity");
            }
            if (ZERO.equals(lhs)) {
                return ZERO;
            }
            return null;
        }

        @Override
        long apply(long operand1, long operand2) {
            return operand1 / operand2;
        }
    }

    private static class Multiply
    extends BiFunction {
        private Multiply() {
        }

        @Override
        protected Duration handleSpecialCases(Duration lhs, Duration rhs) {
            if (lhs.isZero() || rhs.isZero()) {
                return ZERO;
            }
            if (lhs == FOREVER || rhs == FOREVER) {
                return FOREVER;
            }
            return null;
        }

        @Override
        long apply(long operand1, long operand2) {
            return operand1 * operand2;
        }
    }

    private static class Minus
    extends BiFunction {
        private Minus() {
        }

        @Override
        protected Duration handleSpecialCases(Duration lhs, Duration rhs) {
            if (!lhs.isZero() && rhs.isZero()) {
                return lhs;
            }
            if (lhs == FOREVER) {
                return FOREVER;
            }
            if (rhs == FOREVER) {
                return ZERO;
            }
            if (FOREVER.equals(rhs)) {
                return ZERO;
            }
            return null;
        }

        @Override
        long apply(long operand1, long operand2) {
            return operand1 - operand2;
        }
    }

    private static class Plus
    extends BiFunction {
        private Plus() {
        }

        @Override
        protected Duration handleSpecialCases(Duration lhs, Duration rhs) {
            if (ZERO.equals(rhs)) {
                return lhs;
            }
            if (ZERO.equals(lhs)) {
                return rhs;
            }
            if (lhs == FOREVER || rhs == FOREVER) {
                return FOREVER;
            }
            return null;
        }

        @Override
        long apply(long operand1, long operand2) {
            return operand1 + operand2;
        }
    }

    private static abstract class BiFunction {
        private BiFunction() {
        }

        public final Duration apply(Duration lhs, Duration rhs) {
            Duration newDuration;
            if (lhs == null || rhs == null) {
                throw new IllegalArgumentException("Duration cannot be null");
            }
            if (lhs == SAME_AS_POLL_INTERVAL || rhs == SAME_AS_POLL_INTERVAL) {
                throw new IllegalStateException("Cannot perform operation on this kind of duration (SAME_AS_POLL_INTERVAL). Please don't use this Duration since it's deprecated");
            }
            Duration specialDuration = this.handleSpecialCases(lhs, rhs);
            if (specialDuration != null) {
                return specialDuration;
            }
            if (lhs.getTimeUnit().ordinal() > rhs.getTimeUnit().ordinal()) {
                long lhsConverted = rhs.getTimeUnit().convert(lhs.getValue(), lhs.getTimeUnit());
                newDuration = new Duration(this.apply(lhsConverted, rhs.getValue()), rhs.getTimeUnit());
            } else if (lhs.getTimeUnit().ordinal() < rhs.getTimeUnit().ordinal()) {
                long rhsConverted = lhs.getTimeUnit().convert(rhs.getValue(), rhs.getTimeUnit());
                newDuration = new Duration(this.apply(lhs.getValue(), rhsConverted), lhs.getTimeUnit());
            } else {
                newDuration = new Duration(this.apply(lhs.getValue(), rhs.getValue()), lhs.getTimeUnit());
            }
            return newDuration;
        }

        protected abstract Duration handleSpecialCases(Duration var1, Duration var2);

        abstract long apply(long var1, long var3);
    }
}

