/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.beans.Introspector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.awaitility.Duration;
import org.awaitility.classpath.ClassPathResolver;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.ConditionEvaluationHandler;
import org.awaitility.core.ConditionEvaluator;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.DeadlockException;

abstract class ConditionAwaiter
implements Thread.UncaughtExceptionHandler {
    private final ExecutorService executor;
    private final CountDownLatch latch;
    private final ConditionEvaluator conditionEvaluator;
    private Throwable throwable = null;
    private final ConditionSettings conditionSettings;

    public ConditionAwaiter(ConditionEvaluator conditionEvaluator, ConditionSettings conditionSettings) {
        if (conditionEvaluator == null) {
            throw new IllegalArgumentException("You must specify a condition (was null).");
        }
        if (conditionSettings == null) {
            throw new IllegalArgumentException("You must specify the condition settings (was null).");
        }
        if (conditionSettings.shouldCatchUncaughtExceptions()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        this.conditionSettings = conditionSettings;
        this.latch = new CountDownLatch(1);
        this.conditionEvaluator = conditionEvaluator;
        this.executor = this.initExecutorService();
    }

    private boolean conditionCompleted() {
        return this.latch.getCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void await(ConditionEvaluationHandler<T> conditionEvaluationHandler) {
        Duration pollDelay = this.conditionSettings.getPollDelay();
        Duration maxWaitTime = this.conditionSettings.getMaxWaitTime();
        Duration minWaitTime = this.conditionSettings.getMinWaitTime();
        long maxTimeout = maxWaitTime.getValue();
        TimeUnit maxTimeoutUnit = maxWaitTime.getTimeUnit();
        long pollingStarted = System.currentTimeMillis() - pollDelay.getValueInMS();
        this.pollSchedulingThread(conditionEvaluationHandler, pollDelay, maxWaitTime).start();
        try {
            try {
                boolean finishedBeforeTimeout;
                if (maxWaitTime == Duration.FOREVER) {
                    this.latch.await();
                    finishedBeforeTimeout = true;
                } else {
                    if (maxWaitTime == Duration.SAME_AS_POLL_INTERVAL) {
                        throw new IllegalStateException("Cannot use 'SAME_AS_POLL_INTERVAL' as maximum wait time.");
                    }
                    finishedBeforeTimeout = this.latch.await(maxTimeout, maxTimeoutUnit);
                }
                Duration evaluationDuration = new Duration(System.currentTimeMillis() - pollingStarted, TimeUnit.MILLISECONDS).minus(pollDelay);
                if (this.throwable != null) {
                    throw this.throwable;
                }
                if (!finishedBeforeTimeout) {
                    String maxWaitTimeLowerCase = maxWaitTime.getTimeUnitAsString();
                    String message = this.conditionSettings.hasAlias() ? String.format("Condition with alias '%s' didn't complete within %s %s because %s.", this.conditionSettings.getAlias(), maxTimeout, maxWaitTimeLowerCase, Introspector.decapitalize(this.getTimeoutMessage())) : String.format("%s within %s %s.", this.getTimeoutMessage(), maxTimeout, maxWaitTimeLowerCase);
                    ConditionTimeoutException e = new ConditionTimeoutException(message);
                    if (ClassPathResolver.existInCP("java.lang.management.ThreadMXBean") && ClassPathResolver.existInCP("java.lang.management.ManagementFactory")) {
                        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                        try {
                            long[] threadIds = bean.findDeadlockedThreads();
                            if (threadIds != null) {
                                e.initCause(new DeadlockException(threadIds));
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                if (evaluationDuration.compareTo(minWaitTime) < 0) {
                    String message = String.format("Condition was evaluated in %s %s which is earlier than expected minimum timeout %s %s", new Object[]{evaluationDuration.getValue(), evaluationDuration.getTimeUnit(), minWaitTime.getValue(), minWaitTime.getTimeUnit()});
                    throw new ConditionTimeoutException(message);
                }
            }
            finally {
                this.executor.shutdown();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
        }
        catch (Throwable e) {
            CheckedExceptionRethrower.safeRethrow(e);
        }
    }

    private <T> Thread pollSchedulingThread(final ConditionEvaluationHandler<T> conditionEvaluationHandler, final Duration pollDelay, final Duration maxWaitTime) {
        final long maxTimeout = maxWaitTime.getValue();
        final TimeUnit maxTimeoutUnit = maxWaitTime.getTimeUnit();
        return new Thread(new Runnable(){

            @Override
            public void run() {
                int pollCount = 0;
                try {
                    conditionEvaluationHandler.start();
                    if (!pollDelay.isZero()) {
                        Thread.sleep(pollDelay.getValueInMS());
                    }
                    Duration pollInterval = pollDelay;
                    while (!ConditionAwaiter.this.executor.isShutdown() && !ConditionAwaiter.this.conditionCompleted()) {
                        ++pollCount;
                        Future<?> future = ConditionAwaiter.this.executor.submit(new ConditionPoller(pollInterval));
                        if (maxWaitTime == Duration.FOREVER) {
                            future.get();
                        } else {
                            future.get(maxTimeout, maxTimeoutUnit);
                        }
                        pollInterval = ConditionAwaiter.this.conditionSettings.getPollInterval().next(pollCount, pollInterval);
                        Thread.sleep(pollInterval.getValueInMS());
                    }
                }
                catch (Exception e) {
                    ConditionAwaiter.this.throwable = e;
                }
            }
        });
    }

    protected abstract String getTimeoutMessage();

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.throwable = throwable;
        if (this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
    }

    private ExecutorService initExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = ConditionAwaiter.this.conditionSettings.hasAlias() ? new Thread(Thread.currentThread().getThreadGroup(), r, "awaitility[" + ConditionAwaiter.this.conditionSettings.getAlias() + ']') : new Thread(Thread.currentThread().getThreadGroup(), r, "awaitility-thread");
                return thread;
            }
        });
    }

    private class ConditionPoller
    implements Runnable {
        private final Duration delayed;

        public ConditionPoller(Duration delayed) {
            this.delayed = delayed;
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (ConditionAwaiter.this.conditionEvaluator.eval(this.delayed)) {
                        ConditionAwaiter.this.latch.countDown();
                    }
                }
                catch (Exception e) {
                    if (ConditionAwaiter.this.conditionSettings.shouldExceptionBeIgnored(e)) break block3;
                    ConditionAwaiter.this.throwable = e;
                    ConditionAwaiter.this.latch.countDown();
                }
            }
        }
    }
}

