/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.concurrent.TimeUnit;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.EvaluatedCondition;

public class ConditionEvaluationLogger
implements ConditionEvaluationListener<Object> {
    private final TimeUnit timeUnit;

    public ConditionEvaluationLogger() {
        this(TimeUnit.MILLISECONDS);
    }

    public ConditionEvaluationLogger(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    public void conditionEvaluated(EvaluatedCondition<Object> condition) {
        String description = condition.getDescription();
        long elapsedTime = this.timeUnit.convert(condition.getElapsedTimeInMS(), TimeUnit.MILLISECONDS);
        long remainingTime = this.timeUnit.convert(condition.getRemainingTimeInMS(), TimeUnit.MILLISECONDS);
        String timeUnitAsString = this.timeUnit.toString().toLowerCase();
        if (condition.isSatisfied()) {
            System.out.printf("%s after %d %s (remaining time %d %s, last poll interval was %d %s)\n", description, elapsedTime, timeUnitAsString, remainingTime, timeUnitAsString, condition.getPollInterval().getValue(), condition.getPollInterval().getTimeUnitAsString());
        } else {
            System.out.printf("%s (elapsed time %d %s, remaining time %d %s (last poll interval was %d %s))\n", description, elapsedTime, timeUnitAsString, remainingTime, timeUnitAsString, condition.getPollInterval().getValue(), condition.getPollInterval().getTimeUnitAsString());
        }
    }
}

