/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.lock.LockAnalysis;
import org.checkerframework.checker.lock.LockChecker;
import org.checkerframework.checker.lock.LockStore;
import org.checkerframework.checker.lock.LockTransfer;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.qual.LockingFree;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public class LockAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, LockStore, LockTransfer, LockAnalysis> {
    protected final AnnotationMirror LOCKHELD;
    protected final AnnotationMirror LOCKPOSSIBLYHELD;
    protected final AnnotationMirror SIDEEFFECTFREE;
    protected final Set<Class<? extends Annotation>> lockAnnos;

    public LockAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFlow) {
        super(checker, useFlow);
        this.LOCKHELD = AnnotationUtils.fromClass(this.elements, LockHeld.class);
        this.LOCKPOSSIBLYHELD = AnnotationUtils.fromClass(this.elements, LockPossiblyHeld.class);
        this.SIDEEFFECTFREE = AnnotationUtils.fromClass(this.elements, SideEffectFree.class);
        HashSet<Class> tempLockAnnos = new HashSet<Class>();
        tempLockAnnos.add(LockHeld.class);
        tempLockAnnos.add(LockPossiblyHeld.class);
        this.lockAnnos = Collections.unmodifiableSet(tempLockAnnos);
        this.addAliasedDeclAnnotation(LockingFree.class, SideEffectFree.class, AnnotationUtils.fromClass(this.elements, SideEffectFree.class));
        this.postInit();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new LockQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new LockTreeAnnotator(this));
    }

    @Override
    protected LockAnalysis createFlowAnalysis(List<Pair<VariableElement, CFValue>> fieldValues) {
        return new LockAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public LockTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, LockStore, LockTransfer> analysis) {
        return new LockTransfer((LockAnalysis)analysis, (LockChecker)this.checker);
    }

    protected AnnotatedTypeMirror getDeclaredAndDefaultedAnnotatedType(Tree tree) {
        this.shouldCache = false;
        AnnotatedTypeMirror type = this.getAnnotatedType(tree);
        this.shouldCache = true;
        return type;
    }

    public Set<Class<? extends Annotation>> getLockAnnotations() {
        return this.lockAnnos;
    }

    class LockQualifierHierarchy
    extends GraphQualifierHierarchy {
        public LockQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, LockAnnotatedTypeFactory.this.LOCKHELD);
        }
    }

    private class LockTreeAnnotator
    extends TreeAnnotator {
        public LockTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }
    }
}

