/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util.count;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.source.SupportedOptions;
import org.checkerframework.javacutil.AnnotationProvider;

@SupportedOptions(value={"nolocations", "annotations"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class Locations
extends SourceChecker {
    @Override
    protected SourceVisitor<?, ?> createSourceVisitor() {
        return new Visitor(this);
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        throw new UnsupportedOperationException("getAnnotationProvider is not implemented for this class.");
    }

    static class Visitor
    extends SourceVisitor<Void, Void> {
        private final boolean locations;
        private final boolean annotations;

        public Visitor(Locations l) {
            super(l);
            this.locations = !l.hasOption("nolocations");
            this.annotations = l.hasOption("annotations");
        }

        @Override
        public Void visitAnnotation(AnnotationTree tree, Void p) {
            if (this.annotations) {
                boolean isBodyAnnotation = false;
                TreePath path = this.getCurrentPath();
                Tree prev = null;
                for (Tree t : path) {
                    if (prev != null && prev.getKind() == Tree.Kind.BLOCK && t.getKind() == Tree.Kind.METHOD) {
                        isBodyAnnotation = true;
                        break;
                    }
                    prev = t;
                }
                System.out.printf(":annotation %s %s %s %s%n", tree.getAnnotationType(), tree, this.root.getSourceFile().getName(), isBodyAnnotation ? "body" : "sig");
            }
            return (Void)super.visitAnnotation(tree, p);
        }

        @Override
        public Void visitArrayType(ArrayTypeTree tree, Void p) {
            if (this.locations) {
                System.out.println("array type");
            }
            return (Void)super.visitArrayType(tree, p);
        }

        @Override
        public Void visitClass(ClassTree tree, Void p) {
            if (this.locations) {
                System.out.println("class");
                if (tree.getExtendsClause() != null) {
                    System.out.println("class extends");
                }
                for (Tree tree2 : tree.getImplementsClause()) {
                    System.out.println("class implements");
                }
            }
            return (Void)super.visitClass(tree, p);
        }

        @Override
        public Void visitMethod(MethodTree tree, Void p) {
            if (this.locations) {
                System.out.println("method return");
                System.out.println("method receiver");
                for (Tree tree2 : tree.getThrows()) {
                    System.out.println("method throws");
                }
                for (Tree tree3 : tree.getParameters()) {
                    System.out.println("method param");
                }
            }
            return (Void)super.visitMethod(tree, p);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void p) {
            if (this.locations) {
                System.out.println("variable");
            }
            return (Void)super.visitVariable(tree, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void p) {
            if (this.locations) {
                for (Tree tree2 : tree.getTypeArguments()) {
                    System.out.println("method invocation type argument");
                }
            }
            return (Void)super.visitMethodInvocation(tree, p);
        }

        @Override
        public Void visitNewClass(NewClassTree tree, Void p) {
            if (this.locations) {
                System.out.println("new class");
                for (Tree tree2 : tree.getTypeArguments()) {
                    System.out.println("new class type argument");
                }
            }
            return (Void)super.visitNewClass(tree, p);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree, Void p) {
            if (this.locations) {
                System.out.println("new array");
                for (Tree tree2 : tree.getDimensions()) {
                    System.out.println("new array dimension");
                }
            }
            return (Void)super.visitNewArray(tree, p);
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree, Void p) {
            if (this.locations) {
                System.out.println("typecast");
            }
            return (Void)super.visitTypeCast(tree, p);
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree tree, Void p) {
            if (this.locations) {
                System.out.println("instanceof");
            }
            return (Void)super.visitInstanceOf(tree, p);
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree tree, Void p) {
            if (this.locations) {
                for (Tree tree2 : tree.getTypeArguments()) {
                    System.out.println("parameterized type");
                }
            }
            return (Void)super.visitParameterizedType(tree, p);
        }

        @Override
        public Void visitTypeParameter(TypeParameterTree tree, Void p) {
            if (this.locations) {
                for (Tree tree2 : tree.getBounds()) {
                    System.out.println("type parameter bound");
                }
            }
            return (Void)super.visitTypeParameter(tree, p);
        }

        @Override
        public Void visitWildcard(WildcardTree tree, Void p) {
            if (this.locations) {
                System.out.println("wildcard");
            }
            return (Void)super.visitWildcard(tree, p);
        }
    }
}

