/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultRawnessComparer;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.StructuralEqualityComparer;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.type.visitor.VisitHistory;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AtmCombo;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.TypeArgumentMapper;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TypesUtils;

public class DefaultTypeHierarchy
extends AbstractAtmComboVisitor<Boolean, VisitHistory>
implements TypeHierarchy {
    protected final BaseTypeChecker checker;
    protected final QualifierHierarchy qualifierHierarchy;
    protected final StructuralEqualityComparer equalityComparer;
    protected final DefaultRawnessComparer rawnessComparer;
    protected final boolean ignoreRawTypes;
    protected final boolean invariantArrayComponents;
    protected final boolean covariantTypeArgs;
    protected AnnotationMirror currentTop;

    public DefaultTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents) {
        this(checker, qualifierHierarchy, ignoreRawTypes, invariantArrayComponents, false);
    }

    public DefaultRawnessComparer createRawnessComparer() {
        return new DefaultRawnessComparer(this);
    }

    public StructuralEqualityComparer createEqualityComparer() {
        return new StructuralEqualityComparer(this.rawnessComparer);
    }

    public DefaultTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrayComponents, boolean covariantTypeArgs) {
        this.checker = checker;
        this.qualifierHierarchy = qualifierHierarchy;
        this.rawnessComparer = this.createRawnessComparer();
        this.equalityComparer = this.createEqualityComparer();
        this.ignoreRawTypes = ignoreRawTypes;
        this.invariantArrayComponents = invariantArrayComponents;
        this.covariantTypeArgs = covariantTypeArgs;
    }

    @Override
    public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        for (AnnotationMirror annotationMirror : this.qualifierHierarchy.getTopAnnotations()) {
            if (this.isSubtype(subtype, supertype, annotationMirror)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, AnnotationMirror top) {
        this.currentTop = top;
        return this.isSubtype(subtype, supertype, new VisitHistory());
    }

    public boolean areSubtypes(Iterable<? extends AnnotatedTypeMirror> subtypes, Iterable<? extends AnnotatedTypeMirror> supertypes) {
        Iterator<? extends AnnotatedTypeMirror> subtypeIterator = subtypes.iterator();
        Iterator<? extends AnnotatedTypeMirror> supertypesIterator = supertypes.iterator();
        while (subtypeIterator.hasNext() && supertypesIterator.hasNext()) {
            AnnotatedTypeMirror supertype;
            AnnotatedTypeMirror subtype = subtypeIterator.next();
            if (this.isSubtype(subtype, supertype = supertypesIterator.next())) continue;
            return false;
        }
        if (subtypeIterator.hasNext() || supertypesIterator.hasNext()) {
            ErrorReporter.errorAbort("Unbalanced set of type arguments. \nsubtype=( " + PluginUtil.join(", ", subtypes) + ")\n" + "supertype=( " + PluginUtil.join(", ", supertypes) + ")");
        }
        return true;
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return "Incomparable types ( " + subtype + ", " + supertype + ")" + "visitHistory = " + visited;
    }

    public boolean isSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return AtmCombo.accept(subtype, supertype, visited, this);
    }

    protected boolean isPrimarySubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        return this.isPrimarySubtype(subtype, supertype, false);
    }

    protected boolean isPrimarySubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, boolean annosCanBeEmtpy) {
        AnnotationMirror subtypeAnno = subtype.getAnnotationInHierarchy(this.currentTop);
        AnnotationMirror supertypeAnno = supertype.getAnnotationInHierarchy(this.currentTop);
        return this.isAnnoSubtype(subtypeAnno, supertypeAnno, annosCanBeEmtpy);
    }

    protected boolean isAnnoSubtype(AnnotationMirror subtypeAnno, AnnotationMirror supertypeAnno, boolean annosCanBeEmtpy) {
        if (annosCanBeEmtpy && subtypeAnno == null && supertypeAnno == null) {
            return true;
        }
        return this.qualifierHierarchy.isSubtype(subtypeAnno, supertypeAnno);
    }

    protected boolean isBottom(AnnotatedTypeMirror subtype) {
        AnnotationMirror bottom = this.qualifierHierarchy.getBottomAnnotation(this.currentTop);
        if (bottom == null) {
            return false;
        }
        switch (subtype.getKind()) {
            case TYPEVAR: {
                return this.isBottom(((AnnotatedTypeMirror.AnnotatedTypeVariable)subtype).getUpperBound());
            }
            case WILDCARD: {
                AnnotatedTypeMirror.AnnotatedWildcardType subtypeWc = (AnnotatedTypeMirror.AnnotatedWildcardType)subtype;
                return this.isBottom(subtypeWc);
            }
        }
        AnnotationMirror subtypeAnno = subtype.getAnnotationInHierarchy(this.currentTop);
        return this.isAnnoSubtype(subtypeAnno, bottom, false);
    }

    protected boolean checkAndSubtype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        if (visited.contains(subtype, supertype)) {
            return true;
        }
        visited.add(subtype, supertype);
        return this.isSubtype(subtype, supertype, visited);
    }

    protected boolean isSubtypeOfAll(AnnotatedTypeMirror subtype, Iterable<? extends AnnotatedTypeMirror> supertypes, VisitHistory visited) {
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            if (this.isSubtype(subtype, annotatedTypeMirror, visited)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubtypeOfAny(AnnotatedTypeMirror subtype, Iterable<? extends AnnotatedTypeMirror> supertypes, VisitHistory visited) {
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            if (!this.isSubtype(subtype, annotatedTypeMirror, visited)) continue;
            return true;
        }
        return false;
    }

    protected boolean areAllSubtypes(Iterable<? extends AnnotatedTypeMirror> subtypes, AnnotatedTypeMirror supertype, VisitHistory visited) {
        for (AnnotatedTypeMirror annotatedTypeMirror : subtypes) {
            if (this.isSubtype(annotatedTypeMirror, supertype, visited)) continue;
            return false;
        }
        return true;
    }

    protected boolean areAnySubtypes(Iterable<? extends AnnotatedTypeMirror> subtypes, AnnotatedTypeMirror supertype, VisitHistory visited) {
        for (AnnotatedTypeMirror annotatedTypeMirror : subtypes) {
            if (!this.isSubtype(annotatedTypeMirror, supertype, visited)) continue;
            return true;
        }
        return false;
    }

    protected boolean areEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return this.equalityComparer.areEqual(type1, type2);
    }

    protected boolean areEqualInHierarchy(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror top) {
        return this.equalityComparer.areEqualInHierarchy(type1, type2, top);
    }

    protected boolean isContainedBy(AnnotatedTypeMirror inside, AnnotatedTypeMirror outside, VisitHistory visited, boolean canBeCovariant) {
        if (canBeCovariant && this.isSubtype(inside, outside, visited)) {
            return true;
        }
        if (outside.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType outsideWc = (AnnotatedTypeMirror.AnnotatedWildcardType)outside;
            boolean aboveSuperBound = this.checkAndSubtype(outsideWc.getSuperBound(), inside, visited);
            boolean belowExtendsBound = this.checkAndSubtype(inside, outsideWc.getExtendsBound(), visited);
            return belowExtendsBound && aboveSuperBound;
        }
        return this.areEqualInHierarchy(inside, outside, this.currentTop);
    }

    @Override
    public Boolean visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype) && (this.invariantArrayComponents ? this.areEqualInHierarchy(subtype.getComponentType(), supertype.getComponentType(), this.currentTop) : this.isSubtype(subtype.getComponentType(), supertype.getComponentType(), visited));
    }

    @Override
    public Boolean visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitArray_Null(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Array(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        AnnotatedTypeMirror.AnnotatedDeclaredType subtypeAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subtypeAsSuper == null) {
            if (TypesUtils.isDeclaredOfName(supertype.getUnderlyingType(), "java.lang.String")) {
                return this.isPrimarySubtype(subtype, supertype);
            }
            return false;
        }
        if (!this.isPrimarySubtype(subtypeAsSuper, supertype)) {
            return false;
        }
        if (visited.contains(subtypeAsSuper, supertype)) {
            return true;
        }
        visited.add(subtypeAsSuper, supertype);
        Boolean result = this.visitTypeArgs(subtypeAsSuper, supertype, visited, subtype.wasRaw(), supertype.wasRaw());
        return result;
    }

    public Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited, boolean subtypeRaw, boolean supertypeRaw) {
        boolean ignoreTypeArgs;
        boolean bl = ignoreTypeArgs = this.ignoreRawTypes && (subtypeRaw || supertypeRaw);
        if (!ignoreTypeArgs) {
            List<AnnotatedTypeMirror> subtypeTypeArgs = subtype.getTypeArguments();
            List<AnnotatedTypeMirror> supertypeTypeArgs = supertype.getTypeArguments();
            if (subtypeTypeArgs.isEmpty() || supertypeTypeArgs.isEmpty()) {
                return true;
            }
            if (supertypeTypeArgs.size() > 0) {
                for (int i = 0; i < supertypeTypeArgs.size(); ++i) {
                    AnnotatedTypeMirror superTypeArg = supertypeTypeArgs.get(i);
                    AnnotatedTypeMirror subTypeArg = subtypeTypeArgs.get(i);
                    if (this.compareTypeArgs(subTypeArg, superTypeArg, supertypeRaw, subtypeRaw, visited)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean compareTypeArgs(AnnotatedTypeMirror subTypeArg, AnnotatedTypeMirror superTypeArg, boolean subtypeRaw, boolean supertypeRaw, VisitHistory visited) {
        return !(subtypeRaw || supertypeRaw ? !this.rawnessComparer.isValidInHierarchy(subTypeArg, superTypeArg, this.currentTop, visited) && !this.isContainedBy(subTypeArg, superTypeArg, visited, this.covariantTypeArgs) : !this.isContainedBy(subTypeArg, superTypeArg, visited, this.covariantTypeArgs));
    }

    @Override
    public Boolean visitDeclared_Intersection(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.visitIntersectionSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Null(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, VisitHistory visited) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType subAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subAsSuper == null) {
            return this.isPrimarySubtype(subtype, supertype);
        }
        return this.isPrimarySubtype(subAsSuper, supertype);
    }

    @Override
    public Boolean visitTypevar_Intersection(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.visitIntersectionSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Typevar(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Union(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, VisitHistory visited) {
        return this.visitUnionSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitIntersection_Declared(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.visitIntersectionSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.visitIntersectionSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitIntersection_Null(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.visitIntersectionSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitNull_Array(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Declared(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Typevar(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitNull_Wildcard(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Union(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, VisitHistory visited) {
        return this.visitUnionSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitNull_Intersection(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitNull_Primitive(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        AnnotatedTypeMirror.AnnotatedDeclaredType subAsSuper = DefaultTypeHierarchy.castedAsSuper(subtype, supertype);
        if (subAsSuper == null) {
            return this.isPrimarySubtype(subtype, supertype);
        }
        return this.isPrimarySubtype(subAsSuper, supertype);
    }

    @Override
    public Boolean visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, VisitHistory visited) {
        return this.isPrimarySubtype(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Intersection(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.visitIntersectionSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitPrimitive_Wildcard(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visitHistory) {
        if (supertype.isTypeArgHack()) {
            if (this.ignoreRawTypes) {
                return true;
            }
            return this.isPrimarySubtype(subtype, supertype.getSuperBound());
        }
        return this.isPrimarySubtype(subtype, supertype.getSuperBound());
    }

    @Override
    public Boolean visitUnion_Declared(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.visitUnionSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Declared(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.visitTypevarSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        if (AnnotatedTypes.haveSameDeclaration(this.checker.getTypeUtils(), subtype, supertype)) {
            boolean supertypeHasAnno;
            boolean subtypeHasAnno = subtype.getAnnotationInHierarchy(this.currentTop) != null;
            boolean bl = supertypeHasAnno = supertype.getAnnotationInHierarchy(this.currentTop) != null;
            if (subtypeHasAnno && supertypeHasAnno) {
                return this.isPrimarySubtype(subtype, supertype, true);
            }
            if (!subtypeHasAnno && !supertypeHasAnno && this.areEqualInHierarchy(subtype, supertype, this.currentTop)) {
                return true;
            }
            if (subtype.getUpperBound().getKind() == TypeKind.INTERSECTION) {
                return this.visitIntersectionSubtype((AnnotatedTypeMirror.AnnotatedIntersectionType)subtype.getUpperBound(), supertype.getLowerBound(), visited);
            }
        }
        if (AnnotatedTypes.areCorrespondingTypeVariables(this.checker.getProcessingEnvironment().getElementUtils(), subtype, supertype) && this.areEqualInHierarchy(subtype, supertype, this.currentTop)) {
            return true;
        }
        return this.visitTypevarSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Null(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.visitTypevarSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Array(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Intersection(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Primitive(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSubtype(subtype, supertype, visited);
    }

    protected boolean visitIntersectionSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedIntersectionType supertype, VisitHistory visited) {
        if (visited.contains(subtype, supertype)) {
            return true;
        }
        visited.add(subtype, supertype);
        return this.isSubtypeOfAll(subtype, supertype.directSuperTypes(), visited);
    }

    protected boolean visitIntersectionSubtype(AnnotatedTypeMirror.AnnotatedIntersectionType subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return this.areAnySubtypes(subtype.directSuperTypes(), supertype, visited);
    }

    protected boolean visitTypevarSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.checkAndSubtype(subtype, supertype.getLowerBound(), visited);
    }

    protected boolean visitTypevarSubtype(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return this.checkAndSubtype(subtype.getUpperBound(), supertype, visited);
    }

    protected boolean visitUnionSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype, VisitHistory visited) {
        return this.isSubtypeOfAny(subtype, supertype.getAlternatives(), visited);
    }

    protected Boolean visitUnionSubtype(AnnotatedTypeMirror.AnnotatedUnionType subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return this.areAllSubtypes(subtype.getAlternatives(), supertype, visited);
    }

    protected boolean visitWildcardSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        if (supertype.isTypeArgHack()) {
            return this.isSubtype(subtype, supertype.getExtendsBound());
        }
        return this.isSubtype(subtype, supertype.getSuperBound(), visited);
    }

    protected boolean visitWildcardSubtype(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return this.isSubtype(subtype.getExtendsBound(), supertype, visited);
    }

    public static <T extends AnnotatedTypeMirror> T castedAsSuper(AnnotatedTypeMirror subtype, T supertype) {
        Types types = subtype.atypeFactory.getProcessingEnv().getTypeUtils();
        Elements elements = subtype.atypeFactory.getProcessingEnv().getElementUtils();
        AnnotatedTypeMirror asSuperType = AnnotatedTypes.asSuper(types, subtype.atypeFactory, subtype, supertype);
        DefaultTypeHierarchy.fixUpRawTypes(subtype, asSuperType, supertype, types);
        if (asSuperType != null && AnnotatedTypes.isEnum(asSuperType) && AnnotatedTypes.isDeclarationOfJavaLangEnum(types, elements, supertype)) {
            AnnotatedTypeMirror.AnnotatedDeclaredType resultAtd = ((AnnotatedTypeMirror.AnnotatedDeclaredType)supertype).deepCopy();
            resultAtd.clearAnnotations();
            resultAtd.addAnnotations(asSuperType.getAnnotations());
            AnnotatedTypeMirror.AnnotatedDeclaredType asSuperAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)asSuperType;
            if (resultAtd.getTypeArguments().size() > 0 && asSuperAdt.getTypeArguments().size() > 0) {
                AnnotatedTypeMirror sourceTypeArg = asSuperAdt.getTypeArguments().get(0);
                AnnotatedTypeMirror resultTypeArg = resultAtd.getTypeArguments().get(0);
                resultTypeArg.clearAnnotations();
                resultTypeArg.addAnnotations(sourceTypeArg.getAnnotations());
                return (T)resultAtd;
            }
        }
        return (T)AnnotatedTypes.asSuper(types, subtype.atypeFactory, subtype, supertype);
    }

    private static void fixUpRawTypes(AnnotatedTypeMirror originalSubtype, AnnotatedTypeMirror asSuperType, AnnotatedTypeMirror supertype, Types types) {
        if (asSuperType != null && asSuperType.getKind() == TypeKind.DECLARED && originalSubtype.getKind() == TypeKind.DECLARED) {
            Set<Pair<Integer, Integer>> typeArgMap;
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredAsSuper = (AnnotatedTypeMirror.AnnotatedDeclaredType)asSuperType;
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredSubtype = (AnnotatedTypeMirror.AnnotatedDeclaredType)originalSubtype;
            if (declaredAsSuper.wasRaw() && declaredAsSuper.getTypeArguments().isEmpty() && !declaredSubtype.getTypeArguments().isEmpty() && (typeArgMap = TypeArgumentMapper.mapTypeArgumentIndices((TypeElement)declaredSubtype.getUnderlyingType().asElement(), (TypeElement)declaredAsSuper.getUnderlyingType().asElement(), types)).size() == declaredSubtype.getTypeArguments().size()) {
                ArrayList<AnnotatedTypeMirror> newTypeArgs = new ArrayList<AnnotatedTypeMirror>();
                ArrayList<Pair<Integer, Integer>> orderedByDestination = new ArrayList<Pair<Integer, Integer>>(typeArgMap);
                Collections.sort(orderedByDestination, new Comparator<Pair<Integer, Integer>>(){

                    @Override
                    public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                        return (Integer)o1.second - (Integer)o2.second;
                    }
                });
                List<AnnotatedTypeMirror> subTypeArgs = declaredSubtype.getTypeArguments();
                if (typeArgMap.size() == ((AnnotatedTypeMirror.AnnotatedDeclaredType)supertype).getTypeArguments().size()) {
                    for (Pair pair : orderedByDestination) {
                        newTypeArgs.add(subTypeArgs.get((Integer)pair.first).deepCopy());
                    }
                }
                declaredAsSuper.setTypeArguments(newTypeArgs);
            }
        }
    }
}

