/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.javacutil.Pair;

public class TypeArgumentMapper {
    public static Set<Pair<Integer, Integer>> mapTypeArgumentIndices(TypeElement subtype, TypeElement supertype, Types types) {
        HashSet<Pair<Integer, Integer>> result = new HashSet<Pair<Integer, Integer>>();
        if (subtype.equals(supertype)) {
            for (int i = 0; i < subtype.getTypeParameters().size(); ++i) {
                result.add(Pair.of(new Integer(i), new Integer(i)));
            }
        } else {
            Map<TypeParameterElement, Set<TypeParameterElement>> subToSuperElements = TypeArgumentMapper.mapTypeArguments(subtype, supertype, types);
            Map<TypeParameterElement, Integer> supertypeIndexes = TypeArgumentMapper.getElementToIndex(supertype);
            List<? extends TypeParameterElement> subtypeParams = subtype.getTypeParameters();
            for (int subtypeIndex = 0; subtypeIndex < subtypeParams.size(); ++subtypeIndex) {
                TypeParameterElement subtypeParam = subtypeParams.get(subtypeIndex);
                Set<TypeParameterElement> correspondingSuperArgs = subToSuperElements.get(subtypeParam);
                if (correspondingSuperArgs == null) continue;
                for (TypeParameterElement supertypeParam : subToSuperElements.get(subtypeParam)) {
                    result.add(Pair.of(subtypeIndex, supertypeIndexes.get(supertypeParam)));
                }
            }
        }
        return result;
    }

    private static Map<TypeParameterElement, Integer> getElementToIndex(TypeElement typeElement) {
        LinkedHashMap<TypeParameterElement, Integer> result = new LinkedHashMap<TypeParameterElement, Integer>();
        List<? extends TypeParameterElement> params = typeElement.getTypeParameters();
        for (int i = 0; i < params.size(); ++i) {
            result.put(params.get(i), new Integer(i));
        }
        return result;
    }

    public static Map<TypeParameterElement, Set<TypeParameterElement>> mapTypeArguments(TypeElement subtype, TypeElement supertype, Types types) {
        LinkedHashMap<TypeParameterElement, Set<TypeParameterElement>> result = new LinkedHashMap<TypeParameterElement, Set<TypeParameterElement>>();
        List<TypeRecord> pathToSupertype = TypeArgumentMapper.depthFirstSearchForSupertype(subtype, supertype, types);
        if (pathToSupertype != null && !pathToSupertype.isEmpty()) {
            LinkedHashMap<TypeParameterElement, Set<TypeParameterElement>> intermediate = new LinkedHashMap<TypeParameterElement, Set<TypeParameterElement>>();
            HashSet<? extends TypeParameterElement> currentTypeParams = new HashSet<TypeParameterElement>();
            Iterator<TypeRecord> path = pathToSupertype.iterator();
            TypeRecord current = path.next();
            while (path.hasNext()) {
                TypeRecord next = path.next();
                List<? extends TypeParameterElement> nextTypeParameter = next.element.getTypeParameters();
                List<? extends TypeMirror> list = next.type.getTypeArguments();
                currentTypeParams.clear();
                currentTypeParams.addAll(current.element.getTypeParameters());
                for (int i = 0; i < list.size(); ++i) {
                    TypeParameterElement correspondingParameter = nextTypeParameter.get(i);
                    TypeMirror typeArg = list.get(i);
                    Element typeArgEle = types.asElement(typeArg);
                    if (!currentTypeParams.contains(typeArgEle)) continue;
                    TypeArgumentMapper.addToSetMap(intermediate, (TypeParameterElement)typeArgEle, correspondingParameter);
                }
            }
            List<? extends TypeParameterElement> supertypeParams = supertype.getTypeParameters();
            for (TypeParameterElement typeParameterElement : subtype.getTypeParameters()) {
                Set<TypeParameterElement> subtypePath = TypeArgumentMapper.flattenPath((Set)intermediate.get(typeParameterElement), intermediate);
                subtypePath.retainAll(supertypeParams);
                result.put(typeParameterElement, subtypePath);
            }
        }
        return result;
    }

    private static Set<TypeParameterElement> flattenPath(Set<TypeParameterElement> elements, Map<TypeParameterElement, Set<TypeParameterElement>> map) {
        HashSet<TypeParameterElement> result = new HashSet<TypeParameterElement>();
        if (elements != null) {
            for (TypeParameterElement oldElement : elements) {
                Set<TypeParameterElement> substitutions = map.get(oldElement);
                if (substitutions != null) {
                    result.addAll(TypeArgumentMapper.flattenPath(elements, map));
                    continue;
                }
                result.add(oldElement);
            }
        }
        return result;
    }

    private static void addToSetMap(Map<TypeParameterElement, Set<TypeParameterElement>> setMap, TypeParameterElement element, TypeParameterElement typeParam) {
        Set<TypeParameterElement> set = setMap.get(element);
        if (set == null) {
            set = new HashSet<TypeParameterElement>();
            setMap.put(element, set);
        }
        set.add(typeParam);
    }

    private static List<TypeRecord> depthFirstSearchForSupertype(TypeElement subtype, TypeElement target, Types types) {
        Stack<TypeRecord> pathFromRoot = new Stack<TypeRecord>();
        TypeRecord pathStart = new TypeRecord(subtype, null);
        pathFromRoot.push(pathStart);
        List<TypeRecord> result = TypeArgumentMapper.recursiveDepthFirstSearch(pathFromRoot, target, types);
        return result;
    }

    private static List<TypeRecord> recursiveDepthFirstSearch(Stack<TypeRecord> pathFromRoot, TypeElement target, Types types) {
        List<TypeRecord> path = null;
        if (!pathFromRoot.isEmpty()) {
            TypeRecord currentRecord = pathFromRoot.peek();
            TypeElement currentElement = currentRecord.element;
            if (currentElement.equals(target)) {
                return new ArrayList<TypeRecord>(pathFromRoot);
            }
            Iterator<? extends TypeMirror> interfaces = currentElement.getInterfaces().iterator();
            TypeMirror superclassType = currentElement.getSuperclass();
            while (path == null && interfaces.hasNext()) {
                TypeMirror intface = interfaces.next();
                if (intface.getKind() == TypeKind.NONE) continue;
                DeclaredType interfaceDeclared = (DeclaredType)intface;
                pathFromRoot.push(new TypeRecord((TypeElement)types.asElement(interfaceDeclared), interfaceDeclared));
                path = TypeArgumentMapper.recursiveDepthFirstSearch(pathFromRoot, target, types);
                pathFromRoot.pop();
            }
            if (path == null && superclassType != null && superclassType.getKind() != TypeKind.NONE) {
                DeclaredType superclass = (DeclaredType)superclassType;
                pathFromRoot.push(new TypeRecord((TypeElement)types.asElement(superclass), superclass));
                path = TypeArgumentMapper.recursiveDepthFirstSearch(pathFromRoot, target, types);
                pathFromRoot.pop();
            }
        }
        return path;
    }

    private static class TypeRecord {
        public final TypeElement element;
        public final DeclaredType type;

        TypeRecord(TypeElement element, DeclaredType type) {
            this.element = element;
            this.type = type;
        }
    }
}

