/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.typeinference.constraint.TIsU;
import org.checkerframework.framework.util.typeinference.constraint.TSuperU;
import org.checkerframework.framework.util.typeinference.constraint.TUConstraint;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;

public class ConstraintMapBuilder {
    public ConstraintMap build(Set<TypeVariable> targets, Set<TUConstraint> constraints, AnnotatedTypeFactory typeFactory) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        Set<? extends AnnotationMirror> tops = qualifierHierarchy.getTopAnnotations();
        ConstraintMap result = new ConstraintMap(targets);
        LinkedHashSet<AnnotationMirror> tAnnos = new LinkedHashSet<AnnotationMirror>();
        LinkedHashSet<AnnotationMirror> uAnnos = new LinkedHashSet<AnnotationMirror>();
        LinkedHashSet<AnnotationMirror> hierarchiesInRelation = new LinkedHashSet<AnnotationMirror>();
        for (TUConstraint constraint : constraints) {
            AnnotationMirror tAnno;
            tAnnos.clear();
            uAnnos.clear();
            hierarchiesInRelation.clear();
            AnnotatedTypeMirror.AnnotatedTypeVariable typeT = constraint.typeVariable;
            AnnotatedTypeMirror typeU = constraint.relatedType;
            if (typeU.getKind() == TypeKind.TYPEVAR && targets.contains(typeU.getUnderlyingType())) {
                if (typeT.getAnnotations().isEmpty() && typeU.getAnnotations().isEmpty()) {
                    hierarchiesInRelation.addAll(tops);
                } else {
                    for (AnnotationMirror annotationMirror : tops) {
                        tAnno = typeT.getAnnotationInHierarchy(annotationMirror);
                        AnnotationMirror uAnno = typeU.getAnnotationInHierarchy(annotationMirror);
                        if (tAnno == null) {
                            if (uAnno == null) {
                                hierarchiesInRelation.add(annotationMirror);
                                continue;
                            }
                            tAnnos.add(uAnno);
                            continue;
                        }
                        if (uAnno != null) continue;
                        uAnnos.add(tAnno);
                    }
                    if (!tAnnos.isEmpty()) {
                        this.addToPrimaryRelationship(typeT.getUnderlyingType(), constraint, result, tAnnos, qualifierHierarchy);
                    }
                    if (!uAnnos.isEmpty()) {
                        this.addToPrimaryRelationship((TypeVariable)typeU.getUnderlyingType(), constraint, result, uAnnos, qualifierHierarchy);
                    }
                }
                if (typeT.getUnderlyingType().equals(typeU.getUnderlyingType())) continue;
                this.addToTargetRelationship(typeT.getUnderlyingType(), (TypeVariable)typeU.getUnderlyingType(), result, constraint, hierarchiesInRelation);
                continue;
            }
            for (AnnotationMirror annotationMirror : tops) {
                tAnno = typeT.getAnnotationInHierarchy(annotationMirror);
                if (tAnno != null) continue;
                hierarchiesInRelation.add(annotationMirror);
            }
            this.addToTypeRelationship(typeT.getUnderlyingType(), typeU, result, constraint, hierarchiesInRelation);
        }
        return result;
    }

    private void addToTargetRelationship(TypeVariable typeT, TypeVariable typeU, ConstraintMap result, TUConstraint constraint, Set<AnnotationMirror> hierarchiesInRelation) {
        if (constraint instanceof TIsU) {
            result.addTargetEquality(typeT, typeU, hierarchiesInRelation);
        } else if (constraint instanceof TSuperU) {
            result.addTargetSupertype(typeT, typeU, hierarchiesInRelation);
        } else {
            result.addTargetSubtype(typeT, typeU, hierarchiesInRelation);
        }
    }

    public void addToPrimaryRelationship(TypeVariable typeVariable, TUConstraint constraint, ConstraintMap result, Set<AnnotationMirror> annotationMirrors, QualifierHierarchy qualifierHierarchy) {
        if (constraint instanceof TIsU) {
            result.addPrimaryEqualities(typeVariable, qualifierHierarchy, annotationMirrors);
        } else if (constraint instanceof TSuperU) {
            result.addPrimarySupertype(typeVariable, qualifierHierarchy, annotationMirrors);
        } else {
            result.addPrimarySubtypes(typeVariable, qualifierHierarchy, annotationMirrors);
        }
    }

    public void addToTypeRelationship(TypeVariable target, AnnotatedTypeMirror type, ConstraintMap result, TUConstraint constraint, Set<AnnotationMirror> hierarchies) {
        if (constraint instanceof TIsU) {
            result.addTypeEqualities(target, type, hierarchies);
        } else if (constraint instanceof TSuperU) {
            result.addTypeSupertype(target, type, hierarchies);
        } else {
            result.addTypeSubtype(target, type, hierarchies);
        }
    }
}

