/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.HashMap;
import java.util.List;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.poly.ContainmentHierarchy;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.PolyQualHierarchy;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.Wildcard;

public class QualifierParameterHierarchy<Q>
implements QualifierHierarchy<QualParams<Q>> {
    private QualifierHierarchy<PolyQual<Q>> polyQualHierarchy;
    private QualifierHierarchy<Wildcard<Q>> containmentHierarchy;
    private List<Pair<Wildcard<Q>, Wildcard<Q>>> constraintTarget = null;
    public QualParams<Q> PARAMS_BOTTOM;
    public QualParams<Q> PARAMS_TOP;
    static final String PARAMS_BOTTOM_TO_STRING = "__@RegexBottom__";
    static final String PARAMS_TOP_TO_STRING = "__@RegexTop__";

    public QualifierParameterHierarchy(QualifierHierarchy<Wildcard<Q>> containmentHierarchy, QualifierHierarchy<PolyQual<Q>> polyQualHierarchy) {
        this.containmentHierarchy = containmentHierarchy;
        this.polyQualHierarchy = polyQualHierarchy;
        this.setTop(polyQualHierarchy);
        this.setBottom(polyQualHierarchy);
    }

    public static <Q> QualifierParameterHierarchy<Q> fromContainment(QualifierHierarchy<Wildcard<Q>> containmentHierarchy, QualifierHierarchy<PolyQual<Q>> polyQualHierarchy) {
        return new QualifierParameterHierarchy<Q>(containmentHierarchy, polyQualHierarchy);
    }

    public static <Q> QualifierParameterHierarchy<Q> fromPolyQual(QualifierHierarchy<PolyQual<Q>> polyQualHierarchy) {
        return QualifierParameterHierarchy.fromContainment(new ContainmentHierarchy<Q>(polyQualHierarchy), polyQualHierarchy);
    }

    public static <Q> QualifierParameterHierarchy<Q> fromGround(QualifierHierarchy<Q> groundHierarchy) {
        return QualifierParameterHierarchy.fromPolyQual(new PolyQualHierarchy<Q>(groundHierarchy));
    }

    protected QualifierHierarchy<Wildcard<Q>> getContaintmentHierarchy() {
        return this.containmentHierarchy;
    }

    public void setConstraintTarget(List<Pair<Wildcard<Q>, Wildcard<Q>>> constraintTarget) {
        this.constraintTarget = constraintTarget;
    }

    @Override
    public boolean isSubtype(QualParams<Q> subtype, QualParams<Q> supertype) {
        if (subtype.equals(supertype)) {
            return true;
        }
        if (subtype == this.PARAMS_BOTTOM || supertype == this.PARAMS_TOP) {
            return true;
        }
        if (subtype == this.PARAMS_TOP && this.polyQualHierarchy.isSubtype(subtype.getPrimary(), supertype.getPrimary()) && supertype.isEmpty()) {
            return true;
        }
        if (subtype == this.PARAMS_TOP || supertype == this.PARAMS_BOTTOM || !subtype.keySet().equals(supertype.keySet())) {
            if (this.constraintTarget == null) {
                return false;
            }
            this.constraintTarget.add(null);
            return true;
        }
        if (subtype.getPrimary() != null && supertype.getPrimary() != null) {
            if (this.constraintTarget == null) {
                if (!this.polyQualHierarchy.isSubtype(subtype.getPrimary(), supertype.getPrimary())) {
                    return false;
                }
            } else {
                this.constraintTarget.add(Pair.of(new Wildcard<PolyQual<Q>>(subtype.getPrimary()), new Wildcard<PolyQual<Q>>(supertype.getPrimary())));
            }
        }
        for (String k : subtype.keySet()) {
            if (this.constraintTarget == null) {
                if (this.containmentHierarchy.isSubtype((Wildcard<Object>)subtype.get(k), (Wildcard<Object>)supertype.get(k))) continue;
                return false;
            }
            this.constraintTarget.add(Pair.of(subtype.get(k), supertype.get(k)));
        }
        return true;
    }

    @Override
    public QualParams<Q> leastUpperBound(QualParams<Q> a, QualParams<Q> b) {
        if (this.constraintTarget != null) {
            throw new UnsupportedOperationException("unexpected leastUpperBound when generating constraints");
        }
        if (a == this.PARAMS_BOTTOM) {
            return b;
        }
        if (b == this.PARAMS_BOTTOM) {
            return a;
        }
        if (a == this.PARAMS_TOP || b == this.PARAMS_TOP) {
            return this.PARAMS_TOP;
        }
        HashMap result = new HashMap();
        for (String k : a.keySet()) {
            if (b.containsKey(k)) {
                result.put(k, this.containmentHierarchy.leastUpperBound((Wildcard<Object>)a.get(k), (Wildcard<Object>)b.get(k)));
                continue;
            }
            result.put(k, a.get(k));
        }
        for (String k : b.keySet()) {
            if (a.containsKey(k)) continue;
            result.put(k, b.get(k));
        }
        PolyQual<Q> newPrimary = null;
        if (a.getPrimary() != null && b.getPrimary() != null) {
            newPrimary = this.polyQualHierarchy.leastUpperBound(a.getPrimary(), b.getPrimary());
        }
        return new QualParams(result, newPrimary);
    }

    @Override
    public QualParams<Q> greatestLowerBound(QualParams<Q> a, QualParams<Q> b) {
        if (this.constraintTarget != null) {
            throw new UnsupportedOperationException("unexpected leastUpperBound when generating constraints");
        }
        if (a == this.PARAMS_TOP) {
            return b;
        }
        if (b == this.PARAMS_TOP) {
            return a;
        }
        if (a == this.PARAMS_BOTTOM || b == this.PARAMS_BOTTOM) {
            return this.PARAMS_BOTTOM;
        }
        HashMap result = new HashMap();
        for (String k : a.keySet()) {
            if (b.containsKey(k)) {
                result.put(k, this.containmentHierarchy.greatestLowerBound((Wildcard<Object>)a.get(k), (Wildcard<Object>)b.get(k)));
                continue;
            }
            result.put(k, a.get(k));
        }
        for (String k : b.keySet()) {
            if (a.containsKey(k)) continue;
            result.put(k, b.get(k));
        }
        PolyQual<Q> newPrimary = null;
        if (a.getPrimary() != null && b.getPrimary() != null) {
            newPrimary = this.polyQualHierarchy.greatestLowerBound(a.getPrimary(), b.getPrimary());
        }
        return new QualParams(result, newPrimary);
    }

    private void setTop(QualifierHierarchy<PolyQual<Q>> polyQualHierarchy) {
        this.PARAMS_TOP = new QualParams<Q>(polyQualHierarchy.getTop()){

            @Override
            public String toString() {
                return QualifierParameterHierarchy.PARAMS_TOP_TO_STRING;
            }
        };
    }

    private void setBottom(QualifierHierarchy<PolyQual<Q>> polyQualHierarchy) {
        this.PARAMS_BOTTOM = new QualParams<Q>(polyQualHierarchy.getBottom()){

            @Override
            public String toString() {
                return QualifierParameterHierarchy.PARAMS_BOTTOM_TO_STRING;
            }
        };
    }

    @Override
    public QualParams<Q> getBottom() {
        return this.PARAMS_BOTTOM;
    }

    @Override
    public QualParams<Q> getTop() {
        return this.PARAMS_TOP;
    }
}

