/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometryCollectionIterator
implements Iterator {
    private Geometry parent;
    private boolean atStart;
    private int max;
    private int index;
    private GeometryCollectionIterator subcollectionIterator;

    public GeometryCollectionIterator(Geometry parent) {
        this.parent = parent;
        this.atStart = true;
        this.index = 0;
        this.max = parent.getNumGeometries();
    }

    @Override
    public boolean hasNext() {
        if (this.atStart) {
            return true;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return true;
            }
            this.subcollectionIterator = null;
        }
        return this.index < this.max;
    }

    public Object next() {
        Geometry obj;
        if (this.atStart) {
            this.atStart = false;
            if (GeometryCollectionIterator.isAtomic(this.parent)) {
                ++this.index;
            }
            return this.parent;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return this.subcollectionIterator.next();
            }
            this.subcollectionIterator = null;
        }
        if (this.index >= this.max) {
            throw new NoSuchElementException();
        }
        if ((obj = this.parent.getGeometryN(this.index++)) instanceof GeometryCollection) {
            this.subcollectionIterator = new GeometryCollectionIterator((GeometryCollection)obj);
            return this.subcollectionIterator.next();
        }
        return obj;
    }

    private static boolean isAtomic(Geometry geom) {
        return !(geom instanceof GeometryCollection);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

