/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.knnJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.knnJudgement.GeometryDistanceComparator;

public class KnnJudgement
implements FlatMapFunction<Iterator<Object>, Object>,
Serializable {
    int k;
    Point queryCenter;

    public KnnJudgement(Point queryCenter, int k) {
        this.queryCenter = queryCenter;
        this.k = k;
    }

    public Iterator<Object> call(Iterator<Object> input) throws Exception {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(this.k, new GeometryDistanceComparator(this.queryCenter, false));
        while (input.hasNext()) {
            if (pq.size() < this.k) {
                pq.offer(input.next());
                continue;
            }
            Geometry curpoint = (Geometry)input.next();
            double distance = curpoint.distance(this.queryCenter);
            double largestDistanceInPriQueue = ((Geometry)pq.peek()).distance(this.queryCenter);
            if (!(largestDistanceInPriQueue > distance)) continue;
            pq.poll();
            pq.offer(curpoint);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < this.k; ++i) {
            res.add(pq.poll());
        }
        return res.iterator();
    }
}

