/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.knnJudgement;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.GeometryItemDistance;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;

public class KnnJudgementUsingIndex
implements FlatMapFunction<Iterator<Object>, Object>,
Serializable {
    int k;
    Point queryCenter;

    public KnnJudgementUsingIndex(Point queryCenter, int k) {
        this.queryCenter = queryCenter;
        this.k = k;
    }

    public Iterator<Object> call(Iterator<Object> treeIndexes) throws Exception {
        GeometryFactory fact = new GeometryFactory();
        Object treeIndex = treeIndexes.next();
        Object[] localK = null;
        if (!(treeIndex instanceof STRtree)) {
            throw new Exception("[KnnJudgementUsingIndex][Call] QuadTree index doesn't support KNN search.");
        }
        localK = ((STRtree)treeIndex).kNearestNeighbour(this.queryCenter.getEnvelopeInternal(), this.queryCenter, new GeometryItemDistance(), this.k);
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < localK.length; ++i) {
            result.add(localK[i]);
        }
        return result.iterator();
    }
}

