/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialOperator;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.datasyslab.geospark.geometryObjects.Circle;
import org.datasyslab.geospark.geometryObjects.PairGeometry;
import org.datasyslab.geospark.joinJudgement.GeometryByCircleJudgement;
import org.datasyslab.geospark.joinJudgement.GeometryByCircleJudgementUsingIndex;
import org.datasyslab.geospark.joinJudgement.GeometryByPolygonJudgement;
import org.datasyslab.geospark.joinJudgement.GeometryByPolygonJudgementUsingIndex;
import org.datasyslab.geospark.spatialPartitioning.DuplicatesHandler;
import org.datasyslab.geospark.spatialRDD.CircleRDD;
import org.datasyslab.geospark.spatialRDD.LineStringRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;
import scala.Tuple2;

public class JoinQuery
implements Serializable {
    private static JavaPairRDD<Polygon, HashSet<Geometry>> executeSpatialJoinUsingIndex(SpatialRDD spatialRDD, SpatialRDD queryRDD, boolean considerBoundaryIntersection) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]one input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new Exception("[JoinQuery][SpatialJoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
        if (spatialRDD.indexedRDD == null) {
            throw new Exception("[JoinQuery][SpatialJoinQuery] Index doesn't exist. Please build index.");
        }
        if (spatialRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        }
        if (queryRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        }
        if (queryRDD.grids != null && spatialRDD.grids != null && !queryRDD.grids.equals(spatialRDD.grids)) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        JavaRDD cogroupResult = spatialRDD.indexedRDD.zipPartitions(queryRDD.spatialPartitionedRDD, (FlatMapFunction2)new GeometryByPolygonJudgementUsingIndex(considerBoundaryIntersection));
        JavaPairRDD joinResultWithDuplicates = cogroupResult.mapToPair((PairFunction)new PairFunction<PairGeometry, Polygon, HashSet<Geometry>>(){

            public Tuple2<Polygon, HashSet<Geometry>> call(PairGeometry pairGeometry) throws Exception {
                return pairGeometry.getPolygonTuple2();
            }
        });
        return DuplicatesHandler.removeDuplicatesGeometryByPolygon((JavaPairRDD<Polygon, HashSet<Geometry>>)joinResultWithDuplicates);
    }

    private static JavaPairRDD<Polygon, HashSet<Geometry>> executeSpatialJoinNoIndex(SpatialRDD spatialRDD, SpatialRDD queryRDD, boolean considerBoundaryIntersection) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]one input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new Exception("[JoinQuery][SpatialJoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
        if (spatialRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        }
        if (queryRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        }
        if (queryRDD.grids != null && spatialRDD.grids != null && !queryRDD.grids.equals(spatialRDD.grids)) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        assert (spatialRDD.spatialPartitionedRDD.getNumPartitions() == queryRDD.spatialPartitionedRDD.getNumPartitions());
        JavaRDD cogroupResult = spatialRDD.spatialPartitionedRDD.zipPartitions(queryRDD.spatialPartitionedRDD, (FlatMapFunction2)new GeometryByPolygonJudgement(considerBoundaryIntersection));
        JavaPairRDD joinResultWithDuplicates = cogroupResult.mapToPair((PairFunction)new PairFunction<PairGeometry, Polygon, HashSet<Geometry>>(){

            public Tuple2<Polygon, HashSet<Geometry>> call(PairGeometry pairGeometry) throws Exception {
                return pairGeometry.getPolygonTuple2();
            }
        });
        return DuplicatesHandler.removeDuplicatesGeometryByPolygon((JavaPairRDD<Polygon, HashSet<Geometry>>)joinResultWithDuplicates);
    }

    private static JavaPairRDD<Circle, HashSet<Geometry>> executeDistanceJoinUsingIndex(SpatialRDD spatialRDD, SpatialRDD queryRDD, boolean considerBoundaryIntersection) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]one input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new Exception("[JoinQuery][DistanceJoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
        if (spatialRDD.indexedRDD == null) {
            throw new Exception("[JoinQuery][DistanceJoinQuery] Index doesn't exist. Please build index.");
        }
        if (spatialRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        }
        if (queryRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        }
        if (queryRDD.grids != null && spatialRDD.grids != null && !queryRDD.grids.equals(spatialRDD.grids)) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        JavaRDD cogroupResult = spatialRDD.indexedRDD.zipPartitions(queryRDD.spatialPartitionedRDD, (FlatMapFunction2)new GeometryByCircleJudgementUsingIndex(considerBoundaryIntersection));
        JavaPairRDD joinResultWithDuplicates = cogroupResult.mapToPair((PairFunction)new PairFunction<PairGeometry, Circle, HashSet<Geometry>>(){

            public Tuple2<Circle, HashSet<Geometry>> call(PairGeometry pairGeometry) throws Exception {
                return pairGeometry.getCircleTuple2();
            }
        });
        return DuplicatesHandler.removeDuplicatesGeometryByCircle((JavaPairRDD<Circle, HashSet<Geometry>>)joinResultWithDuplicates);
    }

    private static JavaPairRDD<Circle, HashSet<Geometry>> executeDistanceJoinNoIndex(SpatialRDD spatialRDD, SpatialRDD queryRDD, boolean considerBoundaryIntersection) throws Exception {
        if (spatialRDD.getCRStransformation() != queryRDD.getCRStransformation()) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]one input RDD doesn't perform necessary CRS transformation. Please check your RDD constructors.");
        }
        if (spatialRDD.getCRStransformation() && queryRDD.getCRStransformation() && !spatialRDD.getTargetEpgsgCode().equalsIgnoreCase(queryRDD.getTargetEpgsgCode())) {
            throw new Exception("[JoinQuery][DistanceJoinQuery] the EPSG codes of two input RDDs are different. Please check your RDD constructors.");
        }
        if (spatialRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]spatialRDD SpatialPartitionedRDD is null. Please do spatial partitioning.");
        }
        if (queryRDD.spatialPartitionedRDD == null) {
            throw new Exception("[JoinQuery][DistanceJoinQuery]queryRDD SpatialPartitionedRDD is null. Please use the spatialRDD's grids to do spatial partitioning.");
        }
        if (queryRDD.grids != null && spatialRDD.grids != null && !queryRDD.grids.equals(spatialRDD.grids)) {
            throw new Exception("[JoinQuery][SpatialJoinQuery]queryRDD is not partitioned by the same grids with spatialRDD. Please make sure they both use the same grids otherwise wrong results will appear.");
        }
        JavaRDD cogroupResult = spatialRDD.spatialPartitionedRDD.zipPartitions(queryRDD.spatialPartitionedRDD, (FlatMapFunction2)new GeometryByCircleJudgement(considerBoundaryIntersection));
        JavaPairRDD joinResultWithDuplicates = cogroupResult.mapToPair((PairFunction)new PairFunction<PairGeometry, Circle, HashSet<Geometry>>(){

            public Tuple2<Circle, HashSet<Geometry>> call(PairGeometry pairGeometry) throws Exception {
                return pairGeometry.getCircleTuple2();
            }
        });
        return DuplicatesHandler.removeDuplicatesGeometryByCircle((JavaPairRDD<Circle, HashSet<Geometry>>)joinResultWithDuplicates);
    }

    public static JavaPairRDD<Polygon, HashSet<Point>> SpatialJoinQuery(PointRDD spatialRDD, RectangleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Point>>(){

                public HashSet<Point> call(HashSet<Geometry> spatialObjects) throws Exception {
                    HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                    Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                    while (spatialObjectIterator.hasNext()) {
                        castedSpatialObjects.add((Point)spatialObjectIterator.next());
                    }
                    return castedSpatialObjects;
                }
            });
            return castedResult;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Point>>(){

            public HashSet<Point> call(HashSet<Geometry> spatialObjects) throws Exception {
                HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                while (spatialObjectIterator.hasNext()) {
                    castedSpatialObjects.add((Point)spatialObjectIterator.next());
                }
                return castedSpatialObjects;
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, HashSet<Polygon>> SpatialJoinQuery(RectangleRDD spatialRDD, RectangleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Polygon>>(){

                public HashSet<Polygon> call(HashSet<Geometry> spatialObjects) throws Exception {
                    HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                    Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                    while (spatialObjectIterator.hasNext()) {
                        castedSpatialObjects.add((Polygon)spatialObjectIterator.next());
                    }
                    return castedSpatialObjects;
                }
            });
            return castedResult;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Polygon>>(){

            public HashSet<Polygon> call(HashSet<Geometry> spatialObjects) throws Exception {
                HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                while (spatialObjectIterator.hasNext()) {
                    castedSpatialObjects.add((Polygon)spatialObjectIterator.next());
                }
                return castedSpatialObjects;
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, HashSet<Point>> SpatialJoinQuery(PointRDD spatialRDD, PolygonRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Polygon, HashSet<Geometry>>, Polygon, HashSet<Point>>(){

                public Tuple2<Polygon, HashSet<Point>> call(Tuple2<Polygon, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                    for (Point castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2(pairObjects._1, castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Point>>(){

            public HashSet<Point> call(HashSet<Geometry> spatialObjects) throws Exception {
                HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                while (spatialObjectIterator.hasNext()) {
                    castedSpatialObjects.add((Point)spatialObjectIterator.next());
                }
                return castedSpatialObjects;
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, HashSet<Polygon>> SpatialJoinQuery(PolygonRDD spatialRDD, PolygonRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Polygon, HashSet<Geometry>>, Polygon, HashSet<Polygon>>(){

                public Tuple2<Polygon, HashSet<Polygon>> call(Tuple2<Polygon, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                    for (Polygon castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2(pairObjects._1, castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<Polygon>>(){

            public HashSet<Polygon> call(HashSet<Geometry> spatialObjects) throws Exception {
                HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                while (spatialObjectIterator.hasNext()) {
                    castedSpatialObjects.add((Polygon)spatialObjectIterator.next());
                }
                return castedSpatialObjects;
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, HashSet<LineString>> SpatialJoinQuery(LineStringRDD spatialRDD, PolygonRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Polygon, HashSet<Geometry>>, Polygon, HashSet<LineString>>(){

                public Tuple2<Polygon, HashSet<LineString>> call(Tuple2<Polygon, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                    for (LineString castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2(pairObjects._1, castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, HashSet<LineString>>(){

            public HashSet<LineString> call(HashSet<Geometry> spatialObjects) throws Exception {
                HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                Iterator<Geometry> spatialObjectIterator = spatialObjects.iterator();
                while (spatialObjectIterator.hasNext()) {
                    castedSpatialObjects.add((LineString)spatialObjectIterator.next());
                }
                return castedSpatialObjects;
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, Long> SpatialJoinQueryCountByKey(SpatialRDD spatialRDD, PolygonRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD resultCountByKey = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Polygon, HashSet<Geometry>>, Polygon, Long>(){

                public Tuple2<Polygon, Long> call(Tuple2<Polygon, HashSet<Geometry>> pairObjects) throws Exception {
                    Iterator spatialObjectIterator = ((HashSet)pairObjects._2).iterator();
                    long count = 0L;
                    while (spatialObjectIterator.hasNext()) {
                        Geometry castedSpatialObject = (Geometry)spatialObjectIterator.next();
                        ++count;
                    }
                    return new Tuple2(pairObjects._1, (Object)count);
                }
            });
            return resultCountByKey;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD resultCountByKey = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, Long>(){

            public Long call(HashSet<Geometry> spatialObjects) throws Exception {
                return spatialObjects.size();
            }
        });
        return resultCountByKey;
    }

    public static JavaPairRDD<Polygon, Long> SpatialJoinQueryCountByKey(SpatialRDD spatialRDD, RectangleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD resultCountByKey = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, Long>(){

                public Long call(HashSet<Geometry> spatialObjects) throws Exception {
                    return spatialObjects.size();
                }
            });
            return resultCountByKey;
        }
        JavaPairRDD<Polygon, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeSpatialJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD resultCountByKey = joinListResultAfterAggregation.mapValues((Function)new Function<HashSet<Geometry>, Long>(){

            public Long call(HashSet<Geometry> spatialObjects) throws Exception {
                return spatialObjects.size();
            }
        });
        return resultCountByKey;
    }

    public static JavaPairRDD<Polygon, HashSet<Polygon>> DistanceJoinQuery(PolygonRDD spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Polygon, HashSet<Polygon>>(){

                public Tuple2<Polygon, HashSet<Polygon>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                    for (Polygon castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((Polygon)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Polygon, HashSet<Polygon>>(){

            public Tuple2<Polygon, HashSet<Polygon>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                for (Polygon castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((Polygon)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Point, HashSet<Point>> DistanceJoinQuery(PointRDD spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Point, HashSet<Point>>(){

                public Tuple2<Point, HashSet<Point>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                    for (Point castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((Point)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Point, HashSet<Point>>(){

            public Tuple2<Point, HashSet<Point>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                for (Point castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((Point)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<LineString, HashSet<LineString>> DistanceJoinQuery(LineStringRDD spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, LineString, HashSet<LineString>>(){

                public Tuple2<LineString, HashSet<LineString>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                    for (LineString castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((LineString)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, LineString, HashSet<LineString>>(){

            public Tuple2<LineString, HashSet<LineString>> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                for (LineString castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((LineString)((Circle)pairObjects._1).getCenterGeometry()), castedSpatialObjects);
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Polygon, Long> DistanceJoinQueryCountByKey(PolygonRDD spatialRDD, CircleRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Polygon, Long>(){

                public Tuple2<Polygon, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                    for (Polygon castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((Polygon)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Polygon, Long>(){

            public Tuple2<Polygon, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<Polygon> castedSpatialObjects = new HashSet<Polygon>();
                for (Polygon castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((Polygon)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<Point, Long> DistanceJoinQueryCountByKey(PointRDD spatialRDD, PointRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Point, Long>(){

                public Tuple2<Point, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                    for (Point castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((Point)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, Point, Long>(){

            public Tuple2<Point, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<Point> castedSpatialObjects = new HashSet<Point>();
                for (Point castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((Point)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
            }
        });
        return castedResult;
    }

    public static JavaPairRDD<LineString, Long> DistanceJoinQueryCountByKey(LineStringRDD spatialRDD, LineStringRDD queryRDD, boolean useIndex, boolean considerBoundaryIntersection) throws Exception {
        if (useIndex) {
            JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinUsingIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
            JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, LineString, Long>(){

                public Tuple2<LineString, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                    HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                    for (LineString castedSpatialObject : (HashSet)pairObjects._2) {
                        castedSpatialObjects.add(castedSpatialObject);
                    }
                    return new Tuple2((Object)((LineString)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
                }
            });
            return castedResult;
        }
        JavaPairRDD<Circle, HashSet<Geometry>> joinListResultAfterAggregation = JoinQuery.executeDistanceJoinNoIndex(spatialRDD, queryRDD, considerBoundaryIntersection);
        JavaPairRDD castedResult = joinListResultAfterAggregation.mapToPair((PairFunction)new PairFunction<Tuple2<Circle, HashSet<Geometry>>, LineString, Long>(){

            public Tuple2<LineString, Long> call(Tuple2<Circle, HashSet<Geometry>> pairObjects) throws Exception {
                HashSet<LineString> castedSpatialObjects = new HashSet<LineString>();
                for (LineString castedSpatialObject : (HashSet)pairObjects._2) {
                    castedSpatialObjects.add(castedSpatialObject);
                }
                return new Tuple2((Object)((LineString)((Circle)pairObjects._1).getCenterGeometry()), (Object)castedSpatialObjects.size());
            }
        });
        return castedResult;
    }
}

