/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;

/**
 * write the content into the content stream.
 *
 */
public interface IReportContentWriter
{
	public void close( );

	public long getOffset( );

	public long writeContent( IContent content ) throws IOException;
	
	public long writeFullContent( IContent content ) throws IOException,
			BirtException;
}
