/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.packager.io.IOConsumer;
import org.eclipse.packager.io.SpoolOutTarget;

public class FileSystemSpoolOutTarget
implements SpoolOutTarget {
    private final Path basePath;

    public FileSystemSpoolOutTarget(Path basePath) {
        this.basePath = basePath;
    }

    @Override
    public void spoolOut(String fileName, String mimeType, IOConsumer<OutputStream> streamConsumer) throws IOException {
        Path path = this.basePath.resolve(fileName);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            streamConsumer.accept(stream);
        }
    }
}

