/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.concurrent.CountDownLatch;
import org.elasticsearch.action.ActionListener;

public class LatchedActionListener<T>
implements ActionListener<T> {
    private final ActionListener<T> delegate;
    private final CountDownLatch latch;

    public LatchedActionListener(ActionListener<T> delegate, CountDownLatch latch) {
        this.delegate = delegate;
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(T t) {
        try {
            this.delegate.onResponse(t);
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable e) {
        try {
            this.delegate.onFailure(e);
        }
        finally {
            this.latch.countDown();
        }
    }
}

