/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.sum;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalSum
extends InternalNumericMetricsAggregation.SingleValue
implements Sum {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("sum");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalSum readResult(StreamInput in) throws IOException {
            InternalSum result = new InternalSum();
            result.readFrom(in);
            return result;
        }
    };
    private double sum;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalSum() {
    }

    InternalSum(String name, double sum, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.sum = sum;
        this.valueFormatter = formatter;
    }

    @Override
    public double value() {
        return this.sum;
    }

    @Override
    public double getValue() {
        return this.sum;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalSum doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double sum = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            sum += ((InternalSum)aggregation).sum;
        }
        return new InternalSum(this.name, sum, this.valueFormatter, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.sum = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.sum);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(InternalAggregation.CommonFields.VALUE, this.sum);
        if (!(this.valueFormatter instanceof ValueFormatter.Raw)) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.sum));
        }
        return builder;
    }
}

